/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.spi.java.queries.MultipleRootsUnitTestForSourceQueryImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.filesystems.FileObject;

public class UnitTestForSourceQueryImpl
implements MultipleRootsUnitTestForSourceQueryImplementation {
    private NbModuleProject project;

    public UnitTestForSourceQueryImpl(NbModuleProject nbModuleProject) {
        this.project = nbModuleProject;
    }

    public URL[] findUnitTests(FileObject fileObject) {
        return this.find(fileObject, "src.dir", "test.unit.src.dir");
    }

    public URL[] findSources(FileObject fileObject) {
        return this.find(fileObject, "test.unit.src.dir", "src.dir");
    }

    private URL[] find(FileObject fileObject, String string, String string2) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        AntProjectHelper antProjectHelper = this.project.getHelper();
        String string3 = this.project.evaluator().getProperty(string);
        assert (string3 != null) : "No value for " + string + " in " + this.project;
        FileObject fileObject2 = antProjectHelper.resolveFileObject(string3);
        if (!fileObject.equals(fileObject2)) {
            return null;
        }
        string3 = this.project.evaluator().getProperty(string2);
        assert (string3 != null) : "No value for " + string2 + " in " + this.project;
        try {
            File file = antProjectHelper.resolveFile(string3);
            if (!file.exists()) {
                URI uRI = file.toURI();
                String string4 = uRI.getPath();
                if (!string4.endsWith("/")) {
                    string4 = string4.concat("/");
                }
                try {
                    uRI = new URI(uRI.getScheme(), uRI.getHost(), string4, uRI.getFragment());
                    return new URL[]{uRI.toURL()};
                }
                catch (URISyntaxException uRISyntaxException) {
                    Logger.getLogger(UnitTestForSourceQueryImpl.class.getName()).log(Level.WARNING, "Problems getting URI for " + file, uRISyntaxException);
                }
            }
            return new URL[]{file.toURI().toURL()};
        }
        catch (MalformedURLException malformedURLException) {
            throw new AssertionError((Object)malformedURLException);
        }
    }
}

