/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collections;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.ImportantFilesNodeFactory;
import org.netbeans.modules.apisupport.project.ui.SuiteLogicalView;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.ui.wizard.NewNbModuleWizardIterator;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CookieAction;
import org.openide.util.actions.NodeAction;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;

public class ModulesNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project project) {
        SuiteProject suiteProject = (SuiteProject)project.getLookup().lookup(SuiteProject.class);
        assert (suiteProject != null);
        return NodeFactorySupport.fixedNodeList((Node[])new Node[]{new ModulesNode(suiteProject)});
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(SuiteLogicalView.class, (String)string);
    }

    private static final class OpenProjectAction
    extends CookieAction {
        private OpenProjectAction() {
        }

        protected void performAction(Node[] nodeArray) {
            final Project[] projectArray = new Project[nodeArray.length];
            for (int i = 0; i < nodeArray.length; ++i) {
                Project project;
                projectArray[i] = project = (Project)nodeArray[i].getLookup().lookup(Project.class);
            }
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    StatusDisplayer.getDefault().setStatusText(ModulesNodeFactory.getMessage("MSG_OpeningProjects"));
                    OpenProjects.getDefault().open(projectArray, false);
                }
            });
        }

        public String getName() {
            return ModulesNodeFactory.getMessage("CTL_OpenProject");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        protected boolean asynchronous() {
            return false;
        }

        protected int mode() {
            return 4;
        }

        protected Class[] cookieClasses() {
            return new Class[]{Project.class};
        }
    }

    private static final class RemoveSuiteComponentAction
    extends NodeAction {
        private RemoveSuiteComponentAction() {
        }

        protected void performAction(Node[] nodeArray) {
            for (int i = 0; i < nodeArray.length; ++i) {
                NbModuleProject nbModuleProject = (NbModuleProject)nodeArray[i].getLookup().lookup(NbModuleProject.class);
                assert (nbModuleProject != null) : "NbModuleProject in lookup";
                boolean bl = true;
                try {
                    NbModuleProject[] nbModuleProjectArray = SuiteUtils.getDependentModules(nbModuleProject);
                    if (nbModuleProjectArray.length > 0) {
                        StringBuffer stringBuffer = new StringBuffer("<ul>");
                        for (int j = 0; j < nbModuleProjectArray.length; ++j) {
                            stringBuffer.append("<li>" + ProjectUtils.getInformation((Project)nbModuleProjectArray[j]).getDisplayName() + "</li>");
                        }
                        stringBuffer.append("</ul>");
                        String string = ProjectUtils.getInformation((Project)nbModuleProject).getDisplayName();
                        String string2 = NbBundle.getMessage(SuiteLogicalView.class, (String)"MSG_RemovingModuleMessage", (Object)string, (Object)stringBuffer.toString());
                        bl = UIUtil.showAcceptCancelDialog(NbBundle.getMessage(SuiteLogicalView.class, (String)"CTL_RemovingModuleTitle", (Object)string), string2, ModulesNodeFactory.getMessage("CTL_RemoveDependency"), null, 3);
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger(ModulesNodeFactory.class.getName()).log(Level.INFO, null, iOException);
                }
                if (!bl) continue;
                try {
                    SuiteUtils.removeModuleFromSuiteWithDependencies(nbModuleProject);
                    continue;
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }

        protected boolean enable(Node[] nodeArray) {
            return true;
        }

        public String getName() {
            return ModulesNodeFactory.getMessage("CTL_RemoveModule");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        protected boolean asynchronous() {
            return false;
        }
    }

    private static final class SuiteComponentNode
    extends AbstractNode {
        private static final Action REMOVE_ACTION = new RemoveSuiteComponentAction();
        private static final Action OPEN_ACTION = new OpenProjectAction();

        public SuiteComponentNode(NbModuleProject nbModuleProject) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{nbModuleProject}));
            ProjectInformation projectInformation = ProjectUtils.getInformation((Project)nbModuleProject);
            this.setName(projectInformation.getName());
            this.setDisplayName(projectInformation.getDisplayName());
            this.setIconBaseWithExtension("org/netbeans/modules/apisupport/project/resources/module.png");
            projectInformation.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                    ImportantFilesNodeFactory.getNodesSyncRP().post(new Runnable(){

                        public void run() {
                            if ("displayName".equals(propertyChangeEvent.getPropertyName())) {
                                SuiteComponentNode.this.setDisplayName((String)propertyChangeEvent.getNewValue());
                            } else if ("name".equals(propertyChangeEvent.getPropertyName())) {
                                SuiteComponentNode.this.setName((String)propertyChangeEvent.getNewValue());
                            }
                        }
                    });
                }
            });
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{OPEN_ACTION, REMOVE_ACTION};
        }

        public Action getPreferredAction() {
            return OPEN_ACTION;
        }
    }

    static final class AddNewLibraryWrapperAction
    extends AbstractAction {
        private final Project suiteProvider;
        private final NbModuleProject target;

        public AddNewLibraryWrapperAction(Project project, NbModuleProject nbModuleProject) {
            super(ModulesNodeFactory.getMessage("CTL_AddNewLibrary"));
            this.suiteProvider = project;
            this.target = nbModuleProject;
        }

        public AddNewLibraryWrapperAction(Project project) {
            this(project, null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                NbModuleProject nbModuleProject = UIUtil.runLibraryWrapperWizard(this.suiteProvider);
                if (nbModuleProject != null && this.target != null) {
                    try {
                        Util.addDependency(this.target, nbModuleProject);
                        ProjectManager.getDefault().saveProject((Project)this.target);
                    }
                    catch (IOException iOException) {
                        if ($assertionsDisabled) break block3;
                        throw new AssertionError((Object)iOException);
                    }
                }
            }
        }
    }

    private static final class AddNewSuiteComponentAction
    extends AbstractAction {
        private final SuiteProject suite;

        public AddNewSuiteComponentAction(SuiteProject suiteProject) {
            super(ModulesNodeFactory.getMessage("CTL_AddNewModule"));
            this.suite = suiteProject;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NewNbModuleWizardIterator newNbModuleWizardIterator = NewNbModuleWizardIterator.createSuiteComponentIterator(this.suite);
            UIUtil.runProjectWizard(newNbModuleWizardIterator, "CTL_NewModuleProject");
        }
    }

    private static final class AddSuiteComponentAction
    extends AbstractAction {
        private final SuiteProject suite;

        public AddSuiteComponentAction(SuiteProject suiteProject) {
            super(ModulesNodeFactory.getMessage("CTL_AddModule"));
            this.suite = suiteProject;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NbModuleProject nbModuleProject = UIUtil.chooseSuiteComponent(WindowManager.getDefault().getMainWindow(), this.suite);
            if (nbModuleProject != null) {
                if (!SuiteUtils.contains(this.suite, nbModuleProject)) {
                    try {
                        SuiteUtils.addModule(this.suite, nbModuleProject);
                        ProjectManager.getDefault().saveProject((Project)this.suite);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                } else {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SuiteLogicalView.class, (String)"MSG_SuiteAlreadyContainsCNB", (Object)nbModuleProject.getCodeNameBase())));
                }
            }
        }
    }

    static final class ModulesNode
    extends AbstractNode {
        private SuiteProject suite;

        ModulesNode(SuiteProject suiteProject) {
            super((Children)new ModuleChildren(suiteProject), Lookups.fixed((Object[])new Object[]{suiteProject}));
            this.suite = suiteProject;
            this.setName("modules");
            this.setDisplayName(ModulesNodeFactory.getMessage("CTL_Modules"));
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{new AddNewSuiteComponentAction(this.suite), new AddNewLibraryWrapperAction(this.suite), new AddSuiteComponentAction(this.suite)};
        }

        private Image getIcon(boolean bl) {
            Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/apisupport/project/suite/resources/module-badge.png", (boolean)true);
            return ImageUtilities.mergeImages((Image)UIUtil.getTreeFolderIcon(bl), (Image)image, (int)9, (int)9);
        }

        public Image getIcon(int n) {
            return this.getIcon(false);
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(true);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class ModuleChildren
        extends Children.Keys<NbModuleProject>
        implements ChangeListener {
            private final SuiteProject suite;

            public ModuleChildren(SuiteProject suiteProject) {
                ((SubprojectProvider)suiteProject.getLookup().lookup(SubprojectProvider.class)).addChangeListener((ChangeListener)this);
                this.suite = suiteProject;
            }

            protected void addNotify() {
                this.updateKeys();
            }

            private void updateKeys() {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        TreeSet<Project> treeSet = new TreeSet<Project>(Util.projectDisplayNameComparator());
                        treeSet.addAll(SuiteUtils.getSubProjects(ModuleChildren.this.suite));
                        ModuleChildren.this.setKeys(treeSet);
                    }
                });
            }

            protected void removeNotify() {
                ((SubprojectProvider)this.suite.getLookup().lookup(SubprojectProvider.class)).removeChangeListener((ChangeListener)this);
                this.setKeys(Collections.emptySet());
            }

            protected Node[] createNodes(NbModuleProject nbModuleProject) {
                return new Node[]{new SuiteComponentNode(nbModuleProject)};
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                this.updateKeys();
            }
        }
    }
}

