/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

final class ShowJavadocAction
extends NodeAction {
    ShowJavadocAction() {
    }

    protected void performAction(Node[] nodeArray) {
        if (nodeArray.length != 1) {
            return;
        }
        JavadocProvider javadocProvider = (JavadocProvider)nodeArray[0].getLookup().lookup(JavadocProvider.class);
        if (javadocProvider == null) {
            return;
        }
        javadocProvider.showJavadoc();
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray.length != 1) {
            return false;
        }
        JavadocProvider javadocProvider = (JavadocProvider)nodeArray[0].getLookup().lookup(JavadocProvider.class);
        if (javadocProvider == null) {
            return false;
        }
        return javadocProvider.hasJavadoc();
    }

    public final String getName() {
        return NbBundle.getMessage(ShowJavadocAction.class, (String)"CTL_ShowJavadoc");
    }

    public final HelpCtx getHelpCtx() {
        return new HelpCtx(ShowJavadocAction.class);
    }

    public final boolean asynchronous() {
        return false;
    }

    static void showJavaDoc(URL uRL, String string) {
        if (uRL != null) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
        } else {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ShowJavadocAction.class, (String)"TXT_NoJavadoc", (Object)string));
        }
    }

    static URL findJavadoc(String string, URL[] uRLArray) {
        for (int i = 0; i < uRLArray.length; ++i) {
            String string2 = uRLArray[i].toExternalForm();
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            try {
                URL uRL = new URL(string2 + string);
                FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                if (fileObject == null) continue;
                return uRL;
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().log(65536, "Cannot create URL for " + string2 + string + ". " + malformedURLException.toString());
            }
        }
        return null;
    }

    public static interface JavadocProvider {
        public boolean hasJavadoc();

        public void showJavadoc();
    }
}

