/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.queries.ModuleProjectClassPathExtender;
import org.netbeans.modules.apisupport.project.ui.ActionFilterNode;
import org.netbeans.modules.apisupport.project.ui.ImportantFilesNodeFactory;
import org.netbeans.modules.apisupport.project.ui.LibrariesNode;
import org.netbeans.modules.apisupport.project.ui.LibrariesSourceGroup;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.AddModulePanel;
import org.netbeans.modules.apisupport.project.ui.customizer.EditTestDependencyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.TestModuleDependency;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

final class UnitTestLibrariesNode
extends AbstractNode {
    private final String testType;
    private final NbModuleProject project;
    private boolean missingJUnit4;

    public UnitTestLibrariesNode(String string, NbModuleProject nbModuleProject) {
        super((Children)new LibrariesChildren(string, nbModuleProject), Lookups.fixed((Object[])new Object[]{nbModuleProject}));
        this.testType = string;
        this.project = nbModuleProject;
        this.setName(string);
        this.setDisplayName(UnitTestLibrariesNode.getMessage("LBL_" + string + "_test_libraries"));
    }

    public Image getIcon(int n) {
        return this.getIcon(false);
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(true);
    }

    private void setMissingJUnit4(boolean bl) {
        this.missingJUnit4 = bl;
        this.fireIconChange();
        this.fireOpenedIconChange();
        this.fireShortDescriptionChange(null, null);
    }

    private Image getIcon(boolean bl) {
        Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/apisupport/project/ui/resources/libraries-badge.png", (boolean)true);
        Image image2 = ImageUtilities.mergeImages((Image)UIUtil.getTreeFolderIcon(bl), (Image)image, (int)8, (int)8);
        if (this.missingJUnit4) {
            image = ImageUtilities.loadImage((String)"org/netbeans/modules/java/api/common/project/ui/resources/brokenProjectBadge.gif", (boolean)true);
            image2 = ImageUtilities.mergeImages((Image)image2, (Image)image, (int)0, (int)0);
        }
        return image2;
    }

    public Action[] getActions(boolean bl) {
        ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>(2);
        if (this.missingJUnit4) {
            arrayList.add(new AddJUnit4Action(this.testType, this.project));
        }
        arrayList.add(new AddUnitTestDependencyAction(this.testType, this.project));
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    public String getShortDescription() {
        if (this.missingJUnit4) {
            return NbBundle.getMessage(UnitTestLibrariesNode.class, (String)"HINT_missing_junit4");
        }
        return null;
    }

    private static String createHtmlDescription(TestModuleDependency testModuleDependency) {
        StringBuffer stringBuffer = new StringBuffer("<html><u>" + testModuleDependency.getModule().getCodeNameBase() + "</u><br>");
        if (testModuleDependency.isTest()) {
            stringBuffer.append("<br>" + UnitTestLibrariesNode.getMessage("CTL_test"));
        }
        if (testModuleDependency.isCompile()) {
            stringBuffer.append("<br>").append(UnitTestLibrariesNode.getMessage("CTL_compile"));
        }
        if (testModuleDependency.isRecursive()) {
            stringBuffer.append("<br>").append(UnitTestLibrariesNode.getMessage("CTL_recursive"));
        }
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(UnitTestLibrariesNode.class, (String)string);
    }

    static final class EditTestDependencyAction
    extends AbstractAction {
        private final TestModuleDependency testDep;
        private final String testType;
        private final NbModuleProject project;

        EditTestDependencyAction(TestModuleDependency testModuleDependency, String string, NbModuleProject nbModuleProject) {
            super(UnitTestLibrariesNode.getMessage("CTL_EditDependency"));
            this.testDep = testModuleDependency;
            this.testType = string;
            this.project = nbModuleProject;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditTestDependencyPanel editTestDependencyPanel = new EditTestDependencyPanel(this.testDep);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)editTestDependencyPanel, NbBundle.getMessage(LibrariesNode.class, (String)"CTL_EditModuleDependencyTitle", (Object)this.testDep.getModule().getLocalizedName()));
            dialogDescriptor.setHelpCtx(new HelpCtx(EditTestDependencyPanel.class));
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
            if (dialogDescriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
                TestModuleDependency testModuleDependency = editTestDependencyPanel.getEditedDependency();
                try {
                    ProjectXMLManager projectXMLManager = new ProjectXMLManager(this.project);
                    projectXMLManager.removeTestDependency(this.testType, this.testDep.getModule().getCodeNameBase());
                    projectXMLManager.addTestDependency(this.testType, testModuleDependency);
                    ProjectManager.getDefault().saveProject((Project)this.project);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().annotate((Throwable)iOException, "Cannot store dependency: " + testModuleDependency);
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
            dialog.dispose();
        }
    }

    static final class RemoveDependencyAction
    extends CookieAction {
        RemoveDependencyAction() {
        }

        protected void performAction(Node[] nodeArray) {
            Object object;
            Object object2;
            HashMap<Object, HashSet<Pair<Object, Object>>> hashMap = new HashMap<Object, HashSet<Pair<Object, Object>>>();
            for (int i = 0; i < nodeArray.length; ++i) {
                Lookup object3 = nodeArray[i].getLookup();
                object2 = (TestModuleDependency)object3.lookup(TestModuleDependency.class);
                assert (object2 != null);
                object = (NbModuleProject)object3.lookup(NbModuleProject.class);
                assert (object != null);
                String string = (String)object3.lookup(String.class);
                assert (string != null);
                Set<Pair<Object, Object>> set = (Set)hashMap.get(object);
                if (set == null) {
                    set = new HashSet<Pair<Object, Object>>();
                    hashMap.put(object, (HashSet<Pair<Object, Object>>)set);
                }
                set.add(new Pair<Object, Object>(object2, string));
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                object2 = (NbModuleProject)entry.getKey();
                object = new ProjectXMLManager((NbModuleProject)object2);
                for (Set<Pair<Object, Object>> set : (Set)entry.getValue()) {
                    ((ProjectXMLManager)object).removeTestDependency((String)((Pair)((Object)set)).second, ((TestModuleDependency)((Pair)((Object)set)).first).getModule().getCodeNameBase());
                }
                try {
                    ProjectManager.getDefault().saveProject((Project)object2);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().annotate((Throwable)iOException, "Problem during test dependencies removing");
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }

        public String getName() {
            return UnitTestLibrariesNode.getMessage("CTL_RemoveDependency");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        protected boolean asynchronous() {
            return false;
        }

        protected int mode() {
            return 4;
        }

        protected Class[] cookieClasses() {
            return new Class[]{TestModuleDependency.class, NbModuleProject.class};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Pair<F, S> {
        public F first;
        public S second;

        public Pair(F f, S s) {
            this.first = f;
            this.second = s;
        }
    }

    private static class AddJUnit4Action
    extends AbstractAction {
        private final String testType;
        private final NbModuleProject project;

        AddJUnit4Action(String string, NbModuleProject nbModuleProject) {
            super(NbBundle.getMessage(UnitTestLibrariesNode.class, (String)"LBL_resolve_missing_junit4"));
            this.testType = string;
            this.project = nbModuleProject;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(UnitTestLibrariesNode.class, (String)"LBL_also_add_nbjunit_question"), NbBundle.getMessage(UnitTestLibrariesNode.class, (String)"LBL_also_add_nbjunit_title")));
            if (object == NotifyDescriptor.NO_OPTION) {
                bl = false;
            } else if (object == NotifyDescriptor.YES_OPTION) {
                bl = true;
            } else {
                return;
            }
            try {
                ModuleProjectClassPathExtender.resolveJUnitDependencies(this.project, this.testType, bl);
            }
            catch (IOException iOException) {
                String string = Exceptions.findLocalizedMessage((Throwable)iOException);
                if (string == null) {
                    string = NbBundle.getMessage(UnitTestLibrariesNode.class, (String)"LBL_cannot_resolve_missing_junit4");
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
                return;
            }
            try {
                ProjectManager.getDefault().saveProject((Project)this.project);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    static final class AddUnitTestDependencyAction
    extends AbstractAction {
        private final String testType;
        private final NbModuleProject project;

        AddUnitTestDependencyAction(String string, NbModuleProject nbModuleProject) {
            super(UnitTestLibrariesNode.getMessage("CTL_AddTestDependency_" + string));
            this.testType = string;
            this.project = nbModuleProject;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SingleModuleProperties singleModuleProperties = SingleModuleProperties.getInstance(this.project);
            final AddModulePanel addModulePanel = new AddModulePanel(singleModuleProperties);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)addModulePanel, UnitTestLibrariesNode.getMessage("CTL_AddTestDependency_" + this.testType));
            dialogDescriptor.setHelpCtx(new HelpCtx(AddModulePanel.class));
            dialogDescriptor.setClosingOptions(new Object[0]);
            final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialogDescriptor.setButtonListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (DialogDescriptor.OK_OPTION.equals(actionEvent.getSource()) && addModulePanel.getSelectedDependencies().length == 0) {
                        return;
                    }
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            });
            dialog.setVisible(true);
            if (dialogDescriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
                ModuleDependency[] moduleDependencyArray = addModulePanel.getSelectedDependencies();
                ProjectXMLManager projectXMLManager = new ProjectXMLManager(this.project);
                try {
                    for (int i = 0; i < moduleDependencyArray.length; ++i) {
                        projectXMLManager.addTestDependency(this.testType, new TestModuleDependency(moduleDependencyArray[i].getModuleEntry(), false, false, true));
                        ProjectManager.getDefault().saveProject((Project)this.project);
                    }
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().annotate((Throwable)exception, "Cannot add dependencies, probably IO error: " + Arrays.asList(moduleDependencyArray));
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
            }
            dialog.dispose();
        }
    }

    private static final class LibraryDependencyNode
    extends FilterNode {
        private final TestModuleDependency dep;
        private final String testType;
        private final NbModuleProject project;
        private Action[] actions;

        LibraryDependencyNode(TestModuleDependency testModuleDependency, String string, NbModuleProject nbModuleProject, Node node) {
            super(node, null, (Lookup)new ProxyLookup(new Lookup[]{node.getLookup(), Lookups.fixed((Object[])new Object[]{testModuleDependency, nbModuleProject, string})}));
            this.dep = testModuleDependency;
            this.testType = string;
            this.project = nbModuleProject;
            this.setShortDescription(UnitTestLibrariesNode.createHtmlDescription(testModuleDependency));
        }

        public Action[] getActions(boolean bl) {
            if (this.actions == null) {
                LinkedHashSet<Action> linkedHashSet = new LinkedHashSet<Action>();
                linkedHashSet.add(new EditTestDependencyAction(this.dep, this.testType, this.project));
                Action[] actionArray = super.getActions(false);
                for (int i = 0; i < actionArray.length; ++i) {
                    if (!(actionArray[i] instanceof FindAction)) continue;
                    linkedHashSet.add(actionArray[i]);
                }
                linkedHashSet.add(LibrariesChildren.REMOVE_DEPENDENCY_ACTION);
                this.actions = linkedHashSet.toArray(new Action[linkedHashSet.size()]);
            }
            return this.actions;
        }

        public Action getPreferredAction() {
            return this.getActions(false)[0];
        }
    }

    private static final class ProjectDependencyNode
    extends AbstractNode {
        private final TestModuleDependency dep;
        private final String testType;
        private final NbModuleProject project;
        private Action[] actions;

        ProjectDependencyNode(TestModuleDependency testModuleDependency, String string, NbModuleProject nbModuleProject) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{testModuleDependency, nbModuleProject, testModuleDependency.getModule(), string}));
            this.dep = testModuleDependency;
            this.testType = string;
            this.project = nbModuleProject;
            ModuleEntry moduleEntry = testModuleDependency.getModule();
            this.setIconBaseWithExtension("org/netbeans/modules/apisupport/project/resources/module.png");
            this.setDisplayName(moduleEntry.getLocalizedName());
            this.setShortDescription(UnitTestLibrariesNode.createHtmlDescription(testModuleDependency));
        }

        public Action[] getActions(boolean bl) {
            if (this.actions == null) {
                LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
                linkedHashSet.add(SystemAction.get(LibrariesNode.OpenProjectAction.class));
                linkedHashSet.add(new EditTestDependencyAction(this.dep, this.testType, this.project));
                linkedHashSet.add(LibrariesChildren.REMOVE_DEPENDENCY_ACTION);
                this.actions = linkedHashSet.toArray(new Action[linkedHashSet.size()]);
            }
            return this.actions;
        }

        public Action getPreferredAction() {
            return this.getActions(false)[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LibrariesChildren
    extends Children.Keys<TestModuleDependency>
    implements AntProjectListener {
        private static final String LIBRARIES_ICON = "org/netbeans/modules/apisupport/project/ui/resources/libraries.gif";
        static final Action REMOVE_DEPENDENCY_ACTION = new RemoveDependencyAction();
        private final String testType;
        private final NbModuleProject project;
        private ImageIcon librariesIcon;
        private boolean refreshScheduled = false;

        LibrariesChildren(String string, NbModuleProject nbModuleProject) {
            this.testType = string;
            this.project = nbModuleProject;
        }

        protected void addNotify() {
            super.addNotify();
            this.project.getHelper().addAntProjectListener((AntProjectListener)this);
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            this.project.getHelper().removeAntProjectListener((AntProjectListener)this);
            super.removeNotify();
        }

        private void refreshKeys() {
            block2: {
                try {
                    ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Object>(){

                        public Object run() throws Exception {
                            ProjectXMLManager projectXMLManager = new ProjectXMLManager(LibrariesChildren.this.project);
                            final ArrayList<TestModuleDependency> arrayList = new ArrayList<TestModuleDependency>();
                            TreeSet<TestModuleDependency> treeSet = new TreeSet<TestModuleDependency>(TestModuleDependency.CNB_COMPARATOR);
                            final AtomicBoolean atomicBoolean = new AtomicBoolean(true);
                            Set<TestModuleDependency> set = projectXMLManager.getTestDependencies(LibrariesChildren.this.project.getModuleList()).get(LibrariesChildren.this.testType);
                            if (set != null) {
                                for (TestModuleDependency testModuleDependency : set) {
                                    if (testModuleDependency.isCompile()) {
                                        treeSet.add(testModuleDependency);
                                    }
                                    if (!testModuleDependency.getModule().getCodeNameBase().equals("org.netbeans.libs.junit4")) continue;
                                    atomicBoolean.set(false);
                                }
                                arrayList.addAll(treeSet);
                            }
                            ImportantFilesNodeFactory.getNodesSyncRP().post(new Runnable(){

                                public void run() {
                                    ((UnitTestLibrariesNode)LibrariesChildren.this.getNode()).setMissingJUnit4(atomicBoolean.get());
                                    LibrariesChildren.this.setKeys(Collections.unmodifiableList(arrayList));
                                }
                            });
                            return null;
                        }
                    });
                }
                catch (MutexException mutexException) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError((Object)mutexException.getException());
                }
            }
        }

        protected Node[] createNodes(TestModuleDependency testModuleDependency) {
            Object object = null;
            File file = testModuleDependency.getModule().getSourceLocation();
            if (file == null) {
                File file2 = testModuleDependency.getModule().getJarLocation();
                URL uRL = FileUtil.urlForArchiveOrDir((File)file2);
                assert (uRL != null);
                FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                ModuleEntry moduleEntry = testModuleDependency.getModule();
                String string = moduleEntry.getLocalizedName() + " - " + moduleEntry.getCodeNameBase();
                Icon icon = this.getLibrariesIcon();
                ActionFilterNode actionFilterNode = ActionFilterNode.create(PackageView.createPackageView((SourceGroup)new LibrariesSourceGroup(fileObject, string, icon, icon)));
                object = new LibraryDependencyNode(testModuleDependency, this.testType, this.project, (Node)actionFilterNode);
                object.setName(moduleEntry.getLocalizedName());
            } else {
                object = new ProjectDependencyNode(testModuleDependency, this.testType, this.project);
                object.setName(testModuleDependency.getModule().getLocalizedName());
            }
            assert (object != null);
            return new Node[]{object};
        }

        public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
            if (this.project.getHelper().resolveFileObject("nbproject/project.xml") != null) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        LibrariesChildren.this.refreshKeys();
                        LibrariesChildren.this.refreshScheduled = false;
                    }
                };
                if (this.project.isRunInAtomicAction()) {
                    if (!this.refreshScheduled) {
                        this.refreshScheduled = true;
                        EventQueue.invokeLater(runnable);
                    }
                } else {
                    runnable.run();
                }
            }
        }

        public void propertiesChanged(AntProjectEvent antProjectEvent) {
            Logger logger = Logger.getLogger(UnitTestLibrariesNode.class.getName());
            logger.log(Level.FINE, "propertiesChanged: " + antProjectEvent.getPath() + ", expected: " + antProjectEvent.isExpected());
        }

        private Icon getLibrariesIcon() {
            if (this.librariesIcon == null) {
                this.librariesIcon = ImageUtilities.loadImageIcon((String)LIBRARIES_ICON, (boolean)true);
            }
            return this.librariesIcon;
        }
    }
}

