/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModuleProperties {
    public static final String PROPERTIES_REFRESHED = "propertiesRefreshed";
    static final RequestProcessor RP = new RequestProcessor(ModuleProperties.class.getName());
    static boolean runFromTests;
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private EditableProperties projectProperties;
    private EditableProperties privateProperties;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private List<LazyStorage> storages = new ArrayList<LazyStorage>();

    ModuleProperties(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator) {
        this.helper = antProjectHelper;
        this.evaluator = propertyEvaluator;
        this.reloadProperties();
    }

    protected void reloadProperties() {
        this.projectProperties = this.helper.getProperties("nbproject/project.properties");
        this.privateProperties = this.helper.getProperties("nbproject/private/private.properties");
    }

    abstract Map<String, String> getDefaultValues();

    AntProjectHelper getHelper() {
        return this.helper;
    }

    PropertyEvaluator getEvaluator() {
        return this.evaluator;
    }

    EditableProperties getProjectProperties() {
        return this.projectProperties;
    }

    EditableProperties getPrivateProperties() {
        return this.privateProperties;
    }

    final String getProperty(String string) {
        String string2 = this.getProjectProperties().getProperty(string);
        return string2 != null ? string2 : this.getDefaultValues().get(string);
    }

    final boolean getBooleanProperty(String string) {
        String string2 = this.getProperty(string);
        return string2 != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes"));
    }

    final String removeProperty(String string) {
        return (String)this.getProjectProperties().remove((Object)string);
    }

    final String removePrivateProperty(String string) {
        return (String)this.getPrivateProperties().remove((Object)string);
    }

    final void setProperty(String string, String string2) {
        String string3 = this.getDefaultValues().get(string);
        if (string3 == null) {
            string3 = "";
        }
        if (string2 == null || string3.equals(string2)) {
            this.getProjectProperties().remove((Object)string);
        } else {
            this.getProjectProperties().setProperty(string, string2);
        }
        this.firePropertyChange(string, null, string2);
    }

    final void setPrivateProperty(String string, String string2) {
        String string3 = this.getDefaultValues().get(string);
        if (string3 == null) {
            string3 = "";
        }
        if (string3.equals(string2)) {
            this.getPrivateProperties().remove((Object)string);
        } else {
            this.getPrivateProperties().setProperty(string, string2);
        }
        this.firePropertyChange(string, null, string2);
    }

    void setProperty(String string, String[] stringArray) {
        this.getProjectProperties().setProperty(string, stringArray);
        this.firePropertyChange(string, null, null);
    }

    final void setBooleanProperty(String string, boolean bl) {
        this.setProperty(string, Boolean.toString(bl));
    }

    String getProjectDisplayName() {
        return Util.getDisplayName(this.getHelper().getProjectDirectory());
    }

    final File getProjectDirectoryFile() {
        return FileUtil.toFile((FileObject)this.getHelper().getProjectDirectory());
    }

    final String getProjectDirectory() {
        return this.getProjectDirectoryFile().getAbsolutePath();
    }

    void storeProperties() throws IOException {
        File file = new File(this.getProjectDirectoryFile(), "nbproject/project.properties");
        if (this.getProjectProperties().size() > 0 || file.exists()) {
            this.getHelper().putProperties("nbproject/project.properties", this.getProjectProperties());
        }
        file = new File(this.getProjectDirectoryFile(), "nbproject/private/private.properties");
        if (this.getPrivateProperties().size() > 0 || file.exists()) {
            this.getHelper().putProperties("nbproject/private/private.properties", this.getPrivateProperties());
        }
    }

    static void storePlatform(AntProjectHelper antProjectHelper, NbPlatform nbPlatform) {
        if (nbPlatform != null && nbPlatform.getID() != null) {
            EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/platform.properties");
            editableProperties.put("nbplatform.active", nbPlatform.getID());
            antProjectHelper.putProperties("nbproject/platform.properties", editableProperties);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.changeSupport.firePropertyChange(string, object, object2);
    }

    protected void firePropertiesRefreshed() {
        this.firePropertyChange(PROPERTIES_REFRESHED, null, null);
    }

    protected static void reportLostPlatform(NbPlatform nbPlatform) {
        String string = nbPlatform != null ? '\"' + nbPlatform.getLabel() + '\"' : NbBundle.getMessage(ModuleProperties.class, (String)"MSG_PreviouslySet");
        String string2 = NbBundle.getMessage(ModuleProperties.class, (String)"MSG_PlatformNotFound", (Object)string);
        if (!runFromTests) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2));
        } else {
            System.err.println(string2);
        }
        Logger.getLogger(ModuleProperties.class.getName()).log(Level.WARNING, string2);
    }

    static String getPlatformID(JavaPlatform javaPlatform) {
        String string = (String)javaPlatform.getProperties().get("platform.ant.name");
        return string != null ? string : "default";
    }

    static JavaPlatform findJavaPlatformByID(String string) {
        if (string == null || string.equals("default")) {
            return JavaPlatform.getDefault();
        }
        JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getInstalledPlatforms();
        for (int i = 0; i < javaPlatformArray.length; ++i) {
            if (!string.equals(ModuleProperties.getPlatformID(javaPlatformArray[i]))) continue;
            return javaPlatformArray[i];
        }
        return null;
    }

    static void storeJavaPlatform(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, JavaPlatform javaPlatform, boolean bl) throws IOException {
        if (bl) {
            FileObject fileObject;
            File file;
            final boolean bl2 = javaPlatform == null || javaPlatform == JavaPlatform.getDefault();
            File file2 = file = bl2 ? null : ModuleProperties.getPlatformLocation(javaPlatform);
            if ((file != null || bl2) && (fileObject = antProjectHelper.resolveFileObject(propertyEvaluator.evaluate("${nb_all}/nbbuild"))) != null) {
                try {
                    ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        public Void run() throws IOException {
                            FileObject fileObject2 = fileObject.getFileObject("user.build.properties");
                            if (fileObject2 == null) {
                                fileObject2 = fileObject.createData("user.build.properties");
                            }
                            EditableProperties editableProperties = Util.loadProperties(fileObject2);
                            if (bl2) {
                                editableProperties.remove((Object)"nbjdk.home");
                            } else {
                                editableProperties.setProperty("nbjdk.home", file.getAbsolutePath());
                            }
                            Util.storeProperties(fileObject2, editableProperties);
                            return null;
                        }
                    });
                }
                catch (MutexException mutexException) {
                    throw (IOException)mutexException.getException();
                }
            }
        } else {
            EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/platform.properties");
            if (javaPlatform == null || javaPlatform == JavaPlatform.getDefault()) {
                if (editableProperties.containsKey((Object)"nbjdk.active")) {
                    editableProperties.put("nbjdk.active", "default");
                }
            } else {
                editableProperties.put("nbjdk.active", ModuleProperties.getPlatformID(javaPlatform));
            }
            antProjectHelper.putProperties("nbproject/platform.properties", editableProperties);
        }
    }

    private static File getPlatformLocation(JavaPlatform javaPlatform) {
        Collection collection = javaPlatform.getInstallFolders();
        if (collection.size() == 1) {
            return FileUtil.toFile((FileObject)((FileObject)collection.iterator().next()));
        }
        return null;
    }

    public static JavaPlatform findJavaPlatformByLocation(String string) {
        if (string == null) {
            return JavaPlatform.getDefault();
        }
        for (JavaPlatform javaPlatform : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            if (!new File(string).equals(ModuleProperties.getPlatformLocation(javaPlatform))) continue;
            return javaPlatform;
        }
        return null;
    }

    void addLazyStorage(LazyStorage lazyStorage) {
        this.storages.add(lazyStorage);
    }

    void triggerLazyStorages() {
        for (LazyStorage lazyStorage : this.storages) {
            lazyStorage.store();
        }
    }

    static interface LazyStorage {
        public void store();
    }
}

