/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.winsys;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.winsys.NewTCIterator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class NameAndLocationPanel
extends BasicWizardIterator.Panel {
    private NewTCIterator.DataModel data;
    private JButton btnIcon;
    private JComboBox comPackageName;
    private JLabel createdFiles;
    private JTextArea createdFilesValue;
    private JLabel filler;
    private JLabel lblIcon;
    private JLabel lblPackageName;
    private JLabel lblPrefix;
    private JLabel lblProjectName;
    private JLabel modifiedFiles;
    private JTextArea modifiedFilesValue;
    private JTextField txtIcon;
    private JTextField txtPrefix;
    private JTextField txtProjectName;

    public NameAndLocationPanel(WizardDescriptor wizardDescriptor, NewTCIterator.DataModel dataModel) {
        super(wizardDescriptor);
        this.data = dataModel;
        this.initComponents();
        this.initAccessibility();
        this.putClientProperty("NewFileWizard_Title", NameAndLocationPanel.getMessage("LBL_TCWizardTitle"));
        UIUtil.DocumentAdapter documentAdapter = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (NameAndLocationPanel.this.checkValidity()) {
                    NameAndLocationPanel.this.updateData();
                }
            }
        };
        this.txtPrefix.getDocument().addDocumentListener(documentAdapter);
        this.txtIcon.getDocument().addDocumentListener(documentAdapter);
        if (this.comPackageName.getEditor().getEditorComponent() instanceof JTextField) {
            JTextField jTextField = (JTextField)this.comPackageName.getEditor().getEditorComponent();
            jTextField.getDocument().addDocumentListener(documentAdapter);
        }
    }

    protected void storeToDataModel() {
        this.updateData();
    }

    private void updateData() {
        this.data.setPackageName(this.comPackageName.getEditor().getItem().toString());
        String string = this.txtIcon.getText().trim();
        this.data.setIcon(string.length() == 0 ? (String)null : string);
        this.data.setName(this.txtPrefix.getText().trim());
        NewTCIterator.generateFileChanges(this.data);
        this.createdFilesValue.setText(UIUtil.generateTextAreaContent(this.data.getCreatedModifiedFiles().getCreatedPaths()));
        this.modifiedFilesValue.setText(UIUtil.generateTextAreaContent(this.data.getCreatedModifiedFiles().getModifiedPaths()));
        String[] stringArray = this.data.getCreatedModifiedFiles().getInvalidPaths();
        if (stringArray.length > 0) {
            this.setError(NbBundle.getMessage(NameAndLocationPanel.class, (String)"ERR_ToBeCreateFileExists", (Object)stringArray[0]));
        }
    }

    protected void readFromDataModel() {
        this.txtPrefix.setText(this.data.getName());
        this.txtIcon.setText(this.data.getIcon());
        if (this.data.getPackageName() != null) {
            this.comPackageName.setSelectedItem(this.data.getPackageName());
        }
        this.checkValidity();
    }

    protected String getPanelName() {
        return NameAndLocationPanel.getMessage("LBL_NameLocation_Title");
    }

    private boolean checkValidity() {
        Object object;
        if (this.txtPrefix.getText().trim().length() == 0) {
            this.setInfo(NameAndLocationPanel.getMessage("ERR_Name_Prefix_Empty"), false);
            return false;
        }
        if (!Utilities.isJavaIdentifier((String)this.txtPrefix.getText().trim())) {
            this.setError(NameAndLocationPanel.getMessage("ERR_Name_Prefix_Invalid"));
            return false;
        }
        String string = this.txtIcon.getText().trim();
        if (string.length() != 0 && !((File)(object = new File(string))).exists()) {
            this.setError(NbBundle.getMessage(this.getClass(), (String)"ERR_Icon_Invalid"));
            return false;
        }
        object = this.comPackageName.getEditor().getItem().toString().trim();
        if (((String)object).length() == 0 || !UIUtil.isValidPackageName((String)object)) {
            this.setError(NbBundle.getMessage(this.getClass(), (String)"ERR_Package_Invalid"));
            return false;
        }
        this.markValid();
        return true;
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(NameAndLocationPanel.class);
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(NameAndLocationPanel.class, (String)string);
    }

    private void initComponents() {
        this.lblPrefix = new JLabel();
        this.txtPrefix = new JTextField();
        this.lblIcon = new JLabel();
        this.txtIcon = new JTextField();
        this.btnIcon = new JButton();
        this.lblProjectName = new JLabel();
        this.txtProjectName = new JTextField(ProjectUtils.getInformation((Project)this.data.getProject()).getDisplayName());
        this.lblPackageName = new JLabel();
        this.comPackageName = UIUtil.createPackageComboBox(this.data.getSourceRootGroup());
        this.createdFiles = new JLabel();
        this.modifiedFiles = new JLabel();
        this.filler = new JLabel();
        this.createdFilesValue = new JTextArea();
        this.modifiedFilesValue = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.lblPrefix.setLabelFor(this.txtPrefix);
        Mnemonics.setLocalizedText((JLabel)this.lblPrefix, (String)NbBundle.getMessage(NameAndLocationPanel.class, (String)"LBL_Prefix"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 0, 6, 12);
        this.add((Component)this.lblPrefix, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 6, 0);
        this.add((Component)this.txtPrefix, gridBagConstraints);
        this.lblIcon.setLabelFor(this.txtIcon);
        Mnemonics.setLocalizedText((JLabel)this.lblIcon, (String)NbBundle.getMessage(NameAndLocationPanel.class, (String)"LBL_Icon"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.lblIcon, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.txtIcon, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnIcon, (String)NbBundle.getMessage(NameAndLocationPanel.class, (String)"LBL_Icon_Browse"));
        this.btnIcon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NameAndLocationPanel.this.btnIconActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.btnIcon, gridBagConstraints);
        this.lblProjectName.setLabelFor(this.txtProjectName);
        Mnemonics.setLocalizedText((JLabel)this.lblProjectName, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/librarydescriptor/Bundle").getString("LBL_ProjectName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(18, 0, 6, 12);
        this.add((Component)this.lblProjectName, gridBagConstraints);
        this.txtProjectName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(18, 0, 6, 0);
        this.add((Component)this.txtProjectName, gridBagConstraints);
        this.lblPackageName.setLabelFor(this.comPackageName);
        Mnemonics.setLocalizedText((JLabel)this.lblPackageName, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/librarydescriptor/Bundle").getString("LBL_PackageName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.lblPackageName, gridBagConstraints);
        this.comPackageName.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.comPackageName, gridBagConstraints);
        this.createdFiles.setLabelFor(this.createdFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.createdFiles, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/librarydescriptor/Bundle").getString("LBL_CreatedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(36, 0, 6, 12);
        this.add((Component)this.createdFiles, gridBagConstraints);
        this.modifiedFiles.setLabelFor(this.modifiedFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.modifiedFiles, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/librarydescriptor/Bundle").getString("LBL_ModifiedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.modifiedFiles, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filler, gridBagConstraints);
        this.createdFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.createdFilesValue.setColumns(20);
        this.createdFilesValue.setEditable(false);
        this.createdFilesValue.setRows(5);
        this.createdFilesValue.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(36, 0, 6, 0);
        this.add((Component)this.createdFilesValue, gridBagConstraints);
        this.modifiedFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.modifiedFilesValue.setColumns(20);
        this.modifiedFilesValue.setEditable(false);
        this.modifiedFilesValue.setRows(5);
        this.modifiedFilesValue.setToolTipText("modifiedFilesValue");
        this.modifiedFilesValue.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.modifiedFilesValue, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_NameAndLocationPanel"));
        this.comPackageName.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_PackageName"));
        this.txtIcon.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_Icon"));
        this.txtPrefix.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_Prefix"));
        this.btnIcon.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_IconButton"));
        this.txtProjectName.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_ProjectName"));
        this.createdFilesValue.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_CreatedFilesValue"));
        this.modifiedFilesValue.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_ModifiedFilesValue"));
    }

    private void btnIconActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = UIUtil.getIconFileChooser(this.txtIcon.getText());
        int n = jFileChooser.showDialog(this, NameAndLocationPanel.getMessage("LBL_Select"));
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.txtIcon.setText(file.getAbsolutePath());
        }
    }
}

