/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.debug.CndTraceFlags;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.WeakSharedSet;

public abstract class APTMacroCache {
    private static final int MACRO_MANAGER_DEFAULT_CAPACITY;
    private static final int MACRO_MANAGER_DEFAULT_SLICED_NUMBER;
    private static final APTMacroCache instance;

    private APTMacroCache() {
    }

    public abstract APTMacro getMacro(APTMacro var1);

    public abstract void dispose();

    private static APTMacroCache create(boolean bl) {
        if (bl) {
            return new APTSingleMacroManager(MACRO_MANAGER_DEFAULT_CAPACITY);
        }
        return new APTCompoundMacroManager(MACRO_MANAGER_DEFAULT_SLICED_NUMBER, MACRO_MANAGER_DEFAULT_CAPACITY);
    }

    public static APTMacroCache getManager() {
        return instance;
    }

    static {
        int n = CndUtils.getConcurrencyLevel();
        if (n <= 4) {
            MACRO_MANAGER_DEFAULT_SLICED_NUMBER = 32;
            MACRO_MANAGER_DEFAULT_CAPACITY = 512;
        } else {
            MACRO_MANAGER_DEFAULT_SLICED_NUMBER = 128;
            MACRO_MANAGER_DEFAULT_CAPACITY = 128;
        }
        instance = APTMacroCache.create(false);
    }

    private static final class APTCompoundMacroManager
    extends APTMacroCache {
        private final APTMacroCache[] instances;
        private final int segmentMask;

        private APTCompoundMacroManager(int n) {
            this(n, MACRO_MANAGER_DEFAULT_CAPACITY);
        }

        private APTCompoundMacroManager(int n, int n2) {
            int n3;
            for (n3 = 1; n3 < n; n3 <<= 1) {
            }
            this.segmentMask = n3 - 1;
            this.instances = new APTMacroCache[n3];
            for (int i = 0; i < this.instances.length; ++i) {
                this.instances[i] = new APTSingleMacroManager(n2);
            }
        }

        private APTMacroCache getDelegate(APTMacro aPTMacro) {
            if (aPTMacro == null) {
                throw new NullPointerException("null macro is illegal to share");
            }
            int n = aPTMacro.hashCode() & this.segmentMask;
            return this.instances[n];
        }

        public APTMacro getMacro(APTMacro aPTMacro) {
            return this.getDelegate(aPTMacro).getMacro(aPTMacro);
        }

        public final void dispose() {
            for (int i = 0; i < this.instances.length; ++i) {
                this.instances[i].dispose();
            }
        }
    }

    private static final class APTSingleMacroManager
    extends APTMacroCache {
        private final WeakSharedSet<APTMacro> storage;
        private final int initialCapacity;
        private final Object lock = new Lock();

        private APTSingleMacroManager(int n) {
            this.storage = new WeakSharedSet(n);
            this.initialCapacity = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public APTMacro getMacro(APTMacro aPTMacro) {
            if (aPTMacro == null) {
                throw new NullPointerException("null string is illegal to share");
            }
            APTMacro aPTMacro2 = null;
            Object object = this.lock;
            synchronized (object) {
                aPTMacro2 = (APTMacro)this.storage.addOrGet((Object)aPTMacro);
            }
            assert (aPTMacro2 != null);
            assert (aPTMacro2.equals(aPTMacro));
            return aPTMacro2;
        }

        public final void dispose() {
            if (CndTraceFlags.TRACE_SLICE_DISTIBUTIONS) {
                Object[] objectArray = this.storage.toArray();
                System.out.println("Dispose macro cache " + objectArray.length + " " + this.getClass().getName());
                HashMap hashMap = new HashMap();
                for (Object object : objectArray) {
                    if (object == null) continue;
                    Integer n = (Integer)hashMap.get(object.getClass());
                    n = n != null ? new Integer(n + 1) : new Integer(1);
                    hashMap.put(object.getClass(), n);
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    System.out.println("   " + entry.getValue() + " of " + ((Class)entry.getKey()).getName());
                }
            }
            if (this.storage.size() > 0) {
                this.storage.clear();
                this.storage.resize(this.initialCapacity);
            }
        }

        private static final class Lock {
            private Lock() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CacheKind {
        Single,
        Sliced;

    }
}

