/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.common.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.common.disassembly.DisassemblyService;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.openide.util.NbBundle;

public class ToggleBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private final Logger log = Logger.getLogger("cnd.breakpoint.annotations");

    public ToggleBreakpointActionProvider() {
        EditorContextBridge.getContext().addPropertyChangeListener(this);
    }

    public void doAction(Object object) {
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        int n = EditorContextBridge.getContext().getCurrentLineNumber();
        String string = EditorContextBridge.getContext().getCurrentURL();
        if (string.trim().equals("")) {
            return;
        }
        CndBreakpoint cndBreakpoint = ToggleBreakpointActionProvider.findBreakpoint(string, n);
        if (cndBreakpoint != null) {
            this.log.fine("ToggleBreakpointActionProvider.doAction: Removing breakpoint at " + cndBreakpoint.getPath() + ":" + cndBreakpoint.getLineNumber());
            debuggerManager.removeBreakpoint((Breakpoint)cndBreakpoint);
            return;
        }
        DisassemblyService disassemblyService = EditorContextBridge.getCurrentDisassemblyService();
        if (disassemblyService != null && disassemblyService.isDis(string)) {
            cndBreakpoint = AddressBreakpoint.create(disassemblyService.getLineAddress(n));
            cndBreakpoint.setPrintText(NbBundle.getBundle(ToggleBreakpointActionProvider.class).getString("CTL_Address_Breakpoint_Print_Text"));
            this.log.fine("ToggleBreakpointActionProvider.doAction: Adding disassembly breakpoint at " + cndBreakpoint.getPath() + ":" + cndBreakpoint.getLineNumber());
            debuggerManager.addBreakpoint((Breakpoint)cndBreakpoint);
            return;
        }
        cndBreakpoint = LineBreakpoint.create(string, n);
        this.log.fine("ToggleBreakpointActionProvider.doAction: Adding breakpoint at " + cndBreakpoint.getPath() + ":" + cndBreakpoint.getLineNumber());
        debuggerManager.addBreakpoint((Breakpoint)cndBreakpoint);
    }

    static CndBreakpoint findBreakpoint(String string, int n) {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        DisassemblyService disassemblyService = EditorContextBridge.getCurrentDisassemblyService();
        boolean bl = disassemblyService != null && disassemblyService.isDis(string);
        for (Breakpoint breakpoint : breakpointArray) {
            CndBreakpoint cndBreakpoint;
            if (!(breakpoint instanceof LineBreakpoint ? (cndBreakpoint = (LineBreakpoint)breakpoint).getURL().equals(string) && cndBreakpoint.getLineNumber() == n : bl && breakpoint instanceof AddressBreakpoint && disassemblyService.getBreakpointLine((AddressBreakpoint)(cndBreakpoint = (AddressBreakpoint)breakpoint)) == n)) continue;
            return cndBreakpoint;
        }
        return null;
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        int n = EditorContextBridge.getContext().getCurrentLineNumber();
        String string = EditorContextBridge.getContext().getCurrentMIMEType();
        boolean bl = (MIMENames.isFortranOrHeaderOrCppOrC((String)string) || string.equals("text/x-asm")) && n > 0;
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, bl);
    }
}

