/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.model.impl;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalAttributeGroup;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalGroup;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.impl.SchemaImpl;
import org.netbeans.modules.xml.schema.model.impl.SchemaModelImpl;
import org.netbeans.modules.xml.schema.model.visitor.FindGlobalReferenceVisitor;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalComponentsIndexSupport
implements Runnable {
    private static HashSet<Class<? extends SchemaComponent>> mIndexedTypes = new HashSet();
    private static int GLOBAL_COMPONENT_INDEX_CREATE_THRESHOLD = 60;
    private static int GLOBAL_COMPONENT_INDEX_REMOVE_THRESHOLD = 50;
    private static int INDEX_RECALCULATION_DELAY = 100;
    private static RequestProcessor mIndexRecalculationRP;
    private SchemaModelImpl mSModel;
    private TreeMap<String, Object> mGlobalComponentIndex = null;
    private ComponentListener mComponentListener = null;
    private RequestProcessor.Task mIndexGenerationTask;
    private boolean mSupportIndex = false;
    private final Object lock = new Object();
    private JUnitTestSupport mTestSupport;

    public GlobalComponentsIndexSupport(SchemaModelImpl schemaModelImpl) {
        this.mSModel = schemaModelImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends NamedReferenceable> T findByNameAndType(String string, Class<T> clazz) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl;
            this.checkGlobalComponentIndexRequired();
            boolean bl2 = bl = !this.mSupportIndex || this.mGlobalComponentIndex == null || !mIndexedTypes.contains(clazz) || this.mSModel.isIntransaction();
            if (!bl) {
                NamedReferenceable namedReferenceable = null;
                Object object2 = this.mGlobalComponentIndex.get(string);
                if (object2 != null) {
                    if (clazz.isInstance(object2)) {
                        namedReferenceable = (NamedReferenceable)clazz.cast(object2);
                    } else {
                        assert (object2 instanceof List);
                        List list = (List)List.class.cast(object2);
                        for (Object e : list) {
                            if (!clazz.isInstance(e)) continue;
                            namedReferenceable = (NamedReferenceable)clazz.cast(e);
                        }
                    }
                }
                return (T)namedReferenceable;
            }
        }
        object = this.mSModel.getSchema();
        if (object == null) {
            return null;
        }
        return new FindGlobalReferenceVisitor<T>().find(clazz, string, (Schema)object);
    }

    private void checkGlobalComponentIndexRequired() {
        boolean bl;
        int n;
        boolean bl2;
        SchemaImpl schemaImpl = this.mSModel.getSchema();
        if (schemaImpl == null) {
            return;
        }
        boolean bl3 = true;
        if (this.mTestSupport != null) {
            bl3 = this.mTestSupport.isIndexAllowed();
        }
        boolean bl4 = bl2 = (n = schemaImpl.getChildrenCount()) > GLOBAL_COMPONENT_INDEX_CREATE_THRESHOLD;
        if (bl2 && !this.mSupportIndex && bl3) {
            if (this.mTestSupport != null) {
                this.mTestSupport.log("Switch ON components' index for Schema model: " + this.mSModel.toString());
            }
            if (this.mComponentListener == null) {
                this.mComponentListener = new ComponentListener(){

                    public void valueChanged(ComponentEvent componentEvent) {
                    }

                    public void childrenAdded(ComponentEvent componentEvent) {
                        if (componentEvent.getSource() == GlobalComponentsIndexSupport.this.mSModel.getSchema()) {
                            GlobalComponentsIndexSupport.this.initiateIndexRebuld();
                        }
                    }

                    public void childrenDeleted(ComponentEvent componentEvent) {
                        if (componentEvent.getSource() == GlobalComponentsIndexSupport.this.mSModel.getSchema()) {
                            GlobalComponentsIndexSupport.this.initiateIndexRebuld();
                        }
                    }
                };
                this.mSModel.addComponentListener(this.mComponentListener);
            }
            if (this.mGlobalComponentIndex == null && this.mIndexGenerationTask == null) {
                if (this.mTestSupport != null) {
                    this.mTestSupport.log("initiate new index building for Schema model: " + this.mSModel.toString());
                }
                this.buildIndex(0);
            }
            this.mSupportIndex = true;
            return;
        }
        boolean bl5 = bl = n < GLOBAL_COMPONENT_INDEX_REMOVE_THRESHOLD;
        if ((!bl3 || bl) && this.mSupportIndex) {
            if (this.mTestSupport != null) {
                this.mTestSupport.log("Switch OFF components' index for Schema model: " + this.mSModel.toString());
            }
            this.mGlobalComponentIndex = null;
            if (this.mIndexGenerationTask != null) {
                this.mIndexGenerationTask.cancel();
                this.mIndexGenerationTask = null;
            }
            if (this.mComponentListener != null) {
                this.mSModel.removeComponentListener(this.mComponentListener);
                this.mComponentListener = null;
            }
            this.mSupportIndex = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initiateIndexRebuld() {
        Object object = this.lock;
        synchronized (object) {
            if (this.mTestSupport != null) {
                this.mTestSupport.log("initiate index rebuilding for Schema model: " + this.mSModel.toString());
            }
            this.mGlobalComponentIndex = null;
            if (this.mIndexGenerationTask != null) {
                this.mIndexGenerationTask.cancel();
            }
            this.buildIndex(INDEX_RECALCULATION_DELAY);
        }
    }

    private void buildIndex(int n) {
        this.mIndexGenerationTask = mIndexRecalculationRP.post((Runnable)this, n, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TreeMap<String, Object> treeMap = this.buildGlobalComponentIndex();
        if (!Thread.interrupted()) {
            Object object = this.lock;
            synchronized (object) {
                this.mGlobalComponentIndex = treeMap;
                this.mIndexGenerationTask = null;
            }
        }
    }

    private TreeMap<String, Object> buildGlobalComponentIndex() {
        if (Thread.interrupted()) {
            return null;
        }
        long l = 0L;
        if (this.mTestSupport != null) {
            l = System.nanoTime();
            this.mTestSupport.log("buildComponentIndex STARTED for Schema model: " + this.mSModel.toString());
        }
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        SchemaImpl schemaImpl = this.mSModel.getSchema();
        if (schemaImpl == null) {
            return null;
        }
        List list = schemaImpl.getChildren();
        for (SchemaComponent schemaComponent : list) {
            List<SchemaComponent> list2;
            if (Thread.interrupted()) {
                return null;
            }
            Class<? extends SchemaComponent> clazz = schemaComponent.getComponentType();
            if (!mIndexedTypes.contains(clazz)) continue;
            assert (schemaComponent instanceof Named);
            String string = ((Named)Named.class.cast(schemaComponent)).getName();
            if (string == null || string.length() == 0) continue;
            Object object = treeMap.get(string);
            if (object == null) {
                treeMap.put(string, schemaComponent);
                continue;
            }
            if (object instanceof List) {
                list2 = (List)List.class.cast(object);
                list2.add(schemaComponent);
                continue;
            }
            list2 = new ArrayList();
            list2.add((SchemaComponent)object);
            list2.add(schemaComponent);
            treeMap.put(string, list2);
        }
        if (this.mTestSupport != null) {
            long l2 = System.nanoTime();
            float f = (float)(l2 - l) / 1000000.0f;
            this.mTestSupport.log("buildComponentIndex FINISHED for Schema model: " + this.mSModel.toString());
            this.mTestSupport.log("Index contains " + treeMap.size() + " items. " + "Building has taken " + new DecimalFormat("#0.00#").format(f) + " ms");
        }
        return treeMap;
    }

    public JUnitTestSupport getJUnitTestSupport() {
        if (this.mTestSupport == null) {
            this.mTestSupport = new JUnitTestSupport(this);
        }
        return this.mTestSupport;
    }

    static {
        mIndexedTypes.add(GlobalAttribute.class);
        mIndexedTypes.add(GlobalAttributeGroup.class);
        mIndexedTypes.add(GlobalGroup.class);
        mIndexedTypes.add(GlobalType.class);
        mIndexedTypes.add(GlobalSimpleType.class);
        mIndexedTypes.add(GlobalComplexType.class);
        mIndexedTypes.add(GlobalElement.class);
        mIndexRecalculationRP = new RequestProcessor("IndexRecalculator", 3, true);
    }

    public static class JUnitTestSupport {
        private GlobalComponentsIndexSupport mIndexSupport;
        private List<String> mMsgLog;
        private boolean mIndexAllowed = true;

        public JUnitTestSupport(GlobalComponentsIndexSupport globalComponentsIndexSupport) {
            this.mIndexSupport = globalComponentsIndexSupport;
            this.mMsgLog = new ArrayList<String>();
        }

        public void log(String string) {
            this.mMsgLog.add(string);
        }

        public String printLog() {
            ArrayList<String> arrayList = new ArrayList<String>(this.mMsgLog);
            StringBuilder stringBuilder = new StringBuilder();
            String string = System.getProperty("line.separator");
            for (String string2 : arrayList) {
                stringBuilder.append(string2).append(string);
            }
            return stringBuilder.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getIndexSize() {
            Object object = this.mIndexSupport.lock;
            synchronized (object) {
                TreeMap treeMap = this.mIndexSupport.mGlobalComponentIndex;
                if (treeMap != null) {
                    return treeMap.size();
                }
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean indexContains(String string) {
            Object object = this.mIndexSupport.lock;
            synchronized (object) {
                TreeMap treeMap = this.mIndexSupport.mGlobalComponentIndex;
                if (treeMap != null) {
                    return treeMap.containsKey(string);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isSupportIndex() {
            Object object = this.mIndexSupport.lock;
            synchronized (object) {
                this.mIndexSupport.checkGlobalComponentIndexRequired();
                return this.mIndexSupport.mSupportIndex;
            }
        }

        public void setIndexAllowed(boolean bl) {
            this.mIndexAllowed = bl;
        }

        public boolean isIndexAllowed() {
            return this.mIndexAllowed;
        }
    }
}

