/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog.impl;

import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.netbeans.modules.xml.catalog.lib.FilterIterator;
import org.netbeans.modules.xml.catalog.lib.IteratorIterator;
import org.netbeans.modules.xml.catalog.spi.CatalogListener;
import org.openide.util.Utilities;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractCatalog {
    private Map publicMap = new HashMap();
    private Map systemMap = new HashMap();
    private String location;
    private Vector listeners;
    private Map delegate = new HashMap();
    private Vector delegateOrder = new Vector();
    protected Vector extenders = new Vector();
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public void setLocation(String string) {
        this.location = string;
    }

    public String getLocation() {
        return this.location;
    }

    public synchronized void addCatalogListener(CatalogListener catalogListener) {
        if (this.listeners == null) {
            this.listeners = new Vector(2);
        }
        this.listeners.add(catalogListener);
    }

    public synchronized void removeCatalogListener(CatalogListener catalogListener) {
        if (this.listeners == null) {
            return;
        }
        if (this.listeners != null) {
            this.listeners.remove(catalogListener);
        }
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyInvalidate() {
        CatalogListener[] catalogListenerArray = null;
        AbstractCatalog abstractCatalog = this;
        synchronized (abstractCatalog) {
            if (this.listeners == null || this.listeners.isEmpty()) {
                return;
            }
            catalogListenerArray = this.listeners.toArray(new CatalogListener[0]);
        }
        for (int i = 0; i < catalogListenerArray.length; ++i) {
            catalogListenerArray[i].notifyInvalidate();
        }
    }

    public void addPublicMapping(String string, String string2) {
        this.publicMap.put(string, string2);
    }

    public void removePublicMapping(System system) {
        this.publicMap.remove(system);
    }

    public Iterator getPublicMappingKeys() {
        return this.publicMap.keySet().iterator();
    }

    public String getPublicMapping(String string) {
        return (String)this.publicMap.get(string);
    }

    public void addSystemMapping(String string, String string2) {
        this.systemMap.put(string, string2);
    }

    public void removeSystemMapping(String string) {
        this.systemMap.remove(string);
    }

    public Iterator getSystemMappingKeys() {
        return this.systemMap.keySet().iterator();
    }

    protected void clearAll() {
        this.publicMap.clear();
        this.systemMap.clear();
        this.delegate.clear();
        this.delegateOrder.clear();
        this.extenders.clear();
    }

    public String getSystemMapping(String string) {
        return (String)this.systemMap.get(string);
    }

    public Iterator getPublicIDs() {
        return this.getPublicIDs("");
    }

    private Iterator getPublicIDs(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        IteratorIterator iteratorIterator = new IteratorIterator();
        iteratorIterator.add(this.getPublicMappingKeys());
        Iterator iterator = this.extenders.iterator();
        while (iterator.hasNext()) {
            iteratorIterator.add(((AbstractCatalog)iterator.next()).getPublicIDs());
        }
        Enumeration enumeration = this.getDelegateCatalogKeys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            AbstractCatalog abstractCatalog = (AbstractCatalog)this.delegate.get(string2);
            iteratorIterator.add(abstractCatalog.getPublicIDs(string2));
        }
        return new FilterIterator(iteratorIterator, new PrefixFilter(string));
    }

    public String getSystemID(String string) {
        return this.getPublicMapping(string);
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        InputSource inputSource = this.resolvePublicId(string);
        if (inputSource != null) {
            return inputSource;
        }
        return this.resolveSystemId(string2);
    }

    protected InputSource resolvePublicId(String string) {
        String string2;
        if (string != null && (string2 = this.getPublicMapping(string)) != null) {
            InputSource inputSource = new InputSource(string2);
            inputSource.setPublicId(string);
            return inputSource;
        }
        return null;
    }

    protected InputSource resolveSystemId(String string) {
        if (string != null) {
            String string2 = this.getSystemMapping(string);
            if (string2 == null) {
                string2 = string;
            }
            return new InputSource(string2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDelegateCatalog(String string, AbstractCatalog abstractCatalog) {
        Map map = this.delegate;
        synchronized (map) {
            if (!this.delegate.containsKey(string)) {
                int n = this.delegateOrder.size();
                boolean bl = false;
                for (int i = 0; i < n; ++i) {
                    String string2 = (String)this.delegateOrder.elementAt(i);
                    if (!string.startsWith(string2) && string.compareTo(string2) >= 0) continue;
                    this.delegateOrder.insertElementAt(string, i);
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.delegateOrder.addElement(string);
                }
            }
            this.delegate.put(string, abstractCatalog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDelegateCatalog(String string) {
        Map map = this.delegate;
        synchronized (map) {
            this.delegate.remove(string);
            this.delegateOrder.removeElement(string);
        }
    }

    public Enumeration getDelegateCatalogKeys() {
        return this.delegateOrder.elements();
    }

    public AbstractCatalog getDelegateCatalog(String string) {
        return (AbstractCatalog)this.delegate.get(string);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.support.firePropertyChange(string, object, object2);
    }

    protected Image getDefaultIcon(int n) {
        try {
            BeanInfo beanInfo = Utilities.getBeanInfo(this.getClass());
            return beanInfo.getIcon(n);
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
    }

    protected Image getDefaultErrorIcon(int n) {
        if (this.getDefaultIcon(n) == null) {
            return null;
        }
        return null;
    }

    public String resolveURI(String string) {
        return null;
    }

    public String resolvePublic(String string) {
        return null;
    }

    private class PrefixFilter
    implements FilterIterator.Filter {
        private final String prefix;

        PrefixFilter(String string) {
            this.prefix = string;
        }

        public boolean accept(Object object) {
            return ((String)object).startsWith(this.prefix);
        }
    }
}

