/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.editor.BasePosition;
import org.netbeans.editor.CharSeq;
import org.netbeans.editor.GapStart;
import org.netbeans.editor.MarkVector;
import org.netbeans.editor.MultiMark;
import org.netbeans.lib.editor.util.AbstractCharSequence;

final class DocumentContent
implements AbstractDocument.Content,
CharSeq,
GapStart {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private static final UndoableEdit INVALID_EDIT = new AbstractUndoableEdit();
    private static final boolean debugUndo = Boolean.getBoolean("netbeans.debug.editor.document.undo");
    private final MarkVector markVector;
    private char[] charArray = EMPTY_CHAR_ARRAY;
    private int gapStart;
    private int gapLength;
    private boolean conservativeReallocation;

    DocumentContent() {
        this.markVector = new MarkVector();
        this.insertText(0, "\n");
    }

    public final int getGapStart() {
        return this.gapStart;
    }

    public UndoableEdit insertString(int n, String string) throws BadLocationException {
        this.checkBounds(n, 0, this.length() - 1);
        return new Edit(n, string);
    }

    public UndoableEdit remove(int n, int n2) throws BadLocationException {
        this.checkBounds(n, n2, this.length() - 1);
        return new Edit(n, n2);
    }

    public Position createPosition(int n) throws BadLocationException {
        this.checkOffset(n);
        BasePosition basePosition = new BasePosition();
        this.markVector.insert(this.markVector.createMark(basePosition, n));
        return basePosition;
    }

    public Position createBiasPosition(int n, Position.Bias bias) throws BadLocationException {
        this.checkOffset(n);
        BasePosition basePosition = new BasePosition();
        this.markVector.insert(this.markVector.createBiasMark(basePosition, n, bias));
        return basePosition;
    }

    MultiMark createBiasMark(int n, Position.Bias bias) throws BadLocationException {
        this.checkOffset(n);
        return this.markVector.insert(this.markVector.createBiasMark(n, bias));
    }

    MultiMark createMark(int n) throws BadLocationException {
        this.checkOffset(n);
        return this.markVector.insert(this.markVector.createMark(n));
    }

    public int length() {
        return this.charArray.length - this.gapLength;
    }

    public void getChars(int n, int n2, Segment segment) throws BadLocationException {
        this.checkBounds(n, n2, this.length());
        if (n + n2 <= this.gapStart) {
            segment.array = this.charArray;
            segment.offset = n;
        } else if (n >= this.gapStart) {
            segment.array = this.charArray;
            segment.offset = n + this.gapLength;
        } else {
            segment.array = this.copySpanChars(n, n2);
            segment.offset = 0;
        }
        segment.count = n2;
    }

    public String getString(int n, int n2) throws BadLocationException {
        this.checkBounds(n, n2, this.length());
        return this.getText(n, n2);
    }

    String getText(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalStateException("offset=" + n + ", length=" + n2);
        }
        String string = n + n2 <= this.gapStart ? new String(this.charArray, n, n2) : (n >= this.gapStart ? new String(this.charArray, n + this.gapLength, n2) : new String(this.copySpanChars(n, n2)));
        return string;
    }

    public char charAt(int n) {
        return this.charArray[this.getRawIndex(n)];
    }

    public CharSequence createCharSequenceView() {
        return new CharSequenceImpl();
    }

    void compact() {
        if (this.gapLength > 0) {
            int n = this.charArray.length - this.gapLength;
            char[] cArray = new char[n];
            int n2 = this.gapStart + this.gapLength;
            System.arraycopy(this.charArray, 0, cArray, 0, this.gapStart);
            System.arraycopy(this.charArray, n2, cArray, this.gapStart, this.charArray.length - n2);
            this.charArray = cArray;
            this.gapStart = this.charArray.length;
            this.gapLength = 0;
        }
        this.markVector.compact();
    }

    boolean isConservativeReallocation() {
        return this.conservativeReallocation;
    }

    void setConservativeReallocation(boolean bl) {
        this.conservativeReallocation = bl;
    }

    private int getRawIndex(int n) {
        return n < this.gapStart ? n : n + this.gapLength;
    }

    private void moveGap(int n) {
        if (n <= this.gapStart) {
            int n2 = this.gapStart - n;
            System.arraycopy(this.charArray, n, this.charArray, this.gapStart + this.gapLength - n2, n2);
            this.gapStart = n;
        } else {
            int n3 = this.gapStart + this.gapLength;
            int n4 = n - this.gapStart;
            System.arraycopy(this.charArray, n3, this.charArray, this.gapStart, n4);
            this.gapStart += n4;
        }
    }

    private void enlargeGap(int n) {
        int n2 = this.conservativeReallocation ? Math.min(4096, this.charArray.length / 10) : this.charArray.length;
        n2 = Math.max(10, this.charArray.length + n2 + n);
        int n3 = this.gapStart + this.gapLength;
        int n4 = this.charArray.length - n3;
        int n5 = n2 - n4;
        char[] cArray = new char[n2];
        System.arraycopy(this.charArray, 0, cArray, 0, this.gapStart);
        System.arraycopy(this.charArray, n3, cArray, n5, n4);
        this.charArray = cArray;
        this.gapLength = n5 - this.gapStart;
    }

    private char[] copyChars(int n, int n2) {
        char[] cArray;
        if (n + n2 <= this.gapStart) {
            cArray = new char[n2];
            System.arraycopy(this.charArray, n, cArray, 0, n2);
        } else if (n >= this.gapStart) {
            cArray = new char[n2];
            System.arraycopy(this.charArray, n + this.gapLength, cArray, 0, n2);
        } else {
            cArray = this.copySpanChars(n, n2);
        }
        return cArray;
    }

    private char[] copySpanChars(int n, int n2) {
        char[] cArray = new char[n2];
        int n3 = this.gapStart - n;
        System.arraycopy(this.charArray, n, cArray, 0, n3);
        System.arraycopy(this.charArray, this.gapStart + this.gapLength, cArray, n3, n2 - n3);
        return cArray;
    }

    void insertText(int n, String string) {
        int n2 = string.length();
        int n3 = n2 - this.gapLength;
        if (n3 > 0) {
            this.enlargeGap(n3);
        }
        if (n != this.gapStart) {
            this.moveGap(n);
        }
        string.getChars(0, n2, this.charArray, this.gapStart);
        this.gapStart += n2;
        this.gapLength -= n2;
    }

    void removeText(int n, int n2) {
        if (n >= this.gapStart) {
            if (n > this.gapStart) {
                this.moveGap(n);
            }
        } else {
            int n3 = n + n2;
            if (n3 <= this.gapStart) {
                if (n3 < this.gapStart) {
                    this.moveGap(n3);
                }
                this.gapStart -= n2;
            } else {
                this.gapStart = n;
            }
        }
        this.gapLength += n2;
    }

    private void checkOffset(int n) throws BadLocationException {
        if (n > this.length()) {
            throw new BadLocationException("Invalid offset=" + n + ", docLength=" + (this.length() - 1), n);
        }
    }

    private void checkBounds(int n, int n2, int n3) throws BadLocationException {
        if (n < 0) {
            throw new BadLocationException("Invalid offset=" + n, n);
        }
        if (n2 < 0) {
            throw new BadLocationException("Invalid length" + n2, n2);
        }
        if (n + n2 > n3) {
            throw new BadLocationException("docLength=" + (this.length() - 1) + ":  Invalid offset" + (n2 != 0 ? "+length" : "") + "=" + (n + n2), n + n2);
        }
    }

    class Edit
    extends AbstractUndoableEdit {
        private int offset;
        private int length;
        private String text;
        private MarkVector.Undo markVectorUndo;

        Edit(int n, String string) {
            this.offset = n;
            this.length = string.length();
            this.text = string;
            this.undoOrRedo(this.length, false);
        }

        Edit(int n, int n2) {
            this.offset = n;
            this.length = -n2;
            this.text = DocumentContent.this.getText(n, n2);
            this.undoOrRedo(-n2, false);
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (debugUndo) {
                System.err.println("UNDO-" + this.dump());
            }
            this.undoOrRedo(-this.length, true);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            if (debugUndo) {
                System.err.println("REDO-" + this.dump());
            }
            this.undoOrRedo(this.length, false);
        }

        private String dump() {
            return (this.length >= 0 ? "INSERT" : "REMOVE") + ":offset=" + this.offset + ", length=" + this.length + ", text='" + this.text + '\'';
        }

        private void undoOrRedo(int n, boolean bl) {
            if (n < 0) {
                DocumentContent.this.removeText(this.offset, -n);
            } else {
                DocumentContent.this.insertText(this.offset, this.text);
            }
            this.markVectorUndo = DocumentContent.this.markVector.update(this.offset, n, this.markVectorUndo);
        }

        final String getUndoRedoText() {
            return this.text;
        }
    }

    private final class CharSequenceImpl
    extends AbstractCharSequence.StringLike {
        private CharSequenceImpl() {
        }

        public char charAt(int n) {
            return DocumentContent.this.charAt(n);
        }

        public int length() {
            return DocumentContent.this.length();
        }

        public String toString() {
            return DocumentContent.this.getText(0, this.length());
        }
    }
}

