/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.diff.PatchAction;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningMainMenu;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectMenuItem
extends AbstractAction
implements Presenter.Popup {
    public JMenuItem getPopupPresenter() {
        return new DynamicDummyItem();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    private JComponent[] createItems() {
        Node[] nodeArray = this.getActivatedNodes();
        if (nodeArray.length > 0) {
            LazyMenu lazyMenu;
            Set<VersioningSystem> set = this.getOwnersForProjectNodes(nodeArray);
            if (set.size() != 1) {
                return new JComponent[0];
            }
            VersioningSystem versioningSystem = set.iterator().next();
            VersioningSystem versioningSystem2 = this.getLocalHistory(nodeArray);
            ArrayList<LazyMenu> arrayList = new ArrayList<LazyMenu>();
            if (versioningSystem == null || versioningSystem.getVCSAnnotator() != null) {
                lazyMenu = new LazyMenu(nodeArray, versioningSystem);
                arrayList.add(lazyMenu);
            }
            if (versioningSystem2 != null && versioningSystem2.getVCSAnnotator() != null) {
                lazyMenu = new LazyMenu(nodeArray, versioningSystem2);
                arrayList.add(lazyMenu);
            }
            return arrayList.toArray(new JComponent[arrayList.size()]);
        }
        return new JComponent[0];
    }

    private VersioningSystem getLocalHistory(Node[] nodeArray) {
        Set<File> set = this.getRootFilesForProjectNodes(nodeArray);
        VersioningSystem versioningSystem = null;
        for (File file : set) {
            VersioningSystem versioningSystem2 = VersioningManager.getInstance().getLocalHistory(file);
            if (versioningSystem != null) {
                if (versioningSystem2 == null || versioningSystem2 == versioningSystem) continue;
                return null;
            }
            versioningSystem = versioningSystem2;
        }
        return versioningSystem;
    }

    private Set<VersioningSystem> getOwnersForProjectNodes(Node[] nodeArray) {
        Set<File> set = this.getRootFilesForProjectNodes(nodeArray);
        HashSet<VersioningSystem> hashSet = new HashSet<VersioningSystem>(2);
        boolean bl = false;
        for (File file : set) {
            VersioningSystem versioningSystem = VersioningManager.getInstance().getOwner(file);
            if (versioningSystem == null) {
                bl = true;
                continue;
            }
            hashSet.add(versioningSystem);
        }
        if (hashSet.size() == 0 && bl) {
            hashSet.add(null);
        }
        return hashSet;
    }

    private JComponent[] createVersioningSystemItems(VersioningSystem versioningSystem, Node[] nodeArray) {
        VCSAnnotator vCSAnnotator = versioningSystem.getVCSAnnotator();
        if (vCSAnnotator == null) {
            return null;
        }
        VCSContext vCSContext = VCSContext.forNodes(nodeArray);
        Action[] actionArray = vCSAnnotator.getActions(vCSContext, VCSAnnotator.ActionDestination.PopupMenu);
        JComponent[] jComponentArray = new JComponent[actionArray.length];
        int n = 0;
        for (Action action : actionArray) {
            if (action == null) {
                jComponentArray[n++] = Utils.createJSeparator();
                continue;
            }
            JMenuItem jMenuItem = this.createmenuItem(action);
            jComponentArray[n++] = jMenuItem;
        }
        return jComponentArray;
    }

    private JMenuItem createmenuItem(Action action) {
        JMenuItem jMenuItem;
        if (action instanceof SystemAction) {
            final SystemAction systemAction = (SystemAction)action;
            jMenuItem = new JMenuItem(new AbstractAction(systemAction.getName()){

                public void actionPerformed(ActionEvent actionEvent) {
                    systemAction.actionPerformed(actionEvent);
                }
            });
        } else {
            jMenuItem = new JMenuItem(action);
        }
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)((String)action.getValue("Name")));
        return jMenuItem;
    }

    private Node[] getActivatedNodes() {
        return TopComponent.getRegistry().getActivatedNodes();
    }

    private Set<File> getRootFilesForProjectNodes(Node[] nodeArray) {
        HashSet<File> hashSet = new HashSet<File>(nodeArray.length);
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            Project project = (Project)node.getLookup().lookup(Project.class);
            if (project == null) continue;
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
            for (int j = 0; j < sourceGroupArray.length; ++j) {
                SourceGroup sourceGroup = sourceGroupArray[j];
                FileObject fileObject = sourceGroup.getRootFolder();
                File file = FileUtil.toFile((FileObject)fileObject);
                if (file == null) continue;
                hashSet.add(file);
            }
        }
        return hashSet;
    }

    private class LazyMenu
    extends JMenu {
        private final Node[] nodes;
        private final VersioningSystem owner;
        boolean initialized;

        private LazyMenu(Node[] nodeArray, VersioningSystem versioningSystem) {
            super(versioningSystem == null ? NbBundle.getMessage(ProjectMenuItem.class, (String)"CTL_MenuItem_VersioningMenu") : Utils.getDisplayName(versioningSystem));
            this.nodes = nodeArray;
            this.owner = versioningSystem;
        }

        public JPopupMenu getPopupMenu() {
            if (!this.initialized) {
                super.removeAll();
                if (this.owner == null) {
                    Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(VersioningSystem.class));
                    ArrayList arrayList = new ArrayList(result.allInstances());
                    Collections.sort(arrayList, new VersioningMainMenu.ByDisplayNameComparator());
                    for (VersioningSystem versioningSystem : arrayList) {
                        if (versioningSystem.getProperty("Boolean VCS.LocalHistory") != null) continue;
                        this.addVersioningSystemItems(versioningSystem, this.nodes);
                    }
                    this.addSeparator();
                    this.add(ProjectMenuItem.this.createmenuItem((Action)SystemAction.get(PatchAction.class)));
                } else {
                    this.addVersioningSystemItems(this.owner, this.nodes);
                }
                this.initialized = true;
            }
            return super.getPopupMenu();
        }

        private void addVersioningSystemItems(VersioningSystem versioningSystem, Node[] nodeArray) {
            JComponent[] jComponentArray = ProjectMenuItem.this.createVersioningSystemItems(versioningSystem, nodeArray);
            if (jComponentArray != null) {
                for (JComponent jComponent : jComponentArray) {
                    this.add(jComponent);
                }
            }
        }
    }

    private class DynamicDummyItem
    extends JMenuItem
    implements DynamicMenuContent {
        private DynamicDummyItem() {
        }

        public JComponent[] getMenuPresenters() {
            return ProjectMenuItem.this.createItems();
        }

        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            return ProjectMenuItem.this.createItems();
        }
    }
}

