/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.modules.masterfs.providers.InterceptionListener;
import org.netbeans.modules.versioning.FilesystemInterceptor;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningAnnotationProvider;
import org.netbeans.modules.versioning.diff.DiffSidebarManager;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersioningManager
implements PropertyChangeListener,
LookupListener,
PreferenceChangeListener {
    public static final String EVENT_VERSIONED_ROOTS = "null VCS.VersionedFilesChanged";
    public static final String EVENT_STATUS_CHANGED = "Set<File> VCS.StatusChanged";
    public static final String EVENT_ANNOTATIONS_CHANGED = "Set<File> VCS.AnnotationsChanged";
    private static VersioningManager instance;
    private final FilesystemInterceptor filesystemInterceptor;
    private final Lookup.Result<VersioningSystem> systemsLookupResult;
    private final Collection<VersioningSystem> versioningSystems = new ArrayList<VersioningSystem>(2);
    private final Map<File, VersioningSystem> folderOwners = new HashMap<File, VersioningSystem>(200);
    private VersioningSystem localHistory;
    static final Logger LOG;
    private final Map<File, Boolean> localHistoryFiles = new LinkedHashMap<File, Boolean>(200);
    private Map<String, Set<String>> interceptedMethods = new HashMap<String, Set<String>>();
    private final VersioningSystem NULL_OWNER = new VersioningSystem(){};
    private int refreshSerial;

    public static synchronized VersioningManager getInstance() {
        if (instance == null) {
            instance = new VersioningManager();
            instance.init();
        }
        return instance;
    }

    private VersioningManager() {
        this.systemsLookupResult = Lookup.getDefault().lookup(new Lookup.Template(VersioningSystem.class));
        this.filesystemInterceptor = new FilesystemInterceptor();
    }

    private void init() {
        this.systemsLookupResult.addLookupListener((LookupListener)this);
        this.refreshVersioningSystems();
        this.filesystemInterceptor.init(this);
        VersioningSupport.getPreferences().addPreferenceChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshVersioningSystems() {
        int n = ++this.refreshSerial;
        Collection collection = this.systemsLookupResult.allInstances();
        if (n != this.refreshSerial) {
            return;
        }
        Collection<VersioningSystem> collection2 = this.versioningSystems;
        synchronized (collection2) {
            for (VersioningSystem versioningSystem : this.versioningSystems) {
                versioningSystem.removePropertyChangeListener(this);
            }
            this.versioningSystems.clear();
            this.localHistory = null;
            this.versioningSystems.addAll(collection);
            for (VersioningSystem versioningSystem : this.versioningSystems) {
                if (this.localHistory == null && Utils.isLocalHistory(versioningSystem)) {
                    this.localHistory = versioningSystem;
                }
                versioningSystem.addPropertyChangeListener(this);
            }
        }
        this.flushFileOwnerCache();
        this.refreshDiffSidebars(null);
        VersioningAnnotationProvider.refreshAllAnnotations();
    }

    InterceptionListener getInterceptionListener() {
        return this.filesystemInterceptor;
    }

    private void refreshDiffSidebars(Set<File> set) {
        DiffSidebarManager.getInstance().refreshSidebars(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushFileOwnerCache() {
        Map<File, VersioningSystem> map = this.folderOwners;
        synchronized (map) {
            this.folderOwners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VersioningSystem[] getVersioningSystems() {
        Collection<VersioningSystem> collection = this.versioningSystems;
        synchronized (collection) {
            return this.versioningSystems.toArray(new VersioningSystem[this.versioningSystems.size()]);
        }
    }

    VersioningSystem[] getOwners(VCSContext vCSContext) {
        Set<File> set = vCSContext.getRootFiles();
        HashSet<VersioningSystem> hashSet = new HashSet<VersioningSystem>();
        for (File file : set) {
            VersioningSystem versioningSystem = this.getOwner(file);
            if (versioningSystem == null) continue;
            hashSet.add(versioningSystem);
        }
        return hashSet.toArray(new VersioningSystem[hashSet.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersioningSystem getOwner(File file) {
        VersioningSystem[] versioningSystemArray;
        Object object;
        LOG.log(Level.FINE, "looking for owner of " + file);
        VersioningSystem versioningSystem = null;
        Object object2 = this.folderOwners;
        synchronized (object2) {
            versioningSystem = this.folderOwners.get(file);
        }
        if (versioningSystem == this.NULL_OWNER) {
            LOG.log(Level.FINE, " cached NULL_OWNER of {0}", new Object[]{file});
            return null;
        }
        if (versioningSystem != null) {
            LOG.log(Level.FINE, " cached owner {0} of {1}", new Object[]{versioningSystem.getClass().getName(), file});
            return versioningSystem;
        }
        object2 = file;
        if (Utils.isFile(file)) {
            object2 = file.getParentFile();
            if (object2 == null) {
                LOG.log(Level.FINE, " null parent");
                return null;
            }
            object = this.folderOwners;
            synchronized (object) {
                versioningSystem = this.folderOwners.get(object2);
            }
        }
        if (versioningSystem == this.NULL_OWNER) {
            LOG.log(Level.FINE, " cached NULL_OWNER of {0}", new Object[]{object2});
            return null;
        }
        if (versioningSystem != null) {
            LOG.log(Level.FINE, " cached owner {0} of {1}", new Object[]{versioningSystem.getClass().getName(), object2});
            return versioningSystem;
        }
        object = null;
        for (VersioningSystem versioningSystem2 : versioningSystemArray = this.getVersioningSystems()) {
            if (versioningSystem2 == this.localHistory) continue;
            File file2 = versioningSystem2.getTopmostManagedAncestor((File)object2);
            LOG.log(Level.FINE, " {0} returns {1} ", new Object[]{versioningSystem2.getClass().getName(), file2});
            if (file2 == null || object != null && !Utils.isAncestorOrEqual(object, file2)) continue;
            LOG.log(Level.FINE, " owner = {0}", new Object[]{versioningSystem2.getClass().getName()});
            versioningSystem = versioningSystem2;
            object = file2;
        }
        Map<File, VersioningSystem> map = this.folderOwners;
        synchronized (map) {
            if (versioningSystem != null) {
                LOG.log(Level.FINE, " caching owner {0} of {1}", new Object[]{versioningSystem != null ? versioningSystem.getClass().getName() : null, object2});
                this.folderOwners.put((File)object2, versioningSystem);
            } else {
                while (object2 != null) {
                    LOG.log(Level.FINE, " caching unversioned folder {0}", new Object[]{object2});
                    this.folderOwners.put((File)object2, this.NULL_OWNER);
                    object2 = ((File)object2).getParentFile();
                }
            }
        }
        LOG.log(Level.FINE, "owner = {0}", new Object[]{versioningSystem != null ? versioningSystem.getClass().getName() : null});
        return versioningSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VersioningSystem getLocalHistory(File file) {
        boolean bl;
        Object object;
        if (this.localHistory == null) {
            return null;
        }
        Object object2 = this.localHistoryFiles;
        synchronized (object2) {
            object = this.localHistoryFiles.get(file);
            if (object != null && ((Boolean)object).booleanValue()) {
                return this.localHistory;
            }
        }
        object2 = file;
        if (Utils.isFile(file) && (object2 = file.getParentFile()) == null) {
            return null;
        }
        object = this.localHistoryFiles;
        synchronized (object) {
            Boolean bl2 = this.localHistoryFiles.get(object2);
            if (bl2 != null) {
                return bl2 != false ? this.localHistory : null;
            }
        }
        boolean bl3 = bl = this.localHistory.getTopmostManagedAncestor((File)object2) != null;
        if (bl) {
            this.putLocalHistoryFile(Boolean.TRUE, new File[]{object2});
            return this.localHistory;
        }
        bl = this.localHistory.getTopmostManagedAncestor(file) != null;
        this.putLocalHistoryFile(bl, new File[]{file, object2});
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putLocalHistoryFile(Boolean bl, File ... fileArray) {
        Map<File, Boolean> map = this.localHistoryFiles;
        synchronized (map) {
            if (this.localHistoryFiles.size() > 1500) {
                Iterator<File> iterator = this.localHistoryFiles.keySet().iterator();
                for (int i = 0; i < 150; ++i) {
                    iterator.next();
                    iterator.remove();
                }
            }
            for (File file : fileArray) {
                this.localHistoryFiles.put(file, bl);
            }
        }
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.refreshVersioningSystems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (EVENT_STATUS_CHANGED.equals(propertyChangeEvent.getPropertyName())) {
            Set set = (Set)propertyChangeEvent.getNewValue();
            VersioningAnnotationProvider.instance.refreshAnnotations(set);
            this.refreshDiffSidebars(set);
        } else if (EVENT_ANNOTATIONS_CHANGED.equals(propertyChangeEvent.getPropertyName())) {
            Set set = (Set)propertyChangeEvent.getNewValue();
            VersioningAnnotationProvider.instance.refreshAnnotations(set);
        } else if (EVENT_VERSIONED_ROOTS.equals(propertyChangeEvent.getPropertyName())) {
            if (propertyChangeEvent.getSource() == this.localHistory) {
                Map<File, Boolean> map = this.localHistoryFiles;
                synchronized (map) {
                    this.localHistoryFiles.clear();
                }
            } else {
                this.flushFileOwnerCache();
                this.refreshDiffSidebars(null);
            }
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        VersioningAnnotationProvider.instance.refreshAnnotations(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean needsLocalHistory(String string) {
        boolean bl;
        boolean bl2;
        block5: {
            bl2 = false;
            if (this.localHistory != null) break block5;
            boolean bl3 = bl2;
            LOG.log(Level.FINE, "needsLocalHistory method [{0}] returns {1}", new Object[]{string, bl2});
            return bl3;
        }
        try {
            Set<String> set = this.interceptedMethods.get(this.localHistory.getClass().getName());
            if (set == null) {
                Method[] methodArray;
                set = new HashSet<String>();
                for (Method method : methodArray = this.localHistory.getVCSInterceptor().getClass().getDeclaredMethods()) {
                    if ((method.getModifiers() & 1) == 0) continue;
                    set.add(method.getName());
                }
                this.interceptedMethods.put(this.localHistory.getClass().getName(), set);
            }
            bl = bl2 = set.contains(string);
        }
        catch (Throwable throwable) {
            LOG.log(Level.FINE, "needsLocalHistory method [{0}] returns {1}", new Object[]{string, bl2});
            throw throwable;
        }
        LOG.log(Level.FINE, "needsLocalHistory method [{0}] returns {1}", new Object[]{string, bl2});
        return bl;
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.versioning");
    }
}

