/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.diff;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import org.netbeans.api.diff.Difference;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.diff.DiffModuleConfig;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;

class DiffTooltipContentPanel
extends JComponent {
    private Integer spacesPerTab;

    public DiffTooltipContentPanel(JTextComponent jTextComponent, String string, Difference difference) {
        JEditorPane jEditorPane = new JEditorPane();
        EditorKit editorKit = CloneableEditorSupport.getEditorKit((String)string);
        jEditorPane.setEditorKit(editorKit);
        Document document = editorKit.createDefaultDocument();
        if (!(document instanceof StyledDocument)) {
            document = new DefaultStyledDocument(new StyleContext());
            editorKit = new StyledEditorKit();
            jEditorPane.setEditorKit(editorKit);
        }
        StyledDocument styledDocument = (StyledDocument)document;
        try {
            editorKit.read(new StringReader(difference.getFirstText()), (Document)styledDocument, 0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        jEditorPane.setDocument(styledDocument);
        jEditorPane.setEditable(false);
        Color color = this.getBackgroundColor(difference.getType());
        jEditorPane.setBackground(color);
        EditorUI editorUI = Utilities.getEditorUI((JTextComponent)jEditorPane);
        Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument);
        int n = element.getElementCount();
        int n2 = editorUI.getLineHeight() * n;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            Element element2 = element.getElement(i);
            String string2 = null;
            try {
                string2 = styledDocument.getText(element2.getStartOffset(), element2.getEndOffset() - element2.getStartOffset());
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            string2 = this.replaceTabs(string, string2);
            int n4 = jTextComponent.getFontMetrics(jTextComponent.getFont()).stringWidth(string2);
            if (n4 <= n3) continue;
            n3 = n4;
        }
        if (n3 < 50) {
            n3 = 50;
        } else if (n3 < 150) {
            n3 += 10;
        }
        jEditorPane.setPreferredSize(new Dimension(n3 * 7 / 6, n2));
        if (!jEditorPane.isEditable()) {
            jEditorPane.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
        }
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        jScrollPane.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLACK));
        this.setLayout(new BorderLayout());
        this.add(jScrollPane);
    }

    private Color getBackgroundColor(int n) {
        DiffModuleConfig diffModuleConfig = DiffModuleConfig.getDefault();
        return n == 0 ? diffModuleConfig.getSidebarDeletedColor() : diffModuleConfig.getSidebarChangedColor();
    }

    private String replaceTabs(String string, String string2) {
        if (string2.contains("\t")) {
            if (this.spacesPerTab == null) {
                this.spacesPerTab = DiffModuleConfig.getDefault().getSpacesPerTabFor(string);
            }
            string2 = string2.replace("\t", DiffTooltipContentPanel.strCharacters(' ', this.spacesPerTab));
        }
        return string2;
    }

    private static String strCharacters(char c, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n-- > 0) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

