/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.api.configurator.impl.dynamic;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.identity.profile.api.configurator.ConfiguratorException;
import org.netbeans.modules.identity.profile.api.configurator.SecurityMechanism;
import org.netbeans.modules.identity.profile.api.configurator.ServerProperties;
import org.netbeans.modules.identity.profile.api.configurator.impl.dynamic.ClassLoaderManager;
import org.netbeans.modules.identity.profile.api.configurator.impl.dynamic.SecurityMechanismImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityMechanismRetriever {
    private static final String AM_PROVIDER_CONFIG_CLASS = "com.sun.identity.wss.provider.ProviderConfig";
    private static final String AM_GET_ALL_SUPPORT_SECURITY_MECH_METHOD = "getAllSupportedSecurityMech";
    private static final String AM_GET_ALL_MESSAGE_LEVEL_SECURITY_MECH_METHOD = "getAllMessageLevelSecurityMech";
    private static final String AM_SECURITY_MECHANISM_CLASS = "com.sun.identity.wss.security.SecurityMechanism";
    private static final String AM_GET_LIBERTY_SECURITY_MECHANISM_URIS_METHOD = "getLibertySecurityMechanismURIs";
    private static final String AM_GET_SECURITY_MECHANISM_METHOD = "getSecurityMechanism";
    private static final String AM_LIBERTY_DS_SECURITY_FIELD = "LIBERTY_DS_SECURITY";
    private ClassLoader loader;

    public SecurityMechanismRetriever(String string) {
        this.loader = ClassLoaderManager.getDefault().getClassLoader(ServerProperties.getInstance(string));
    }

    public Collection<SecurityMechanism> getAllSupportedSecurityMechanisms() {
        try {
            Class<?> clazz = this.loader.loadClass(AM_PROVIDER_CONFIG_CLASS);
            Method method = clazz.getMethod(AM_GET_ALL_SUPPORT_SECURITY_MECH_METHOD, new Class[0]);
            return this.convertToSecurityMechProxies((List)method.invoke(null, new Object[0]));
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    public Collection<SecurityMechanism> getAllMessageLevelSecurityMechanism() {
        try {
            Class<?> clazz = this.loader.loadClass(AM_PROVIDER_CONFIG_CLASS);
            Method method = clazz.getMethod(AM_GET_ALL_MESSAGE_LEVEL_SECURITY_MECH_METHOD, new Class[0]);
            return this.convertToSecurityMechProxies((List)method.invoke(null, new Object[0]));
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    public Collection<SecurityMechanism> getAllWSPLibertySecurityMechanisms() {
        try {
            Class<?> clazz = this.loader.loadClass(AM_SECURITY_MECHANISM_CLASS);
            Method method = clazz.getMethod(AM_GET_LIBERTY_SECURITY_MECHANISM_URIS_METHOD, new Class[0]);
            List list = (List)method.invoke(null, new Object[0]);
            method = clazz.getMethod(AM_GET_SECURITY_MECHANISM_METHOD, String.class);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                arrayList.add(method.invoke(null, string));
            }
            return this.convertToSecurityMechProxies(arrayList);
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    public Collection<SecurityMechanism> getAllWSCLibertySecurityMechanisms() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            Class<?> clazz = this.loader.loadClass(AM_SECURITY_MECHANISM_CLASS);
            Field field = clazz.getField(AM_LIBERTY_DS_SECURITY_FIELD);
            arrayList.add(field.get(null));
            return this.convertToSecurityMechProxies(arrayList);
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    private Collection<SecurityMechanism> convertToSecurityMechProxies(List list) {
        ArrayList<SecurityMechanismImpl> arrayList = new ArrayList<SecurityMechanismImpl>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SecurityMechanismImpl securityMechanismImpl = new SecurityMechanismImpl(iterator.next());
            arrayList.add(securityMechanismImpl);
        }
        return Collections.unmodifiableCollection(arrayList);
    }
}

