/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.metadata.model.MetadataUtilities;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.Column;
import org.netbeans.modules.db.metadata.model.api.ForeignKey;
import org.netbeans.modules.db.metadata.model.api.ForeignKeyColumn;
import org.netbeans.modules.db.metadata.model.api.Index;
import org.netbeans.modules.db.metadata.model.api.IndexColumn;
import org.netbeans.modules.db.metadata.model.api.MetadataException;
import org.netbeans.modules.db.metadata.model.api.Ordering;
import org.netbeans.modules.db.metadata.model.api.PrimaryKey;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.netbeans.modules.db.metadata.model.api.Value;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCColumn;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCForeignKey;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCForeignKeyColumn;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCIndex;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCIndexColumn;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCMetadata;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCPrimaryKey;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCSchema;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCUtils;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCValue;
import org.netbeans.modules.db.metadata.model.spi.TableImplementation;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCTable
extends TableImplementation {
    private static final Logger LOGGER = Logger.getLogger(JDBCTable.class.getName());
    private final JDBCSchema jdbcSchema;
    private final String name;
    private Map<String, Column> columns;
    private Map<String, Index> indexes;
    private Map<String, ForeignKey> foreignKeys;
    private PrimaryKey primaryKey;
    private boolean primaryKeyInitialized = false;
    private static final String SQL_EXCEPTION_NOT_YET_IMPLEMENTED = "not yet implemented";

    public JDBCTable(JDBCSchema jDBCSchema, String string) {
        this.jdbcSchema = jDBCSchema;
        this.name = string;
    }

    @Override
    public final Schema getParent() {
        return this.jdbcSchema.getSchema();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Collection<Column> getColumns() {
        return this.initColumns().values();
    }

    @Override
    public final Column getColumn(String string) {
        return MetadataUtilities.find(string, this.initColumns());
    }

    @Override
    public PrimaryKey getPrimaryKey() {
        return this.initPrimaryKey();
    }

    @Override
    public Index getIndex(String string) {
        return MetadataUtilities.find(string, this.initIndexes());
    }

    @Override
    public Collection<Index> getIndexes() {
        return this.initIndexes().values();
    }

    @Override
    public Collection<ForeignKey> getForeignKeys() {
        return this.initForeignKeys().values();
    }

    @Override
    public ForeignKey getForeignKeyByInternalName(String string) {
        return MetadataUtilities.find(string, this.initForeignKeys());
    }

    @Override
    public final void refresh() {
        this.columns = null;
        this.primaryKey = null;
        this.primaryKeyInitialized = false;
    }

    public String toString() {
        return "JDBCTable[name='" + this.name + "']";
    }

    protected JDBCColumn createJDBCColumn(ResultSet resultSet) throws SQLException {
        JDBCValue jDBCValue;
        int n = 0;
        if (this.isOdbc(resultSet)) {
            jDBCValue = JDBCValue.createTableColumnValueODBC(resultSet);
        } else {
            n = resultSet.getInt("ORDINAL_POSITION");
            jDBCValue = JDBCValue.createTableColumnValue(resultSet);
        }
        return new JDBCColumn(this.getTable(), n, jDBCValue);
    }

    private boolean isOdbc(ResultSet resultSet) throws SQLException {
        boolean bl = this.jdbcSchema.getJDBCCatalog().getJDBCMetadata().getDmd().getURL().startsWith("jdbc:odbc");
        if (bl) {
            try {
                resultSet.getInt("PRECISION");
                return true;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return false;
    }

    protected JDBCPrimaryKey createJDBCPrimaryKey(String string, Collection<Column> collection) {
        return new JDBCPrimaryKey(this.getTable(), string, collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createColumns() {
        LinkedHashMap<String, Column> linkedHashMap = new LinkedHashMap<String, Column>();
        try {
            ResultSet resultSet = this.jdbcSchema.getJDBCCatalog().getJDBCMetadata().getDmd().getColumns(this.jdbcSchema.getJDBCCatalog().getName(), this.jdbcSchema.getName(), this.name, "%");
            try {
                while (resultSet.next()) {
                    Column column = this.createJDBCColumn(resultSet).getColumn();
                    linkedHashMap.put(column.getName(), column);
                    LOGGER.log(Level.FINE, "Created column {0}", column);
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            this.filterSQLException(sQLException);
        }
        this.columns = Collections.unmodifiableMap(linkedHashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createIndexes() {
        LinkedHashMap<String, Index> linkedHashMap = new LinkedHashMap<String, Index>();
        try {
            ResultSet resultSet = this.jdbcSchema.getJDBCCatalog().getJDBCMetadata().getDmd().getIndexInfo(this.jdbcSchema.getJDBCCatalog().getName(), this.jdbcSchema.getName(), this.name, false, true);
            try {
                JDBCIndex jDBCIndex = null;
                String string = null;
                while (resultSet.next()) {
                    JDBCIndexColumn jDBCIndexColumn;
                    if (resultSet.getShort("TYPE") == 0) continue;
                    String string2 = resultSet.getString("INDEX_NAME");
                    if (jDBCIndex == null || !string.equals(string2)) {
                        jDBCIndex = this.createJDBCIndex(string2, resultSet);
                        LOGGER.log(Level.FINE, "Created index " + jDBCIndex);
                        linkedHashMap.put(jDBCIndex.getName(), jDBCIndex.getIndex());
                        string = string2;
                    }
                    if ((jDBCIndexColumn = this.createJDBCIndexColumn(jDBCIndex, resultSet)) == null) {
                        LOGGER.log(Level.INFO, "Cannot create index column for " + string2 + " from " + resultSet);
                        continue;
                    }
                    IndexColumn indexColumn = jDBCIndexColumn.getIndexColumn();
                    jDBCIndex.addColumn(indexColumn);
                    LOGGER.log(Level.FINE, "Added column " + indexColumn.getName() + " to index " + string2);
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            this.filterSQLException(sQLException);
        }
        this.indexes = Collections.unmodifiableMap(linkedHashMap);
    }

    protected JDBCIndex createJDBCIndex(String string, ResultSet resultSet) {
        Index.IndexType indexType = Index.IndexType.OTHER;
        boolean bl = false;
        try {
            indexType = JDBCUtils.getIndexType(resultSet.getShort("TYPE"));
            bl = !resultSet.getBoolean("NON_UNIQUE");
        }
        catch (SQLException sQLException) {
            this.filterSQLException(sQLException);
        }
        return new JDBCIndex(this.getTable(), string, indexType, bl);
    }

    protected JDBCIndexColumn createJDBCIndexColumn(JDBCIndex jDBCIndex, ResultSet resultSet) {
        Column column = null;
        int n = 0;
        Ordering ordering = Ordering.NOT_SUPPORTED;
        try {
            column = this.getColumn(resultSet.getString("COLUMN_NAME"));
            if (!this.isOdbc(resultSet)) {
                n = resultSet.getInt("ORDINAL_POSITION");
                ordering = JDBCUtils.getOrdering(resultSet.getString("ASC_OR_DESC"));
            }
        }
        catch (SQLException sQLException) {
            this.filterSQLException(sQLException);
        }
        if (column == null) {
            LOGGER.log(Level.INFO, "Cannot get column for index " + jDBCIndex + " from " + resultSet);
            return null;
        }
        return new JDBCIndexColumn(jDBCIndex.getIndex(), column.getName(), column, n, ordering);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createForeignKeys() {
        LinkedHashMap<String, ForeignKey> linkedHashMap = new LinkedHashMap<String, ForeignKey>();
        try {
            ResultSet resultSet = this.jdbcSchema.getJDBCCatalog().getJDBCMetadata().getDmd().getImportedKeys(this.jdbcSchema.getJDBCCatalog().getName(), this.jdbcSchema.getName(), this.name);
            try {
                JDBCForeignKey jDBCForeignKey = null;
                String string = null;
                while (resultSet.next()) {
                    String string2 = resultSet.getString("FK_NAME");
                    if (jDBCForeignKey == null || string2 == null || !string.equals(string2)) {
                        jDBCForeignKey = this.createJDBCForeignKey(string2, resultSet);
                        LOGGER.log(Level.FINE, "Created foreign key " + string2);
                        linkedHashMap.put(jDBCForeignKey.getInternalName(), jDBCForeignKey.getForeignKey());
                        string = string2;
                    }
                    ForeignKeyColumn foreignKeyColumn = this.createJDBCForeignKeyColumn(jDBCForeignKey, resultSet).getForeignKeyColumn();
                    jDBCForeignKey.addColumn(foreignKeyColumn);
                    LOGGER.log(Level.FINE, "Added foreign key column " + foreignKeyColumn.getName() + " to foreign key " + string2);
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            this.filterSQLException(sQLException);
        }
        this.foreignKeys = Collections.unmodifiableMap(linkedHashMap);
    }

    protected JDBCForeignKey createJDBCForeignKey(String string, ResultSet resultSet) {
        return new JDBCForeignKey(this.getTable(), string);
    }

    protected JDBCForeignKeyColumn createJDBCForeignKeyColumn(JDBCForeignKey jDBCForeignKey, ResultSet resultSet) {
        Table table = this.findReferredTable(resultSet);
        String string = null;
        Column column = null;
        string = null;
        Value value = null;
        int n = 0;
        try {
            table = this.findReferredTable(resultSet);
            string = resultSet.getString("PKCOLUMN_NAME");
            column = table.getColumn(string);
            if (column == null) {
                throw new MetadataException(this.getMessage("ERR_COL_NOT_FOUND", table.getParent().getParent().getName(), table.getParent().getName(), table.getName(), string));
            }
            string = resultSet.getString("FKCOLUMN_NAME");
            value = this.getColumn(string);
            n = resultSet.getInt("KEY_SEQ");
        }
        catch (SQLException sQLException) {
            this.filterSQLException(sQLException);
        }
        return new JDBCForeignKeyColumn(jDBCForeignKey.getForeignKey(), value.getName(), (Column)value, column, n);
    }

    private String getMessage(String string, String ... stringArray) {
        return NbBundle.getMessage(JDBCTable.class, (String)string, (Object[])stringArray);
    }

    private Table findReferredTable(ResultSet resultSet) {
        JDBCMetadata jDBCMetadata = this.jdbcSchema.getJDBCCatalog().getJDBCMetadata();
        Table table = null;
        try {
            Schema schema;
            Catalog catalog;
            String string = resultSet.getString("PKTABLE_CAT");
            if (string == null || string.length() == 0) {
                catalog = this.jdbcSchema.getParent();
            } else {
                catalog = jDBCMetadata.getCatalog(string);
                if (catalog == null) {
                    throw new MetadataException(this.getMessage("ERR_CATALOG_NOT_FOUND", string));
                }
            }
            String string2 = resultSet.getString("PKTABLE_SCHEM");
            if (string2 == null || string2.length() == 0) {
                schema = catalog.getSyntheticSchema();
            } else {
                schema = catalog.getSchema(string2);
                if (schema == null) {
                    throw new MetadataException(this.getMessage("ERR_SCHEMA_NOT_FOUND", string2, catalog.getName()));
                }
            }
            String string3 = resultSet.getString("PKTABLE_NAME");
            table = schema.getTable(string3);
            if (table == null) {
                throw new MetadataException(this.getMessage("ERR_TABLE_NOT_FOUND", string, string2, string3));
            }
        }
        catch (SQLException sQLException) {
            this.filterSQLException(sQLException);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createPrimaryKey() {
        String string = null;
        ArrayList<Column> arrayList = new ArrayList<Column>();
        try {
            ResultSet resultSet = this.jdbcSchema.getJDBCCatalog().getJDBCMetadata().getDmd().getPrimaryKeys(this.jdbcSchema.getJDBCCatalog().getName(), this.jdbcSchema.getName(), this.name);
            try {
                while (resultSet.next()) {
                    if (string == null) {
                        string = resultSet.getString("PK_NAME");
                    }
                    String string2 = resultSet.getString("COLUMN_NAME");
                    arrayList.add(this.getColumn(string2));
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            this.filterSQLException(sQLException);
        }
        this.primaryKey = this.createJDBCPrimaryKey(string, Collections.unmodifiableCollection(arrayList)).getPrimaryKey();
    }

    private Map<String, Column> initColumns() {
        if (this.columns != null) {
            return this.columns;
        }
        LOGGER.log(Level.FINE, "Initializing columns in {0}", this);
        this.createColumns();
        return this.columns;
    }

    private Map<String, Index> initIndexes() {
        if (this.indexes != null) {
            return this.indexes;
        }
        LOGGER.log(Level.FINE, "Initializing indexes in {0}", this);
        this.createIndexes();
        return this.indexes;
    }

    private Map<String, ForeignKey> initForeignKeys() {
        if (this.foreignKeys != null) {
            return this.foreignKeys;
        }
        LOGGER.log(Level.FINE, "Initializing foreign keys in {0}", this);
        this.createForeignKeys();
        return this.foreignKeys;
    }

    private PrimaryKey initPrimaryKey() {
        if (this.primaryKeyInitialized) {
            return this.primaryKey;
        }
        LOGGER.log(Level.FINE, "Initializing columns in {0}", this);
        this.getColumns();
        this.createPrimaryKey();
        this.primaryKeyInitialized = true;
        return this.primaryKey;
    }

    private void filterSQLException(SQLException sQLException) throws MetadataException {
        if (!SQL_EXCEPTION_NOT_YET_IMPLEMENTED.equalsIgnoreCase(sQLException.getMessage())) {
            throw new MetadataException(sQLException);
        }
        Logger.getLogger(JDBCTable.class.getName()).log(Level.FINE, sQLException.getLocalizedMessage(), sQLException);
    }
}

