/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.util.ArrayList;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.websvc.design.view.layout.TableLayout;
import org.netbeans.modules.websvc.design.view.widget.TableModel;

public class TableWidget
extends Widget {
    private static final Color HEADER_COLOR = new Color(217, 235, 255);
    private static final Color CELL_COLOR = Color.WHITE;
    private static final Color BORDER_COLOR = new Color(169, 197, 235);
    private static final Color SELECTED_BORDER_COLOR = new Color(255, 153, 0);
    private TableModel model;
    private static final int COLUMN_WIDTH = 100;

    public TableWidget(Scene scene, TableModel tableModel) {
        super(scene);
        this.model = tableModel;
        this.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.createTableHeader();
        this.createTable();
    }

    private void createTableHeader() {
        Scene scene = this.getScene();
        int n = this.model.getColumnCount();
        RowWidget rowWidget = new RowWidget(scene, n, null);
        this.addChild(rowWidget);
        for (int i = 0; i < n; ++i) {
            LabelWidget labelWidget = new LabelWidget(scene, this.model.getColumnName(i));
            if (i != 0) {
                labelWidget.setBorder((Border)new LineBorder(0, 1, 0, 0, BORDER_COLOR));
            }
            labelWidget.setAlignment(LabelWidget.Alignment.CENTER);
            labelWidget.setBackground((Paint)HEADER_COLOR);
            labelWidget.setOpaque(true);
            rowWidget.addChild((Widget)labelWidget);
        }
    }

    private void createTable() {
        Scene scene = this.getScene();
        int n = this.model.getColumnCount();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            RowWidget rowWidget = new RowWidget(scene, n, this.model.getUserObject(i));
            this.addChild(rowWidget);
            for (int j = 0; j < n; ++j) {
                final int n2 = j;
                final LabelWidget labelWidget = new LabelWidget(scene, this.model.getValueAt(i, j)){
                    private Object key;
                    {
                        super(scene, string);
                        this.key = new Object();
                    }

                    protected void notifyAdded() {
                        super.notifyAdded();
                        ObjectScene objectScene = (ObjectScene)this.getScene();
                        objectScene.addObject(this.key, new Widget[]{this});
                    }

                    protected void notifyRemoved() {
                        super.notifyRemoved();
                        ObjectScene objectScene = (ObjectScene)this.getScene();
                        objectScene.removeObject(this.key);
                    }

                    protected void notifyStateChanged(ObjectState objectState, ObjectState objectState2) {
                        if (objectState.isSelected() != objectState2.isSelected() || objectState.isFocused() != objectState2.isFocused()) {
                            this.setBorder((Border)(objectState2.isSelected() ? (objectState2.isFocused() ? BorderFactory.createDashedBorder((Color)SELECTED_BORDER_COLOR, (int)2, (int)2, (boolean)true) : BorderFactory.createLineBorder((int)1, (Color)SELECTED_BORDER_COLOR)) : (objectState2.isFocused() ? BorderFactory.createDashedBorder((Color)BORDER_COLOR, (int)2, (int)2, (boolean)true) : new LineBorder(0, n2 != 0 ? 1 : 0, 0, 0, BORDER_COLOR))));
                            this.revalidate(true);
                        }
                    }
                };
                if (j != 0) {
                    labelWidget.setBorder((Border)new LineBorder(0, 1, 0, 0, BORDER_COLOR));
                }
                labelWidget.setFont(this.getScene().getFont().deriveFont(1));
                labelWidget.setBackground((Paint)CELL_COLOR);
                labelWidget.setOpaque(true);
                labelWidget.setAlignment(LabelWidget.Alignment.CENTER);
                if (this.model.isCellEditable(i, j)) {
                    final int n3 = i;
                    final int n4 = j;
                    labelWidget.getActions().addAction(ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)new TextFieldInplaceEditor(){

                        public boolean isEnabled(Widget widget) {
                            return true;
                        }

                        public String getText(Widget widget) {
                            return TableWidget.this.model.getValueAt(n3, n4);
                        }

                        public void setText(Widget widget, String string) {
                            TableWidget.this.model.setValueAt(string, n3, n4);
                            labelWidget.setLabel(string);
                        }
                    }));
                }
                rowWidget.addChild((Widget)labelWidget);
            }
        }
    }

    private static class LineBorder
    implements Border {
        private Insets insets;
        private Color drawColor;

        public LineBorder(int n, int n2, int n3, int n4, Color color) {
            this.insets = new Insets(n, n2, n3, n4);
            this.drawColor = color;
        }

        public Insets getInsets() {
            return this.insets;
        }

        public void paint(Graphics2D graphics2D, Rectangle rectangle) {
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(this.drawColor);
            if (this.insets.top > 0) {
                graphics2D.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
            }
            if (this.insets.left > 0) {
                graphics2D.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
            }
            if (this.insets.bottom > 0) {
                graphics2D.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            }
            if (this.insets.right > 0) {
                graphics2D.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            }
            graphics2D.setPaint(paint);
        }

        public boolean isOpaque() {
            return true;
        }
    }

    private static class RowWidget
    extends Widget {
        private Object userObject;

        RowWidget(Scene scene, int n, Object object) {
            super(scene);
            this.setLayout(new TableLayout(n, 0, 0, 100));
            this.userObject = object;
            if (this.getScene() instanceof ObjectScene && object != null) {
                this.getActions().addAction(((ObjectScene)this.getScene()).createSelectAction());
                this.setBorder(new LineBorder(1, 0, 0, 0, BORDER_COLOR));
            }
        }

        protected void notifyAdded() {
            super.notifyAdded();
            if (this.getScene() instanceof ObjectScene && this.userObject != null) {
                ObjectScene objectScene = (ObjectScene)this.getScene();
                ArrayList<RowWidget> arrayList = objectScene.findWidgets(this.userObject);
                if (arrayList == null || arrayList.isEmpty()) {
                    objectScene.addObject(this.userObject, new Widget[]{this});
                } else {
                    objectScene.removeObject(this.userObject);
                    arrayList = new ArrayList<RowWidget>(arrayList);
                    arrayList.add(this);
                    objectScene.addObject(this.userObject, arrayList.toArray(new Widget[arrayList.size()]));
                }
            }
        }

        protected void notifyRemoved() {
            ObjectScene objectScene;
            ArrayList arrayList;
            super.notifyRemoved();
            if (this.getScene() instanceof ObjectScene && this.userObject != null && (arrayList = (objectScene = (ObjectScene)this.getScene()).findWidgets(this.userObject)) != null && arrayList.contains((Object)this)) {
                if (arrayList.size() == 1) {
                    objectScene.removeObject(this.userObject);
                } else {
                    arrayList = new ArrayList(arrayList);
                    arrayList.remove((Object)this);
                    objectScene.removeObject(this.userObject);
                    objectScene.addObject(this.userObject, arrayList.toArray(new Widget[arrayList.size()]));
                }
            }
        }

        protected void notifyStateChanged(ObjectState objectState, ObjectState objectState2) {
            if (objectState.isSelected() != objectState2.isSelected() || objectState.isFocused() != objectState2.isFocused()) {
                this.setBorder((Border)(objectState2.isSelected() ? (objectState2.isFocused() ? BorderFactory.createDashedBorder((Color)SELECTED_BORDER_COLOR, (int)2, (int)2, (boolean)true) : BorderFactory.createLineBorder((int)1, (Color)SELECTED_BORDER_COLOR)) : (objectState2.isFocused() ? BorderFactory.createDashedBorder((Color)BORDER_COLOR, (int)2, (int)2, (boolean)true) : new LineBorder(1, 0, 0, 0, BORDER_COLOR))));
                this.revalidate(true);
            }
        }
    }
}

