/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.common.project.ui.DeployOnSaveUtils;
import org.netbeans.modules.j2ee.common.ui.BrokenServerSupport;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.ui.IconBaseProvider;
import org.netbeans.modules.j2ee.earproject.ui.actions.AddModuleAction;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.project.ProjectProperties;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.ChangeSupport;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

public class J2eeArchiveLogicalViewProvider
implements LogicalViewProvider {
    private final EarProject project;
    protected final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    protected final ReferenceHelper resolver;
    private final List<? extends Action> specialActions = Collections.singletonList(SystemAction.get(AddModuleAction.class));
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private static final String[] BREAKABLE_PROPERTIES = new String[]{"debug.classpath", "endorsed.classpath", "jar.content.additional"};

    public J2eeArchiveLogicalViewProvider(EarProject earProject, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper) {
        this.project = earProject;
        assert (earProject != null);
        this.helper = updateHelper;
        assert (updateHelper != null);
        this.evaluator = propertyEvaluator;
        assert (propertyEvaluator != null);
        this.resolver = referenceHelper;
    }

    public Node createLogicalView() {
        return new ArchiveLogicalViewRootNode();
    }

    public Node findPath(Node node, Object object) {
        Project project = (Project)node.getLookup().lookup(Project.class);
        if (project == null) {
            return null;
        }
        if (object instanceof FileObject) {
            FileObject fileObject = (FileObject)object;
            Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (!project.equals(project2)) {
                return null;
            }
            Node node2 = this.findNodeUnderConfiguration(node, fileObject);
            if (node2 != null) {
                return node2;
            }
            Node[] nodeArray = node.getChildren().getNodes(true);
            for (int i = nodeArray.length - 1; i >= 0; --i) {
                node2 = PackageView.findPath((Node)nodeArray[i], (Object)object);
                if (node2 == null) continue;
                return node2;
            }
        }
        return null;
    }

    private Node findNodeUnderConfiguration(Node node, FileObject fileObject) {
        FileObject fileObject2 = this.helper.getAntProjectHelper().resolveFileObject(this.evaluator.getProperty("meta.inf"));
        String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
        if (string == null) {
            return null;
        }
        int n = string.indexOf(46);
        if (n != -1) {
            string = string.substring(0, n);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        Node node2 = node.getChildren().findChild("configurationFiles");
        while (node2 != null && stringTokenizer.hasMoreTokens()) {
            node2 = NodeOp.findChild((Node)node2, (String)stringTokenizer.nextToken());
        }
        return node2;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void testBroken() {
        this.changeSupport.fireChange();
    }

    private static Lookup createLookup(Project project, AntProjectHelper antProjectHelper) {
        DataFolder dataFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        Lookup lookup = null;
        lookup = null == antProjectHelper ? Lookups.fixed((Object[])new Object[]{project, dataFolder}) : Lookups.fixed((Object[])new Object[]{project, dataFolder, antProjectHelper});
        return lookup;
    }

    public static boolean hasBrokenLinks(AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
        return BrokenReferencesSupport.isBroken((AntProjectHelper)antProjectHelper, (ReferenceHelper)referenceHelper, (String[])BREAKABLE_PROPERTIES, (String[])new String[]{"platform.active"});
    }

    private String getIconBase() {
        IconBaseProvider iconBaseProvider = (IconBaseProvider)this.project.getLookup().lookup(IconBaseProvider.class);
        return null == iconBaseProvider ? "org/netbeans/modules/j2ee/earproject/ui/resources/" : iconBaseProvider.getIconBase();
    }

    private boolean isDeployOnSaveSupportedAndDisabled() {
        boolean bl = Boolean.valueOf(this.project.evaluator().getProperty("j2ee.deploy.on.save"));
        if (bl) {
            return false;
        }
        boolean bl2 = false;
        try {
            String string = this.project.evaluator().getProperty("j2ee.server.instance");
            if (string != null) {
                bl2 = Deployment.getDefault().getServerInstance(string).isDeployOnSaveSupported();
            }
        }
        catch (InstanceRemovedException instanceRemovedException) {
            // empty catch block
        }
        return bl2;
    }

    public static class Actions {
        private Actions() {
        }

        public static Action createAction(String string, String string2, boolean bl) {
            return new ActionImpl(string, string2, (Lookup)(bl ? Utilities.actionsGlobalContext() : null));
        }

        private static class ActionImpl
        extends AbstractAction
        implements ContextAwareAction {
            private static final long serialVersionUID = 1L;
            Lookup context;
            String name;
            String command;

            public ActionImpl(String string, String string2, Lookup lookup) {
                super(string2);
                this.context = lookup;
                this.command = string;
                this.name = string2;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Project project = (Project)this.context.lookup(Project.class);
                ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
                actionProvider.invokeAction(this.command, this.context);
            }

            public Action createContextAwareInstance(Lookup lookup) {
                return new ActionImpl(this.command, this.name, lookup);
            }
        }
    }

    final class ArchiveLogicalViewRootNode
    extends AbstractNode {
        private Action brokenLinksAction;
        private final BrokenServerAction brokenServerAction;
        private boolean broken;
        private boolean deployOnSaveDisabled;

        public ArchiveLogicalViewRootNode() {
            super(NodeFactorySupport.createCompositeChildren((Project)J2eeArchiveLogicalViewProvider.this.project, (String)"Projects/org-netbeans-modules-j2ee-earproject/Nodes"), J2eeArchiveLogicalViewProvider.createLookup(J2eeArchiveLogicalViewProvider.this.project, J2eeArchiveLogicalViewProvider.this.helper.getAntProjectHelper()));
            this.setIconBaseWithExtension(J2eeArchiveLogicalViewProvider.this.getIconBase() + "projectIcon.gif");
            super.setName(ProjectUtils.getInformation((Project)J2eeArchiveLogicalViewProvider.this.project).getDisplayName());
            if (J2eeArchiveLogicalViewProvider.hasBrokenLinks(J2eeArchiveLogicalViewProvider.this.helper.getAntProjectHelper(), J2eeArchiveLogicalViewProvider.this.resolver)) {
                this.broken = true;
            }
            this.brokenServerAction = new BrokenServerAction();
            this.brokenLinksAction = new BrokenLinksAction();
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)J2eeArchiveLogicalViewProvider.this.project.getLookup().lookup(J2eeModuleProvider.class);
            j2eeModuleProvider.addInstanceListener((InstanceListener)WeakListeners.create(InstanceListener.class, (EventListener)this.brokenServerAction, (Object)j2eeModuleProvider));
            this.deployOnSaveDisabled = J2eeArchiveLogicalViewProvider.this.isDeployOnSaveSupportedAndDisabled();
        }

        private synchronized void checkProjectValidity() {
            boolean bl;
            boolean bl2 = this.broken;
            this.broken = J2eeArchiveLogicalViewProvider.hasBrokenLinks(J2eeArchiveLogicalViewProvider.this.helper.getAntProjectHelper(), J2eeArchiveLogicalViewProvider.this.resolver);
            if (bl2 != this.broken) {
                this.getBrokenLinksAction().setEnabled(this.broken);
                this.fireIconChange();
                this.fireOpenedIconChange();
                this.fireDisplayNameChange(null, null);
            }
            if ((bl2 = this.deployOnSaveDisabled) != (bl = J2eeArchiveLogicalViewProvider.this.isDeployOnSaveSupportedAndDisabled())) {
                this.setDeployOnSaveDisabled(bl);
            }
        }

        public Action getBrokenLinksAction() {
            return this.brokenLinksAction;
        }

        public String getHtmlDisplayName() {
            String string = super.getDisplayName();
            try {
                string = XMLUtil.toElementContent((String)string);
            }
            catch (CharConversionException charConversionException) {
                // empty catch block
            }
            return this.broken || this.brokenServerAction.isEnabled() ? "<font color=\"#A40000\">" + string + "</font>" : null;
        }

        public String getShortDescription() {
            String string = FileUtil.getFileDisplayName((FileObject)J2eeArchiveLogicalViewProvider.this.project.getProjectDirectory());
            return NbBundle.getMessage(J2eeArchiveLogicalViewProvider.class, (String)"HINT_project_root_node", (Object)string);
        }

        public Action[] getActions(boolean bl) {
            return bl ? super.getActions(true) : this.getAdditionalActions();
        }

        public boolean canRename() {
            return true;
        }

        public void setName(String string) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)J2eeArchiveLogicalViewProvider.this.project, (String)string);
        }

        public Image getIcon(int n) {
            Image image = super.getIcon(n);
            if (this.broken || this.brokenServerAction.isEnabled()) {
                return ImageUtilities.mergeImages((Image)image, (Image)ProjectProperties.ICON_BROKEN_BADGE.getImage(), (int)8, (int)0);
            }
            if (this.deployOnSaveDisabled) {
                return DeployOnSaveUtils.badgeDisabledDeployOnSave((Image)image);
            }
            return image;
        }

        public Image getOpenedIcon(int n) {
            Image image = super.getOpenedIcon(n);
            if (this.broken || this.brokenServerAction.isEnabled()) {
                return ImageUtilities.mergeImages((Image)image, (Image)ProjectProperties.ICON_BROKEN_BADGE.getImage(), (int)8, (int)0);
            }
            if (this.deployOnSaveDisabled) {
                return DeployOnSaveUtils.badgeDisabledDeployOnSave((Image)image);
            }
            return image;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(ArchiveLogicalViewRootNode.class);
        }

        private void setDeployOnSaveDisabled(boolean bl) {
            this.deployOnSaveDisabled = bl;
            this.fireIconChange();
            this.fireOpenedIconChange();
            this.fireDisplayNameChange(null, null);
        }

        private Action[] getAdditionalActions() {
            ResourceBundle resourceBundle = NbBundle.getBundle(J2eeArchiveLogicalViewProvider.class);
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)J2eeArchiveLogicalViewProvider.this.project.getLookup().lookup(J2eeModuleProvider.class);
            ArrayList<Action> arrayList = new ArrayList<Action>();
            arrayList.addAll(J2eeArchiveLogicalViewProvider.this.specialActions);
            arrayList.add(CommonProjectActions.newFileAction());
            arrayList.add(null);
            arrayList.add(null);
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)resourceBundle.getString("LBL_BuildAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)resourceBundle.getString("LBL_RebuildAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"clean", (String)resourceBundle.getString("LBL_CleanAction_Name"), null));
            if (j2eeModuleProvider != null && j2eeModuleProvider.hasVerifierSupport()) {
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"verify", (String)resourceBundle.getString("LBL_VerifyAction_Name"), null));
            }
            arrayList.add(null);
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)resourceBundle.getString("LBL_RunAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"redeploy", (String)resourceBundle.getString("LBL_DeployAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"debug", (String)resourceBundle.getString("LBL_DebugAction_Name"), null));
            arrayList.addAll(Utilities.actionsForPath((String)"Projects/Profiler_Actions_temporary"));
            arrayList.add(null);
            arrayList.add(CommonProjectActions.setAsMainProjectAction());
            arrayList.add(CommonProjectActions.openSubprojectsAction());
            arrayList.add(CommonProjectActions.closeProjectAction());
            arrayList.add(null);
            arrayList.add(CommonProjectActions.renameProjectAction());
            arrayList.add(CommonProjectActions.moveProjectAction());
            arrayList.add(CommonProjectActions.copyProjectAction());
            arrayList.add(CommonProjectActions.deleteProjectAction());
            arrayList.add(null);
            arrayList.add((Action)SystemAction.get(FindAction.class));
            arrayList.addAll(Utilities.actionsForPath((String)"Projects/Actions"));
            arrayList.add(null);
            if (this.broken) {
                arrayList.add(this.getBrokenLinksAction());
            }
            if (this.brokenServerAction.isEnabled()) {
                arrayList.add(this.brokenServerAction);
            }
            arrayList.add(CommonProjectActions.customizeProjectAction());
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        private class BrokenServerAction
        extends AbstractAction
        implements InstanceListener,
        PropertyChangeListener {
            private static final long serialVersionUID = 1L;
            private boolean brokenServer;

            public BrokenServerAction() {
                this.putValue("Name", NbBundle.getMessage(J2eeArchiveLogicalViewProvider.class, (String)"LBL_Fix_Missing_Server_Action"));
                J2eeArchiveLogicalViewProvider.this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)J2eeArchiveLogicalViewProvider.this.evaluator));
                this.checkMissingServer();
            }

            public boolean isEnabled() {
                return this.brokenServer;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                Profile profile = Profile.fromPropertiesString((String)J2eeArchiveLogicalViewProvider.this.helper.getProperties("nbproject/project.properties").getProperty("j2ee.platform"));
                if (profile == null) {
                    profile = Profile.JAVA_EE_6_FULL;
                    Logger.getLogger(J2eeArchiveLogicalViewProvider.class.getName()).warning("project [" + J2eeArchiveLogicalViewProvider.this.project.getProjectDirectory() + "] is missing " + "j2ee.platform" + ". " + "default value will be used instead: " + profile);
                    this.updateJ2EESpec(J2eeArchiveLogicalViewProvider.this.project, J2eeArchiveLogicalViewProvider.this.project.getAntProjectHelper(), profile);
                }
                if ((string = BrokenServerSupport.selectServer((Profile)profile, (J2eeModule.Type)J2eeModule.Type.EAR)) != null) {
                    EarProjectProperties.setServerInstance(J2eeArchiveLogicalViewProvider.this.project, J2eeArchiveLogicalViewProvider.this.helper, string);
                }
                this.checkMissingServer();
            }

            private void updateJ2EESpec(final Project project, final AntProjectHelper antProjectHelper, final Profile profile) {
                ProjectManager.mutex().postWriteRequest(new Runnable(){

                    public void run() {
                        try {
                            EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                            editableProperties.put("j2ee.platform", profile.toPropertiesString());
                            antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                            ProjectManager.getDefault().saveProject(project);
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                    }
                });
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("j2ee.server.instance".equals(propertyChangeEvent.getPropertyName())) {
                    this.checkMissingServer();
                }
            }

            public void changeDefaultInstance(String string, String string2) {
            }

            public void instanceAdded(String string) {
                this.checkMissingServer();
            }

            public void instanceRemoved(String string) {
                this.checkMissingServer();
            }

            private void checkMissingServer() {
                boolean bl = this.brokenServer;
                String string = J2eeArchiveLogicalViewProvider.this.helper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("j2ee.server.instance");
                this.brokenServer = BrokenServerSupport.isBroken((String)string);
                if (bl != this.brokenServer) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ArchiveLogicalViewRootNode.this.fireIconChange();
                            ArchiveLogicalViewRootNode.this.fireOpenedIconChange();
                            ArchiveLogicalViewRootNode.this.fireDisplayNameChange(null, null);
                        }
                    });
                }
            }
        }

        private class BrokenLinksAction
        extends AbstractAction
        implements PropertyChangeListener,
        ChangeListener,
        Runnable {
            private static final long serialVersionUID = 1L;
            private RequestProcessor.Task task = null;
            private final PropertyChangeListener weakPCL;

            public BrokenLinksAction() {
                J2eeArchiveLogicalViewProvider.this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)J2eeArchiveLogicalViewProvider.this.evaluator));
                this.putValue("Name", NbBundle.getMessage(J2eeArchiveLogicalViewProvider.class, (String)"LBL_Fix_Broken_Links_Action"));
                this.weakPCL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)JavaPlatformManager.getDefault());
                JavaPlatformManager.getDefault().addPropertyChangeListener(this.weakPCL);
                J2eeArchiveLogicalViewProvider.this.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)J2eeArchiveLogicalViewProvider.this));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                BrokenReferencesSupport.showCustomizer((AntProjectHelper)J2eeArchiveLogicalViewProvider.this.helper.getAntProjectHelper(), (ReferenceHelper)J2eeArchiveLogicalViewProvider.this.resolver, (String[])BREAKABLE_PROPERTIES, (String[])new String[]{"platform.active"});
                ArchiveLogicalViewRootNode.this.checkProjectValidity();
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                this.refsMayChanged();
            }

            public void run() {
                ArchiveLogicalViewRootNode.this.checkProjectValidity();
            }

            public void stateChanged(ChangeEvent changeEvent) {
                this.refsMayChanged();
            }

            public void refsMayChanged() {
                if (this.task == null) {
                    this.task = RequestProcessor.getDefault().create((Runnable)this);
                }
                this.task.schedule(100);
            }
        }
    }
}

