/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsstack.jaxws.glassfish.v2;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.netbeans.modules.websvc.wsstack.api.WSTool;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWs;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.netbeans.modules.websvc.wsstack.spi.WSStackImplementation;
import org.netbeans.modules.websvc.wsstack.spi.WSToolImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassFishV2JaxWsStack
implements WSStackImplementation<JaxWs> {
    private static final String WEBSERVICES_TOOLS_JAR = "lib/webservices-tools.jar";
    private static final String WEBSERVICES_RT_JAR = "lib/webservices-rt.jar";
    private static final String TOOLS_JAR = "lib/tools.jar";
    private static final String JSTL_JAR = "lib/appserv-jstl.jar";
    private static final String JAVA_EE_JAR = "lib/javaee.jar";
    private static final String APPSERV_WS_JAR = "lib/appserv-ws.jar";
    private static final String MAIL_JAR = "lib/mail.jar";
    private static final String ACTIVATION_JAR = "lib/activation.jar";
    private File root;
    private String version;
    private JaxWs jaxWs;

    public GlassFishV2JaxWsStack(File file) {
        this.root = file;
        try {
            this.version = this.resolveImplementationVersion();
            if (this.version == null) {
                this.version = "2.1.3";
            }
        }
        catch (IOException iOException) {
            this.version = "2.1.3";
        }
        this.jaxWs = new JaxWs(this.getUriDescriptor());
    }

    public JaxWs get() {
        return this.jaxWs;
    }

    public WSStackVersion getVersion() {
        return WSStackFactory.createWSStackVersion((String)this.version);
    }

    public WSTool getWSTool(WSStack.Tool tool) {
        if (tool == JaxWs.Tool.WSIMPORT) {
            return WSStackFactory.createWSTool((WSToolImplementation)new JaxWsTool(JaxWs.Tool.WSIMPORT));
        }
        if (tool == JaxWs.Tool.WSGEN) {
            return WSStackFactory.createWSTool((WSToolImplementation)new JaxWsTool(JaxWs.Tool.WSGEN));
        }
        return null;
    }

    private JaxWs.UriDescriptor getUriDescriptor() {
        return new JaxWs.UriDescriptor(){

            public String getServiceUri(String string, String string2, String string3, boolean bl) {
                if (bl) {
                    return string2 + "/" + string3;
                }
                return string + "/" + string2;
            }

            public String getDescriptorUri(String string, String string2, String string3, boolean bl) {
                return this.getServiceUri(string, string2, string3, bl) + "?wsdl";
            }

            public String getTesterPageUri(String string, String string2, String string3, boolean bl) {
                return this.getServiceUri(string, string2, string3, bl) + "?Tester";
            }
        };
    }

    public boolean isFeatureSupported(WSStack.Feature feature) {
        return feature == JaxWs.Feature.JSR109 || feature == JaxWs.Feature.SERVICE_REF_INJECTION || feature == JaxWs.Feature.TESTER_PAGE || feature == JaxWs.Feature.WSIT;
    }

    private String resolveImplementationVersion() throws IOException {
        JarFile jarFile;
        JarEntry jarEntry;
        File file = new File(this.root, WEBSERVICES_TOOLS_JAR);
        if (!file.exists()) {
            file = new File(this.root, APPSERV_WS_JAR);
        }
        if (file.exists() && (jarEntry = (jarFile = new JarFile(file)).getJarEntry("com/sun/tools/ws/version.properties")) != null) {
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = null;
            String string2 = null;
            while ((string = bufferedReader.readLine()) != null) {
                String string3 = string.trim();
                if (!string3.startsWith("major-version=")) continue;
                string2 = string3.substring(14);
            }
            bufferedReader.close();
            return string2;
        }
        return null;
    }

    private class JaxWsTool
    implements WSToolImplementation {
        JaxWs.Tool tool;

        JaxWsTool(JaxWs.Tool tool) {
            this.tool = tool;
        }

        public String getName() {
            return this.tool.getName();
        }

        public URL[] getLibraries() {
            File file = new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.WEBSERVICES_TOOLS_JAR);
            try {
                if (file.exists()) {
                    return new URL[]{file.toURI().toURL(), new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.WEBSERVICES_RT_JAR).toURI().toURL(), new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.TOOLS_JAR).toURI().toURL(), new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.JSTL_JAR).toURI().toURL(), new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.JAVA_EE_JAR).toURI().toURL(), new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.APPSERV_WS_JAR).toURI().toURL(), new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.MAIL_JAR).toURI().toURL(), new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.ACTIVATION_JAR).toURI().toURL()};
                }
                return new URL[]{new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.TOOLS_JAR).toURI().toURL(), new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.JSTL_JAR).toURI().toURL(), new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.JAVA_EE_JAR).toURI().toURL(), new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.APPSERV_WS_JAR).toURI().toURL(), new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.MAIL_JAR).toURI().toURL(), new File(GlassFishV2JaxWsStack.this.root, GlassFishV2JaxWsStack.ACTIVATION_JAR).toURI().toURL()};
            }
            catch (MalformedURLException malformedURLException) {
                return new URL[0];
            }
        }
    }
}

