/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards.targetpanel.providers;

import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.target.iterator.api.TargetChooserPanel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.targetpanel.providers.JSFUIManager;
import org.netbeans.modules.web.wizards.targetpanel.providers.WebTargetPanelProvider;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFTargetPanelProvider
extends WebTargetPanelProvider<FileType> {
    static final String JSF = "jsf";
    static final String FACELETS_EXT = "xhtml";
    private JSFUIManager myUIManager = new JSFUIManager();

    @Override
    public void init(TargetChooserPanel<FileType> targetChooserPanel) {
        super.init(targetChooserPanel);
    }

    @Override
    public String getExpectedExtension(TargetChooserPanel<FileType> targetChooserPanel) {
        if (this.isFacelets()) {
            return FACELETS_EXT;
        }
        return Templates.getTemplate((WizardDescriptor)targetChooserPanel.getTemplateWizard()).getExt();
    }

    @Override
    public String getResultExtension(TargetChooserPanel<FileType> targetChooserPanel) {
        String string = Templates.getTemplate((WizardDescriptor)targetChooserPanel.getTemplateWizard()).getExt();
        if (this.getUIManager().isSegment()) {
            string = string + "f";
        } else if (this.isFacelets()) {
            string = FACELETS_EXT;
        }
        return string;
    }

    @Override
    public String getNewFileName() {
        return super.getNewFileName() + JSF;
    }

    public JSFUIManager getUIManager() {
        return this.myUIManager;
    }

    public String getWizardTitle() {
        return NbBundle.getMessage(JSFTargetPanelProvider.class, (String)"TITLE_JsfFile");
    }

    @Override
    public void storeSettings(TargetChooserPanel<FileType> targetChooserPanel) {
        if (this.isFacelets()) {
            Preferences preferences = ProjectUtils.getPreferences((Project)targetChooserPanel.getProject(), ProjectUtils.class, (boolean)true);
            String string = "jsf.language";
            String string2 = "Facelets";
            if (!preferences.get(string, "").equals(string2)) {
                preferences.put(string, string2);
            }
        }
        targetChooserPanel.getTemplateWizard().putProperty(FileType.IS_XML, (Object)false);
        targetChooserPanel.getTemplateWizard().putProperty(FileType.IS_SEGMENT, (Object)this.getUIManager().isSegment());
        targetChooserPanel.getTemplateWizard().putProperty(FileType.IS_FACELETS, (Object)this.getUIManager().isFacelets());
    }

    public boolean isApplicable(FileType fileType) {
        return fileType == FileType.JSF;
    }

    @Override
    protected WebModule getWebModule() {
        return this.myUIManager.getWebModule();
    }

    private boolean isFacelets() {
        return this.getUIManager().isFacelets();
    }
}

