/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards.targetpanel.providers;

import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.target.iterator.api.TargetChooserPanel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.targetpanel.providers.TagUIManager;
import org.netbeans.modules.web.wizards.targetpanel.providers.WebTargetPanelProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagTargetPanelProvider
extends WebTargetPanelProvider<FileType> {
    static final String TAG_FILE = "tag_file";
    public static final String IS_TLD_SELECTED = "isTldSelected";
    public static final String TLD_FILE_OBJECT = "tldFileObject";
    public static final String TAG_NAME = "tagName";
    private Profile myJ2eeVersion;
    private TagUIManager myUIManager = new TagUIManager();

    @Override
    public String getResultExtension(TargetChooserPanel<FileType> targetChooserPanel) {
        String string = super.getResultExtension(targetChooserPanel);
        if (this.getUIManager().isSegment()) {
            string = string + "f";
        } else if (this.getUIManager().isXml()) {
            string = string + "x";
        }
        return string;
    }

    @Override
    public String getNewFileName() {
        return super.getNewFileName() + TAG_FILE;
    }

    public TagUIManager getUIManager() {
        return this.myUIManager;
    }

    public String getWizardTitle() {
        return NbBundle.getMessage(TagTargetPanelProvider.class, (String)"TITLE_TagFile");
    }

    @Override
    public void init(TargetChooserPanel<FileType> targetChooserPanel) {
        WebModule webModule;
        this.myJ2eeVersion = Profile.J2EE_14;
        if (targetChooserPanel.getSourceGroups() != null && targetChooserPanel.getSourceGroups().length > 0 && (webModule = WebModule.getWebModule((FileObject)targetChooserPanel.getSourceGroups()[0].getRootFolder())) != null) {
            this.myJ2eeVersion = webModule.getJ2eeProfile();
        }
    }

    @Override
    public boolean isValid(TargetChooserPanel<FileType> targetChooserPanel) {
        if (Profile.J2EE_13.equals(this.myJ2eeVersion)) {
            targetChooserPanel.getTemplateWizard().putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TagTargetPanelProvider.class, (String)"MSG_13notSupported"));
            return false;
        }
        if (!targetChooserPanel.checkValid()) {
            return false;
        }
        if (this.getUIManager().isTldCheckBoxSelected()) {
            String string = null;
            FileObject fileObject = this.getUIManager().getTldFileObject();
            String string2 = this.getUIManager().getTagName();
            if (fileObject == null) {
                string = NbBundle.getMessage(TagTargetPanelProvider.class, (String)"MSG_noTldSelectedForTagFile");
            } else if (this.getUIManager().isTagNameEmpty(string2)) {
                string = NbBundle.getMessage(TagTargetPanelProvider.class, (String)"TXT_missingTagName");
            } else if (!this.getUIManager().isValidTagName(string2)) {
                string = NbBundle.getMessage(TagTargetPanelProvider.class, (String)"TXT_wrongTagName", (Object)string2);
            } else if (this.getUIManager().tagNameExists(string2)) {
                string = NbBundle.getMessage(TagTargetPanelProvider.class, (String)"TXT_tagNameExists", (Object)string2);
            }
            if (string != null) {
                targetChooserPanel.getTemplateWizard().putProperty("WizardPanel_errorMessage", (Object)string);
                return false;
            }
        }
        return true;
    }

    public boolean isApplicable(FileType fileType) {
        return fileType == FileType.TAG;
    }

    @Override
    public void storeSettings(TargetChooserPanel<FileType> targetChooserPanel) {
        targetChooserPanel.getTemplateWizard().putProperty(FileType.IS_XML, (Object)this.getUIManager().isXml());
        targetChooserPanel.getTemplateWizard().putProperty(FileType.IS_SEGMENT, (Object)this.getUIManager().isSegment());
        targetChooserPanel.getTemplateWizard().putProperty(IS_TLD_SELECTED, (Object)this.getUIManager().isTldCheckBoxSelected());
        targetChooserPanel.getTemplateWizard().putProperty(TLD_FILE_OBJECT, (Object)this.getUIManager().getTldFileObject());
        targetChooserPanel.getTemplateWizard().putProperty(TAG_NAME, (Object)this.getUIManager().getTagName());
    }

    @Override
    protected WebModule getWebModule() {
        return this.myUIManager.getWebModule();
    }
}

