/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.completion;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.editor.api.completion.CompletionItem;
import org.netbeans.modules.groovy.editor.api.completion.FieldSignature;
import org.netbeans.modules.groovy.editor.api.completion.MethodSignature;
import org.netbeans.modules.groovy.editor.spi.completion.CompletionContext;
import org.netbeans.modules.groovy.editor.spi.completion.DynamicCompletionProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainCompletionProvider
extends DynamicCompletionProvider {
    private static final Logger LOGGER = Logger.getLogger(DomainCompletionProvider.class.getName());
    private static final Map<MethodSignature, String> INSTANCE_METHODS = new HashMap<MethodSignature, String>();
    private static final Map<MethodSignature, String> STATIC_METHODS = new HashMap<MethodSignature, String>();
    private static final String[] NO_PARAMETERS = new String[0];
    private static final String FIND_BY_METHOD = "findBy";
    private static final String FIND_ALL_BY_METHOD = "findAllBy";
    private static final String COUNT_BY_METHOD = "countBy";
    private static final String LIST_ORDER_BY_METHOD = "listOrderBy";
    private static final Set<String> QUERY_OPERATOR = new HashSet<String>();
    private static final Set<String> QUERY_COMPARATOR = new HashSet<String>();

    public Map<FieldSignature, CompletionItem> getFields(CompletionContext completionContext) {
        return Collections.emptyMap();
    }

    public Map<MethodSignature, CompletionItem> getMethods(CompletionContext completionContext) {
        if (completionContext.getSourceFile() == null) {
            return Collections.emptyMap();
        }
        Project project = FileOwnerQuery.getOwner((FileObject)completionContext.getSourceFile());
        if (project != null && completionContext.isLeaf() && project.getLookup().lookup(DomainCompletionProvider.class) != null && this.isDomain(completionContext.getSourceFile(), project)) {
            HashMap<MethodSignature, CompletionItem> hashMap = new HashMap<MethodSignature, CompletionItem>();
            hashMap.putAll(this.getQueryMethods(completionContext));
            hashMap.putAll(this.getOrderMethods(completionContext));
            for (Map.Entry<MethodSignature, String> entry : STATIC_METHODS.entrySet()) {
                hashMap.put(entry.getKey(), CompletionItem.forDynamicMethod((int)completionContext.getAnchor(), (String)entry.getKey().getName(), (String[])entry.getKey().getParameters(), (String)entry.getValue(), (boolean)completionContext.isNameOnly(), (boolean)false));
            }
            if (!completionContext.isStaticContext()) {
                for (Map.Entry<MethodSignature, String> entry : INSTANCE_METHODS.entrySet()) {
                    hashMap.put(entry.getKey(), CompletionItem.forDynamicMethod((int)completionContext.getAnchor(), (String)entry.getKey().getName(), (String[])entry.getKey().getParameters(), (String)entry.getValue(), (boolean)completionContext.isNameOnly(), (boolean)false));
                }
            }
            return hashMap;
        }
        return Collections.emptyMap();
    }

    Map<MethodSignature, CompletionItem> getOrderMethods(CompletionContext completionContext) {
        HashMap<MethodSignature, CompletionItem> hashMap = new HashMap<MethodSignature, CompletionItem>();
        if (LIST_ORDER_BY_METHOD.startsWith(completionContext.getPrefix()) || completionContext.getPrefix().startsWith(LIST_ORDER_BY_METHOD)) {
            for (String string : completionContext.getProperties()) {
                String string2 = LIST_ORDER_BY_METHOD + this.capitalise(string);
                hashMap.put(new MethodSignature(string2, NO_PARAMETERS), CompletionItem.forDynamicMethod((int)completionContext.getAnchor(), (String)string2, (String[])NO_PARAMETERS, (String)"java.util.List", (boolean)completionContext.isNameOnly(), (boolean)false));
                hashMap.put(new MethodSignature(string2, new String[]{"java.util.Map"}), CompletionItem.forDynamicMethod((int)completionContext.getAnchor(), (String)string2, (String[])new String[]{"java.util.Map"}, (String)"java.util.List", (boolean)completionContext.isNameOnly(), (boolean)false));
            }
        }
        return hashMap;
    }

    Map<MethodSignature, CompletionItem> getQueryMethods(CompletionContext completionContext) {
        Object object;
        if (completionContext.getProperties().isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<MethodSignature, CompletionItem> hashMap = new HashMap<MethodSignature, CompletionItem>();
        Matcher matcher = this.getQueryMethodPattern(completionContext).matcher(completionContext.getPrefix());
        if (matcher.matches()) {
            boolean bl;
            Object object2 = matcher.group(13);
            if (object2 == null) {
                object2 = "";
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                int n = matcher.groupCount();
                for (int i = 1; i <= n; ++i) {
                    LOGGER.log(Level.FINE, "Group {0} {1}", new Object[]{i, matcher.group(i)});
                }
            }
            String string = completionContext.getPrefix().substring(0, completionContext.getPrefix().length() - ((String)object2).length());
            object = new HashMap();
            HashSet<String> hashSet = new HashSet<String>();
            int n = this.getUsedComparators(completionContext, hashSet);
            boolean bl2 = bl = matcher.group(7) != null && matcher.group(8) != null;
            if (matcher.group(10) != null) {
                if (!bl) {
                    object.putAll(this.getSuffixForOperator(string, completionContext, (String)object2, n));
                }
            } else if (matcher.group(9) != null) {
                object.putAll(this.getSuffixForComparator(string, completionContext, (String)object2, matcher.group(9), hashSet, n));
                if (!bl) {
                    object.putAll(this.getSuffixForOperator(string, completionContext, (String)object2, n));
                }
            } else if (matcher.group(7) != null) {
                object.putAll(this.getSuffixForProperty(string, completionContext, (String)object2, n));
            } else if (!bl) {
                object.putAll(this.getSuffixForProperty(string, completionContext, (String)object2, n));
            }
            for (Map.Entry entry : object.entrySet()) {
                this.addQueryEntries(hashMap, completionContext, matcher.group(1), ((String)entry.getKey()).substring(matcher.group(1).length()), (Integer)entry.getValue(), !bl);
            }
            if ("".equals(object2) && !matcher.group(1).equals(completionContext.getPrefix())) {
                this.addQueryEntries(hashMap, completionContext, matcher.group(1), string.substring(matcher.group(1).length()), n, false);
            }
        }
        if (!matcher.matches() || completionContext.getPrefix().equals(matcher.group(1))) {
            for (String string : completionContext.getProperties()) {
                object = this.capitalise(string);
                this.addQueryEntries(hashMap, completionContext, FIND_ALL_BY_METHOD, (String)object, 1, true);
                this.addQueryEntries(hashMap, completionContext, FIND_BY_METHOD, (String)object, 1, true);
                this.addQueryEntries(hashMap, completionContext, COUNT_BY_METHOD, (String)object, 1, true);
            }
        }
        return hashMap;
    }

    private Map<String, Integer> getSuffixForOperator(String string, CompletionContext completionContext, String string2, int n) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (String string3 : completionContext.getProperties()) {
            for (String string4 : QUERY_OPERATOR) {
                String string5 = string4 + this.capitalise(string3);
                if (!string5.startsWith(string2)) continue;
                hashMap.put(string + string5, n + 1);
            }
        }
        return hashMap;
    }

    private Map<String, Integer> getSuffixForComparator(String string, CompletionContext completionContext, String string2, String string3, Set<String> set, int n) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (String string4 : QUERY_COMPARATOR) {
            int n2 = n;
            String string5 = string4;
            if (!string5.startsWith(string2) || set.contains(string3 + string5)) continue;
            if ("Between".equals(string4)) {
                ++n2;
            } else if ("IsNotNull".equals(string4) || "IsNull".equals(string4)) {
                --n2;
            }
            hashMap.put(string + string5, n2);
        }
        return hashMap;
    }

    private Map<String, Integer> getSuffixForProperty(String string, CompletionContext completionContext, String string2, int n) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (String string3 : completionContext.getProperties()) {
            String string4 = this.capitalise(string3);
            if (!string4.startsWith(string2)) continue;
            hashMap.put(string + string4, n + 1);
        }
        return hashMap;
    }

    private Pattern getQueryMethodPattern(CompletionContext completionContext) {
        StringBuilder stringBuilder = new StringBuilder("(findBy|findAllBy|countBy)");
        stringBuilder.append("(");
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("(");
        for (String string : completionContext.getProperties()) {
            stringBuilder2.append(Pattern.quote(this.capitalise(string)));
            stringBuilder2.append('|');
        }
        stringBuilder2.setLength(stringBuilder2.length() - 1);
        stringBuilder2.append(")");
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("(LessThan(Equals)?|GreaterThan(Equals)?|Like|ILike|Equal|NotEqual|Between|IsNotNull|IsNull)?");
        stringBuilder.append("(And|Or)");
        stringBuilder.append(")?");
        stringBuilder.append("(");
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("(LessThan(Equals)?|GreaterThan(Equals)?|Like|ILike|Equal|NotEqual|Between|IsNotNull|IsNull)?");
        stringBuilder.append(")?");
        stringBuilder.append("(.*)");
        LOGGER.log(Level.FINE, "Method pattern is {0}", stringBuilder.toString());
        return Pattern.compile(stringBuilder.toString());
    }

    private int getUsedComparators(CompletionContext completionContext, Set<String> set) {
        Matcher matcher = Pattern.compile("(findBy|findAllBy|countBy)(.*)").matcher(completionContext.getPrefix());
        if (!matcher.matches()) {
            return 0;
        }
        String[] stringArray = matcher.group(2).split("(And|Or)");
        int n = 0;
        Pattern pattern = Pattern.compile("(.*)(LessThan(Equals)?|GreaterThan(Equals)?|Like|ILike|Equal|NotEqual|Between|IsNotNull|IsNull)?");
        for (String string : stringArray) {
            Matcher matcher2 = pattern.matcher(string);
            if (!matcher2.matches()) continue;
            String string2 = matcher2.group(2);
            if ("Between".equals(string2)) {
                n += 2;
                continue;
            }
            if (!"IsNotNull".equals(string2) && !"IsNull".equals(string2)) {
                ++n;
                continue;
            }
            if (string2 != null) continue;
            ++n;
        }
        return n;
    }

    private void addQueryEntries(Map<MethodSignature, CompletionItem> map, CompletionContext completionContext, String string, String string2, int n, boolean bl) {
        String string3 = "java.lang.Object";
        if (FIND_ALL_BY_METHOD.equals(string)) {
            string3 = "java.util.List";
        } else if (COUNT_BY_METHOD.equals(string)) {
            string3 = "int";
        }
        String string4 = string + string2;
        Object[] objectArray = new String[n];
        Arrays.fill(objectArray, "java.lang.Object");
        map.put(new MethodSignature(string4, (String[])objectArray), CompletionItem.forDynamicMethod((int)completionContext.getAnchor(), (String)string4, (String[])objectArray, (String)string3, (boolean)completionContext.isNameOnly(), (boolean)false));
        Object[] objectArray2 = new String[n + 1];
        Arrays.fill(objectArray2, "java.lang.Object");
        objectArray2[n] = "java.util.Map";
        map.put(new MethodSignature(string4, (String[])objectArray2), CompletionItem.forDynamicMethod((int)completionContext.getAnchor(), (String)string4, (String[])objectArray2, (String)string3, (boolean)completionContext.isNameOnly(), (boolean)false));
        if (bl) {
            map.put(new MethodSignature(string4 + "_", new String[0]), CompletionItem.forDynamicMethod((int)completionContext.getAnchor(), (String)string4, (String[])new String[0], (String)string3, (boolean)true, (boolean)true));
        }
    }

    private boolean isDomain(FileObject fileObject, Project project) {
        if (fileObject == null) {
            return false;
        }
        FileObject fileObject2 = project.getProjectDirectory().getFileObject("grails-app/domain");
        if (fileObject2 == null || !fileObject2.isFolder()) {
            return false;
        }
        return FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject);
    }

    private String capitalise(String string) {
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray = string.split("[^\\w\\d]")) {
            stringBuilder.append(string2.substring(0, 1).toUpperCase(Locale.ENGLISH)).append(string2.substring(1));
        }
        return stringBuilder.toString();
    }

    static {
        Collections.addAll(QUERY_OPERATOR, "And", "Or");
        Collections.addAll(QUERY_COMPARATOR, "LessThan", "LessThanEquals", "GreaterThan", "GreaterThanEquals", "Like", "ILike", "Equal", "NotEqual", "Between", "IsNotNull", "IsNull");
        INSTANCE_METHODS.put(new MethodSignature("attach", NO_PARAMETERS), "java.lang.Object");
        INSTANCE_METHODS.put(new MethodSignature("clearErrors", NO_PARAMETERS), "org.springframework.validation.Errors");
        INSTANCE_METHODS.put(new MethodSignature("delete", NO_PARAMETERS), "java.lang.Object");
        INSTANCE_METHODS.put(new MethodSignature("delete", new String[]{"java.util.Map"}), "java.lang.Object");
        INSTANCE_METHODS.put(new MethodSignature("discard", NO_PARAMETERS), "java.lang.Object");
        INSTANCE_METHODS.put(new MethodSignature("hasErrors", NO_PARAMETERS), "java.lang.Boolean");
        INSTANCE_METHODS.put(new MethodSignature("ident", NO_PARAMETERS), "java.lang.Object");
        INSTANCE_METHODS.put(new MethodSignature("lock", NO_PARAMETERS), "java.lang.Object");
        INSTANCE_METHODS.put(new MethodSignature("merge", new String[]{"java.lang.Object"}), "java.lang.Object");
        INSTANCE_METHODS.put(new MethodSignature("merge", NO_PARAMETERS), "java.lang.Object");
        INSTANCE_METHODS.put(new MethodSignature("refresh", NO_PARAMETERS), "java.lang.Object");
        INSTANCE_METHODS.put(new MethodSignature("save", new String[]{"java.lang.Boolean"}), "java.lang.Object");
        INSTANCE_METHODS.put(new MethodSignature("save", new String[]{"java.util.Map"}), "java.lang.Object");
        INSTANCE_METHODS.put(new MethodSignature("save", NO_PARAMETERS), "java.lang.Object");
        INSTANCE_METHODS.put(new MethodSignature("validate", NO_PARAMETERS), "java.lang.Boolean");
        INSTANCE_METHODS.put(new MethodSignature("isAttached", NO_PARAMETERS), "java.lang.Boolean");
        STATIC_METHODS.put(new MethodSignature("count", NO_PARAMETERS), "int");
        STATIC_METHODS.put(new MethodSignature("createCriteria", NO_PARAMETERS), "grails.orm.HibernateCriteriaBuilder");
        STATIC_METHODS.put(new MethodSignature("executeQuery", new String[]{"java.lang.String"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("executeQuery", new String[]{"java.lang.String", "java.util.Collection"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("executeQuery", new String[]{"java.lang.String", "java.util.Collection", "java.util.Map"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("executeQuery", new String[]{"java.lang.String", "java.util.Map"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("executeQuery", new String[]{"java.lang.String", "java.util.Map", "java.util.Map"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("executeUpdate", new String[]{"java.lang.String"}), "java.lang.Object");
        STATIC_METHODS.put(new MethodSignature("executeUpdate", new String[]{"java.lang.String", "java.util.Collection"}), "java.lang.Object");
        STATIC_METHODS.put(new MethodSignature("exists", NO_PARAMETERS), "java.lang.Boolean");
        STATIC_METHODS.put(new MethodSignature("find", new String[]{"java.lang.String"}), "java.lang.Object");
        STATIC_METHODS.put(new MethodSignature("find", new String[]{"java.lang.String", "java.util.Collection"}), "java.lang.Object");
        STATIC_METHODS.put(new MethodSignature("find", new String[]{"java.lang.String", "java.util.Map"}), "java.lang.Object");
        STATIC_METHODS.put(new MethodSignature("find", new String[]{"java.lang.Object"}), "java.lang.Object");
        STATIC_METHODS.put(new MethodSignature("findAll", NO_PARAMETERS), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("findAll", new String[]{"java.lang.String"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("findAll", new String[]{"java.lang.String", "java.util.Collection"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("findAll", new String[]{"java.lang.String", "java.util.Collection", "java.util.Map"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("findAll", new String[]{"java.lang.String", "java.util.Map"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("findAll", new String[]{"java.lang.String", "java.util.Map", "java.util.Map"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("findAll", new String[]{"java.lang.Object"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("findWhere", new String[]{"java.util.Map"}), "java.lang.Object");
        STATIC_METHODS.put(new MethodSignature("findAllWhere", new String[]{"java.util.Map"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("get", new String[]{"java.lang.Object"}), "java.lang.Object");
        STATIC_METHODS.put(new MethodSignature("getAll", NO_PARAMETERS), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("getAll", new String[]{"java.util.List"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("list", NO_PARAMETERS), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("list", new String[]{"java.util.Map"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("withCriteria", new String[]{"groovy.lang.Closure"}), "java.lang.Object");
        STATIC_METHODS.put(new MethodSignature("withCriteria", new String[]{"java.util.Map", "groovy.lang.Closure"}), "java.lang.Object");
        STATIC_METHODS.put(new MethodSignature("withTransaction", new String[]{"groovy.lang.Closure"}), "java.lang.Object");
    }
}

