/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeProvider
implements Lookup.Provider {
    private final TreeSet<Node> nodeSet;
    private final ChangeSupport changeSupport;
    private final Lookup lookup;
    protected boolean initialized = false;
    private boolean isProxied = false;

    public NodeProvider(Lookup lookup) {
        this.lookup = lookup;
        this.changeSupport = new ChangeSupport((Object)this);
        this.nodeSet = new TreeSet();
    }

    public NodeProvider(Lookup lookup, Comparator<Node> comparator) {
        this.lookup = lookup;
        this.changeSupport = new ChangeSupport((Object)this);
        this.nodeSet = new TreeSet<Node>(comparator);
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public synchronized Collection<Node> getNodes() {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        if (this.isProxied) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (Node node : this.nodeSet) {
                if (!(node instanceof BaseNode)) continue;
                BaseNode baseNode = (BaseNode)node;
                Collection<? extends Node> collection = baseNode.getNodeRegistry().getNodes();
                for (Node node2 : collection) {
                    arrayList.add(node2);
                }
            }
            return Collections.unmodifiableCollection(arrayList);
        }
        return Collections.unmodifiableCollection(this.nodeSet);
    }

    public synchronized void refresh() {
        this.initialized = false;
        TreeSet treeSet = (TreeSet)this.nodeSet.clone();
        for (Node node : treeSet) {
            if (!(node instanceof BaseNode)) continue;
            ((BaseNode)node).refresh();
        }
    }

    protected abstract void initialize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Node> getNodes(Object object) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        TreeSet<Node> treeSet = this.nodeSet;
        synchronized (treeSet) {
            for (Node node : this.nodeSet) {
                Object object2 = node.getLookup().lookup(object.getClass());
                if (object2.hashCode() != object.hashCode()) continue;
                arrayList.add(node);
            }
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProxyNodes(Collection<Node> collection) {
        TreeSet<Node> treeSet = this.nodeSet;
        synchronized (treeSet) {
            this.isProxied = true;
            this.nodeSet.clear();
            this.nodeSet.addAll(collection);
        }
        this.changeSupport.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodes(Collection<Node> collection) {
        TreeSet<Node> treeSet = this.nodeSet;
        synchronized (treeSet) {
            this.isProxied = false;
            this.nodeSet.clear();
            this.nodeSet.addAll(collection);
        }
        this.changeSupport.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(Node node) {
        TreeSet<Node> treeSet = this.nodeSet;
        synchronized (treeSet) {
            this.nodeSet.add(node);
        }
        this.changeSupport.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(Node node) {
        TreeSet<Node> treeSet = this.nodeSet;
        synchronized (treeSet) {
            this.nodeSet.remove(node);
        }
        this.changeSupport.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllNodes() {
        TreeSet<Node> treeSet = this.nodeSet;
        synchronized (treeSet) {
            this.nodeSet.clear();
        }
        this.changeSupport.fireChange();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }
}

