/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.io.IOException;
import java.text.MessageFormat;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.DriverNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExtendedDelete;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class DriverExtendedDeleteImpl
implements ExtendedDelete {
    public boolean delete(Node[] nodeArray) throws IOException {
        JDBCDriver[] jDBCDriverArray = DriverExtendedDeleteImpl.getJDBCDrivers(nodeArray);
        if (jDBCDriverArray == null) {
            return false;
        }
        DatabaseConnection databaseConnection = DriverExtendedDeleteImpl.findFirstConnection(jDBCDriverArray);
        if (databaseConnection == null) {
            return false;
        }
        if (!DriverExtendedDeleteImpl.canDeleteDrivers(jDBCDriverArray, databaseConnection)) {
            return true;
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            try {
                nodeArray[i].destroy();
                continue;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return true;
    }

    private static JDBCDriver[] getJDBCDrivers(Node[] nodeArray) {
        JDBCDriver[] jDBCDriverArray = new JDBCDriver[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            DriverNode driverNode = (DriverNode)((Object)nodeArray[i].getLookup().lookup(DriverNode.class));
            if (driverNode == null) {
                return null;
            }
            jDBCDriverArray[i] = driverNode.getDatabaseDriver().getJDBCDriver();
            if (jDBCDriverArray[i] != null) continue;
            return null;
        }
        return jDBCDriverArray;
    }

    private static DatabaseConnection findFirstConnection(JDBCDriver[] jDBCDriverArray) {
        DatabaseConnection[] databaseConnectionArray = ConnectionList.getDefault().getConnections();
        for (int i = 0; i < jDBCDriverArray.length; ++i) {
            int n;
            for (n = 0; n < databaseConnectionArray.length; ++n) {
                if (!jDBCDriverArray[i].getName().equals(databaseConnectionArray[n].getDriverName())) continue;
                return databaseConnectionArray[n];
            }
            for (n = 0; n < databaseConnectionArray.length; ++n) {
                if (!jDBCDriverArray[i].getClassName().equals(databaseConnectionArray[n].getDriver())) continue;
                return databaseConnectionArray[n];
            }
        }
        return null;
    }

    private static boolean canDeleteDrivers(JDBCDriver[] jDBCDriverArray, DatabaseConnection databaseConnection) {
        String string;
        String string2;
        if (jDBCDriverArray.length == 1) {
            String string3 = NbBundle.getMessage(DriverExtendedDeleteImpl.class, (String)"MSG_ConfirmDeleteDriver");
            string2 = MessageFormat.format(string3, jDBCDriverArray[0].getDisplayName(), databaseConnection.getDatabaseConnection().getDisplayName());
            string = NbBundle.getMessage(DriverExtendedDeleteImpl.class, (String)"MSG_ConfirmDeleteDriverTitle");
        } else {
            String string4 = NbBundle.getMessage(DriverExtendedDeleteImpl.class, (String)"MSG_ConfirmDeleteDrivers");
            string2 = MessageFormat.format(string4, new Integer(jDBCDriverArray.length));
            string = NbBundle.getMessage(DriverExtendedDeleteImpl.class, (String)"MSG_ConfirmDeleteDriversTitle");
        }
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)string2, string, 0)) == NotifyDescriptor.YES_OPTION;
    }
}

