/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.action.GrabTableHelper;
import org.netbeans.modules.db.explorer.action.RecreateTableAction;
import org.netbeans.modules.db.explorer.dlg.GrabTableProgressPanel;
import org.netbeans.modules.db.explorer.node.TableNode;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Column;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.windows.WindowManager;

public class GrabTableAction
extends BaseAction {
    public String getName() {
        return NbBundle.getMessage(GrabTableAction.class, (String)"GrabStructure");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(GrabTableAction.class);
    }

    protected boolean enable(Node[] nodeArray) {
        boolean bl = false;
        if (nodeArray.length == 1) {
            bl = nodeArray[0].getLookup().lookup(TableNode.class) != null;
        }
        return bl;
    }

    public void performAction(Node[] nodeArray) {
        final TableNode tableNode = (TableNode)nodeArray[0].getLookup().lookup(TableNode.class);
        try {
            Serializable serializable;
            final Specification specification = ((DatabaseConnection)tableNode.getLookup().lookup(DatabaseConnection.class)).getConnector().getDatabaseSpecification();
            String string = tableNode.getName();
            FileChooserBuilder fileChooserBuilder = new FileChooserBuilder(RecreateTableAction.class);
            fileChooserBuilder.setTitle(NbBundle.getMessage(GrabTableAction.class, (String)"GrabTableFileSaveDialogTitle"));
            fileChooserBuilder.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".grab");
                }

                public String getDescription() {
                    return NbBundle.getMessage(GrabTableAction.class, (String)"GrabTableFileTypeDescription");
                }
            });
            JFileChooser jFileChooser = fileChooserBuilder.createFileChooser();
            jFileChooser.setSelectedFile(new File(string + ".grab"));
            Frame frame = WindowManager.getDefault().getMainWindow();
            boolean bl = true;
            File file = null;
            while (bl) {
                if (jFileChooser.showSaveDialog(frame) == 0) {
                    file = jFileChooser.getSelectedFile();
                    if (file == null) continue;
                    if (file.exists()) {
                        serializable = new JButton(NbBundle.getMessage(GrabTableAction.class, (String)"Yes"));
                        JButton jButton = new JButton(NbBundle.getMessage(GrabTableAction.class, (String)"No"));
                        Object object = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(GrabTableAction.class, (String)"MSG_ReplaceFileOrNot", (Object)file.getName()), NbBundle.getMessage(GrabTableAction.class, (String)"GrabTableFileSaveDialogTitle"), 0, 3, new Object[]{serializable, jButton}, (Object)serializable));
                        if (!object.equals(serializable)) continue;
                        bl = false;
                        continue;
                    }
                    bl = false;
                    continue;
                }
                return;
            }
            serializable = file;
            RequestProcessor.getDefault().post(new Runnable((File)serializable){
                final /* synthetic */ File val$theFile;
                {
                    this.val$theFile = file;
                }

                public void run() {
                    try {
                        new GrabTableHelper().execute(((DatabaseConnection)tableNode.getLookup().lookup(DatabaseConnection.class)).getConnector(), specification, tableNode.getTableHandle(), this.val$theFile);
                    }
                    catch (Exception exception) {
                        DbUtilities.reportError(NbBundle.getMessage(GrabTableAction.class, (String)"ERR_UnableToGrabTable"), exception.getMessage());
                    }
                }
            });
        }
        catch (Exception exception) {
            DbUtilities.reportError(NbBundle.getMessage(GrabTableAction.class, (String)"ERR_UnableToGrabTable"), exception.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GrabTableWorker {
        private TableNode nfo;
        private RequestProcessor.Task task;
        private Dialog dialog;
        private ProgressHandle progressHandle;
        private Enumeration<MetadataElementHandle<Column>> enumeration;
        private DatabaseException exception;

        public GrabTableWorker(TableNode tableNode) {
            this.nfo = tableNode;
        }

        public Enumeration<MetadataElementHandle<Column>> execute(final MetadataModel metadataModel) throws DatabaseException {
            this.progressHandle = ProgressHandleFactory.createHandle(null);
            GrabTableProgressPanel grabTableProgressPanel = new GrabTableProgressPanel();
            grabTableProgressPanel.setProgressComponent(ProgressHandleFactory.createProgressComponent((ProgressHandle)this.progressHandle));
            String string = NbBundle.getMessage(GrabTableAction.class, (String)"GrabTableProgressDialogTitle");
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)grabTableProgressPanel, string, true, new Object[0], DialogDescriptor.NO_OPTION, 0, null, null);
            this.dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            this.dialog.setResizable(false);
            if (this.dialog instanceof JDialog) {
                ((JDialog)this.dialog).setDefaultCloseOperation(0);
            }
            this.progressHandle.start();
            this.task = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        metadataModel.runReadAction((Action)new Action<Metadata>(){

                            public void run(Metadata metadata) {
                                MetadataElementHandle<Table> metadataElementHandle = GrabTableWorker.this.nfo.getTableHandle();
                                Table table = (Table)metadataElementHandle.resolve(metadata);
                                ArrayList<MetadataElementHandle> arrayList = new ArrayList<MetadataElementHandle>();
                                for (Column column : table.getColumns()) {
                                    arrayList.add(MetadataElementHandle.create((MetadataElement)column));
                                }
                                GrabTableWorker.this.enumeration = Collections.enumeration(arrayList);
                            }
                        });
                    }
                    catch (MetadataModelException metadataModelException) {
                        Exceptions.printStackTrace((Throwable)metadataModelException);
                    }
                }
            });
            this.task.addTaskListener(new TaskListener(){

                public void taskFinished(Task task) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            GrabTableWorker.this.dialog.setVisible(false);
                        }
                    });
                }
            });
            if (!this.task.isFinished()) {
                this.dialog.setVisible(true);
            }
            this.dialog.dispose();
            this.progressHandle.finish();
            if (this.exception != null) {
                throw this.exception;
            }
            return this.enumeration;
        }
    }
}

