/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.node.ColumnNameProvider;
import org.netbeans.modules.db.explorer.node.ColumnNode;
import org.netbeans.modules.db.explorer.node.SchemaNameProvider;
import org.netbeans.modules.db.explorer.node.TableNode;
import org.netbeans.modules.db.explorer.node.ViewNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public abstract class QueryAction
extends BaseAction {
    protected boolean enable(Node[] nodeArray) {
        boolean bl = false;
        if (nodeArray.length == 1) {
            Lookup lookup = nodeArray[0].getLookup();
            bl = lookup.lookup(TableNode.class) != null || lookup.lookup(ViewNode.class) != null || lookup.lookup(ColumnNode.class) != null;
        } else {
            bl = true;
            for (Node node : nodeArray) {
                if (node.getLookup().lookup(ColumnNode.class) != null) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private boolean appendQualifiedName(StringBuilder stringBuilder, SQLIdentifiers.Quoter quoter, String string, String string2, boolean bl) {
        if (string != null && (bl || !string.equals(string2))) {
            stringBuilder.append(quoter.quoteIfNeeded(string));
            stringBuilder.append('.');
            return true;
        }
        return bl;
    }

    private String getQualifiedTableName(String string, DatabaseConnection databaseConnection, SchemaNameProvider schemaNameProvider, SQLIdentifiers.Quoter quoter) throws SQLException {
        String string2 = schemaNameProvider.getSchemaName();
        String string3 = schemaNameProvider.getCatalogName();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        bl = this.appendQualifiedName(stringBuilder, quoter, string3, databaseConnection.getConnection().getCatalog(), bl);
        bl = this.appendQualifiedName(stringBuilder, quoter, string2, null, bl);
        stringBuilder.append(quoter.quoteIfNeeded(string));
        return stringBuilder.toString();
    }

    protected String getDefaultQuery(Node[] nodeArray) {
        DatabaseConnection databaseConnection = (DatabaseConnection)nodeArray[0].getLookup().lookup(DatabaseConnection.class);
        try {
            boolean bl;
            DatabaseMetaData databaseMetaData = databaseConnection.getConnection().getMetaData();
            SQLIdentifiers.Quoter quoter = SQLIdentifiers.createQuoter(databaseMetaData);
            SchemaNameProvider schemaNameProvider = (SchemaNameProvider)nodeArray[0].getLookup().lookup(SchemaNameProvider.class);
            boolean bl2 = bl = nodeArray[0].getLookup().lookup(ColumnNode.class) != null;
            if (!bl) {
                String string = this.getQualifiedTableName(nodeArray[0].getName(), databaseConnection, schemaNameProvider, quoter);
                return "select * from " + string;
            }
            String string = ((ColumnNameProvider)nodeArray[0].getLookup().lookup(ColumnNameProvider.class)).getParentName();
            String string2 = this.getQualifiedTableName(string, databaseConnection, schemaNameProvider, quoter);
            StringBuilder stringBuilder = new StringBuilder();
            for (Node node : nodeArray) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(quoter.quoteIfNeeded(node.getName()));
            }
            return "select " + stringBuilder.toString() + " from " + string2;
        }
        catch (SQLException sQLException) {
            String string = NbBundle.getMessage(QueryAction.class, (String)"ShowDataError", (Object)sQLException.getMessage());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
            return "";
        }
    }
}

