/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.DatabaseSpecification;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnector;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.action.RefreshAction;
import org.netbeans.modules.db.explorer.dataview.DataViewWindow;
import org.netbeans.modules.db.explorer.dlg.LabeledTextFieldDialog;
import org.netbeans.modules.db.explorer.node.SchemaNameProvider;
import org.netbeans.modules.db.explorer.node.TableListNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

public class RecreateTableAction
extends BaseAction {
    private static final Logger LOGGER = Logger.getLogger(RecreateTableAction.class.getName());

    protected boolean enable(Node[] nodeArray) {
        DatabaseConnection databaseConnection;
        boolean bl = false;
        if (nodeArray.length == 1 && (databaseConnection = (DatabaseConnection)nodeArray[0].getLookup().lookup(DatabaseConnection.class)) != null) {
            bl = DatabaseConnection.isVitalConnection(databaseConnection.getConnection(), databaseConnection);
        }
        return bl;
    }

    public void performAction(Node[] nodeArray) {
        final BaseNode baseNode = (BaseNode)((Object)nodeArray[0].getLookup().lookup(BaseNode.class));
        final DatabaseConnection databaseConnection = (DatabaseConnection)nodeArray[0].getLookup().lookup(DatabaseConnection.class);
        final DatabaseConnector databaseConnector = databaseConnection.getConnector();
        Frame frame = WindowManager.getDefault().getMainWindow();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                Object object;
                try {
                    object = databaseConnector.getDatabaseSpecification();
                    FileChooserBuilder fileChooserBuilder = new FileChooserBuilder(RecreateTableAction.class);
                    fileChooserBuilder.setTitle(NbBundle.getMessage(RecreateTableAction.class, (String)"RecreateTableFileOpenDialogTitle"));
                    fileChooserBuilder.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() || file.getName().endsWith(".grab");
                        }

                        public String getDescription() {
                            return NbBundle.getMessage(RecreateTableAction.class, (String)"GrabTableFileTypeDescription");
                        }
                    });
                    File file = fileChooserBuilder.showOpenDialog();
                    if (file == null || !file.isFile()) {
                        return;
                    }
                    Object object2 = new FileInputStream(file);
                    Object object3 = new ObjectInputStream((InputStream)object2);
                    AbstractCommand abstractCommand = (AbstractCommand)((ObjectInputStream)object3).readObject();
                    ((ObjectInputStream)object3).close();
                    abstractCommand.setSpecification((DatabaseSpecification)object);
                    object2 = (SchemaNameProvider)baseNode.getLookup().lookup(SchemaNameProvider.class);
                    object3 = object2.getSchemaName();
                    String string = object2.getCatalogName();
                    if (object3 == null) {
                        object3 = string;
                    }
                    abstractCommand.setObjectOwner((String)object3);
                    String string2 = abstractCommand.getObjectName();
                    String string3 = abstractCommand.getCommand();
                    LabeledTextFieldDialog labeledTextFieldDialog = new LabeledTextFieldDialog(string3);
                    labeledTextFieldDialog.setStringValue(string2);
                    boolean bl = true;
                    while (bl) {
                        if (labeledTextFieldDialog.run()) {
                            if (!labeledTextFieldDialog.isEditable()) {
                                bl = RecreateTableAction.this.runCommand(labeledTextFieldDialog, abstractCommand);
                                continue;
                            }
                            bl = RecreateTableAction.this.runWindow(databaseConnection, labeledTextFieldDialog);
                            continue;
                        }
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    LOGGER.log(Level.INFO, null, exception);
                    DbUtilities.reportError(NbBundle.getMessage(RecreateTableAction.class, (String)"ERR_UnableToRecreateTable"), exception.getMessage());
                }
                object = baseNode;
                while (!(object instanceof TableListNode) && (object = object.getParentNode()) != null) {
                }
                if (object == null) {
                    object = baseNode;
                }
                ((RefreshAction)SystemAction.get(RefreshAction.class)).performAction(new Node[]{object});
            }
        }, 0);
    }

    private boolean runCommand(LabeledTextFieldDialog labeledTextFieldDialog, AbstractCommand abstractCommand) {
        boolean bl = true;
        String string = labeledTextFieldDialog.getStringValue();
        abstractCommand.setObjectName(string);
        try {
            abstractCommand.execute();
            bl = false;
        }
        catch (DDLException dDLException) {
            LOGGER.log(Level.INFO, null, dDLException);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)dDLException.getMessage(), 0));
            bl = true;
        }
        catch (Exception exception) {
            LOGGER.log(Level.INFO, null, exception);
            DbUtilities.reportError(NbBundle.getMessage(RecreateTableAction.class, (String)"ERR_UnableToRecreateTable"), exception.getMessage());
            bl = false;
        }
        return bl;
    }

    private boolean runWindow(DatabaseConnection databaseConnection, LabeledTextFieldDialog labeledTextFieldDialog) throws Exception {
        WindowTask windowTask = new WindowTask(databaseConnection, labeledTextFieldDialog);
        Mutex.EVENT.postReadRequest((Runnable)windowTask);
        while (!windowTask.completed) {
            Thread.sleep(10L);
        }
        if (windowTask.exc != null) {
            throw new DatabaseException(windowTask.exc);
        }
        return !windowTask.win.executeCommand();
    }

    public String getName() {
        return NbBundle.getMessage(RecreateTableAction.class, (String)"RecreateTable");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RecreateTableAction.class);
    }

    private static class WindowTask
    implements Runnable {
        public DataViewWindow win;
        public Exception exc = null;
        public boolean completed = false;
        private final DatabaseConnection connection;
        private final LabeledTextFieldDialog dlg;

        public WindowTask(DatabaseConnection databaseConnection, LabeledTextFieldDialog labeledTextFieldDialog) {
            this.connection = databaseConnection;
            this.dlg = labeledTextFieldDialog;
        }

        public void run() {
            try {
                this.win = new DataViewWindow(this.connection, this.dlg.getEditedCommand());
            }
            catch (Exception exception) {
                this.exc = exception;
            }
            this.completed = true;
        }
    }
}

