/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.prefs.Preferences;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.openide.util.NbPreferences;

public class JPDABreakpoint
extends Breakpoint {
    public static final String PROP_SUSPEND = "suspend";
    public static final String PROP_HIDDEN = "hidden";
    public static final String PROP_PRINT_TEXT = "printText";
    public static final int SUSPEND_ALL = 2;
    public static final int SUSPEND_EVENT_THREAD = 1;
    public static final int SUSPEND_NONE = 0;
    private boolean enabled = true;
    private boolean hidden = false;
    private int suspend;
    private String printText;
    private Collection<JPDABreakpointListener> breakpointListeners = new HashSet<JPDABreakpointListener>();
    private JPDADebugger session;

    JPDABreakpoint() {
        Preferences preferences = NbPreferences.forModule(((Object)((Object)this)).getClass()).node("debugging");
        int n = preferences.getInt("default.suspend.action", -1);
        if (n == -1) {
            Properties properties = Properties.getDefault().getProperties("debugger.options.JPDA");
            n = properties.getInt("BreakpointSuspend", 1);
        }
        switch (n) {
            case 0: {
                this.suspend = 0;
                break;
            }
            case 1: {
                this.suspend = 1;
                break;
            }
            case 2: {
                this.suspend = 2;
            }
        }
    }

    public int getSuspend() {
        return this.suspend;
    }

    public void setSuspend(int n) {
        if (n == this.suspend) {
            return;
        }
        int n2 = this.suspend;
        this.suspend = n;
        this.firePropertyChange(PROP_SUSPEND, n2, n);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean bl) {
        if (bl == this.hidden) {
            return;
        }
        boolean bl2 = this.hidden;
        this.hidden = bl;
        this.firePropertyChange(PROP_HIDDEN, bl2, bl);
    }

    public String getPrintText() {
        return this.printText;
    }

    public void setPrintText(String string) {
        if (string.equals(this.printText)) {
            return;
        }
        String string2 = this.printText;
        this.printText = string;
        this.firePropertyChange(PROP_PRINT_TEXT, string2, string);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        this.firePropertyChange("enabled", Boolean.TRUE, Boolean.FALSE);
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        this.firePropertyChange("enabled", Boolean.FALSE, Boolean.TRUE);
    }

    synchronized void setSession(JPDADebugger jPDADebugger) {
        this.session = jPDADebugger;
    }

    synchronized JPDADebugger getSession() {
        return this.session;
    }

    public synchronized void addJPDABreakpointListener(JPDABreakpointListener jPDABreakpointListener) {
        this.breakpointListeners.add(jPDABreakpointListener);
    }

    public synchronized void removeJPDABreakpointListener(JPDABreakpointListener jPDABreakpointListener) {
        this.breakpointListeners.remove(jPDABreakpointListener);
    }

    void fireJPDABreakpointChange(JPDABreakpointEvent jPDABreakpointEvent) {
        Iterator<JPDABreakpointListener> iterator = new HashSet<JPDABreakpointListener>(this.breakpointListeners).iterator();
        while (iterator.hasNext()) {
            iterator.next().breakpointReached(jPDABreakpointEvent);
        }
    }
}

