/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.apiregistry;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.jpda.Evaluator;
import org.netbeans.spi.debugger.jpda.SmartSteppingCallback;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.netbeans.spi.debugger.jpda.VariablesFilter;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class DebuggerProcessor
extends LayerGeneratingProcessor {
    public static final String SERVICE_NAME = "serviceName";

    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(JPDADebugger.Registration.class.getCanonicalName(), SmartSteppingCallback.Registration.class.getCanonicalName(), SourcePathProvider.Registration.class.getCanonicalName(), EditorContext.Registration.class.getCanonicalName(), VariablesFilter.Registration.class.getCanonicalName(), Evaluator.Registration.class.getCanonicalName()));
    }

    protected boolean handleProcess(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) throws LayerGenerationException {
        String string;
        Annotation annotation;
        if (roundEnvironment.processingOver()) {
            return false;
        }
        int n = 0;
        for (Element element : roundEnvironment.getElementsAnnotatedWith(JPDADebugger.Registration.class)) {
            annotation = element.getAnnotation(JPDADebugger.Registration.class);
            string = annotation.path();
            this.handleProviderRegistration(element, JPDADebugger.class, string);
            ++n;
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(SmartSteppingCallback.Registration.class)) {
            annotation = element.getAnnotation(SmartSteppingCallback.Registration.class);
            string = annotation.path();
            this.handleProviderRegistration(element, SmartSteppingCallback.class, string);
            ++n;
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(SourcePathProvider.Registration.class)) {
            annotation = element.getAnnotation(SourcePathProvider.Registration.class);
            string = annotation.path();
            this.handleProviderRegistration(element, SourcePathProvider.class, string);
            ++n;
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(EditorContext.Registration.class)) {
            annotation = element.getAnnotation(EditorContext.Registration.class);
            string = annotation.path();
            this.handleProviderRegistration(element, EditorContext.class, string);
            ++n;
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(VariablesFilter.Registration.class)) {
            annotation = element.getAnnotation(VariablesFilter.Registration.class);
            string = annotation.path();
            this.handleProviderRegistration(element, VariablesFilter.class, string);
            ++n;
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(Evaluator.Registration.class)) {
            annotation = element.getAnnotation(Evaluator.Registration.class);
            string = annotation.language();
            this.handleEvaluatorRegistration(element, string);
            ++n;
        }
        return n == set.size();
    }

    private void handleProviderRegistration(Element element, Class clazz, String string) throws IllegalArgumentException, LayerGenerationException {
        String string2 = this.instantiableClassOrMethod(element);
        if (!this.isClassOf(element, clazz)) {
            throw new IllegalArgumentException("Annotated element " + element + " is not an instance of " + clazz);
        }
        string = string != null && string.length() > 0 ? "Debugger/" + string : "Debugger";
        LayerBuilder layerBuilder = this.layer(new Element[]{element});
        String string3 = string2.replace('.', '-');
        LayerBuilder.File file = layerBuilder.file(string + "/" + string3 + ".instance");
        file.stringvalue(SERVICE_NAME, string2).stringvalue("serviceClass", clazz.getName()).stringvalue("instanceOf", clazz.getName()).methodvalue("instanceCreate", clazz.getName() + "$ContextAware", "createService").write();
    }

    private void handleEvaluatorRegistration(Element element, String string) throws IllegalArgumentException, LayerGenerationException {
        String string2 = this.instantiableClassOrMethod(element);
        if (!this.implementsInterface(element, Evaluator.class.getName())) {
            throw new IllegalArgumentException("Annotated element " + element + " is not an instance of " + Evaluator.class);
        }
        String string3 = "Debugger/netbeans-JPDASession/" + string;
        LayerBuilder layerBuilder = this.layer(new Element[]{element});
        String string4 = string2.replace('.', '-');
        LayerBuilder.File file = layerBuilder.file(string3 + "/" + string4 + ".instance");
        file.stringvalue(SERVICE_NAME, string2).stringvalue("serviceClass", Evaluator.class.getName()).stringvalue("instanceOf", Evaluator.class.getName()).methodvalue("instanceCreate", "org.netbeans.spi.debugger.ContextAwareSupport", "createService").write();
    }

    private boolean isClassOf(Element element, Class clazz) {
        switch (element.getKind()) {
            case CLASS: {
                TypeElement typeElement = (TypeElement)element;
                TypeMirror typeMirror = typeElement.getSuperclass();
                if (typeMirror.getKind().equals((Object)TypeKind.NONE)) {
                    return false;
                }
                element = ((DeclaredType)typeMirror).asElement();
                String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString();
                if (string.equals(clazz.getName())) {
                    return true;
                }
                return this.isClassOf(element, clazz);
            }
            case METHOD: {
                TypeMirror typeMirror = ((ExecutableElement)element).getReturnType();
                if (typeMirror.getKind().equals((Object)TypeKind.NONE)) {
                    return false;
                }
                element = ((DeclaredType)typeMirror).asElement();
                String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString();
                if (string.equals(clazz.getName())) {
                    return true;
                }
                return this.isClassOf(element, clazz);
            }
        }
        throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + element);
    }

    private boolean implementsInterface(Element element, String string) {
        switch (element.getKind()) {
            case CLASS: {
                TypeElement typeElement = (TypeElement)element;
                List<? extends TypeMirror> list = typeElement.getInterfaces();
                for (TypeMirror typeMirror : list) {
                    element = ((DeclaredType)typeMirror).asElement();
                    String string2 = this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString();
                    if (!string.equals(string2)) continue;
                    return true;
                }
                break;
            }
            case METHOD: {
                TypeMirror typeMirror = ((ExecutableElement)element).getReturnType();
                if (typeMirror.getKind().equals((Object)TypeKind.NONE)) {
                    return false;
                }
                TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
                List<? extends TypeMirror> list = typeElement.getInterfaces();
                for (TypeMirror typeMirror2 : list) {
                    element = ((DeclaredType)typeMirror2).asElement();
                    String string3 = this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString();
                    if (!string.equals(string3)) continue;
                    return true;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + element);
            }
        }
        return false;
    }

    private String instantiableClassOrMethod(Element element) throws IllegalArgumentException, LayerGenerationException {
        switch (element.getKind()) {
            case CLASS: {
                String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString();
                if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    throw new LayerGenerationException(string + " must not be abstract", element);
                }
                boolean bl = false;
                boolean bl2 = false;
                for (ExecutableElement executableElement : ElementFilter.constructorsIn(element.getEnclosedElements())) {
                    List<? extends VariableElement> list = executableElement.getParameters();
                    if (list.isEmpty()) {
                        bl = true;
                        break;
                    }
                    if (list.size() != 1) continue;
                    String string2 = ((Object)list.get(0).asType()).toString();
                    if (!ContextProvider.class.getName().equals(string2)) continue;
                    bl2 = true;
                    break;
                }
                if (!bl && !bl2) {
                    throw new LayerGenerationException(string + " must have a no-argument constructor or constuctor taking " + ContextProvider.class.getName() + " as a parameter.", element);
                }
                return string;
            }
            case METHOD: {
                ExecutableElement executableElement = (ExecutableElement)element;
                String string = executableElement.getSimpleName().toString();
                String string3 = this.processingEnv.getElementUtils().getBinaryName((TypeElement)executableElement.getEnclosingElement()).toString();
                if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
                    throw new LayerGenerationException(executableElement + " must be static", element);
                }
                if (executableElement.getParameters().size() > 0) {
                    throw new LayerGenerationException(executableElement + " must not have any parameters", element);
                }
                return string3 + "." + string + "()";
            }
        }
        throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + element);
    }
}

