/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony.commands;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.spi.commands.FrameworkCommand;
import org.netbeans.modules.php.spi.commands.FrameworkCommandSupport;
import org.netbeans.modules.php.symfony.SymfonyScript;
import org.netbeans.modules.php.symfony.commands.SymfonyCommand;
import org.netbeans.modules.php.symfony.commands.SymfonyCommandVO;
import org.netbeans.modules.php.symfony.commands.SymfonyCommandsXmlParser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SymfonyCommandSupport
extends FrameworkCommandSupport {
    static final Logger LOGGER = Logger.getLogger(SymfonyCommandSupport.class.getName());
    static final Pattern COMMAND_PATTERN = Pattern.compile("^\\:(\\S+)\\s+(.+)$");
    static final Pattern PREFIX_PATTERN = Pattern.compile("^(\\w+)$");

    public SymfonyCommandSupport(PhpModule phpModule) {
        super(phpModule);
    }

    public String getFrameworkName() {
        return NbBundle.getMessage(SymfonyCommandSupport.class, (String)"MSG_Symfony");
    }

    public void runCommand(FrameworkCommandSupport.CommandDescriptor commandDescriptor) {
        ExternalProcessBuilder externalProcessBuilder = this.createCommand(commandDescriptor.getFrameworkCommand().getCommand(), commandDescriptor.getCommandParams());
        ExecutionDescriptor executionDescriptor = this.getDescriptor();
        String string = this.getOutputTitle(commandDescriptor);
        ExecutionService executionService = ExecutionService.newService((Callable)externalProcessBuilder, (ExecutionDescriptor)executionDescriptor, (String)string);
        executionService.run();
    }

    public File redirectScriptOutput(String string, String ... stringArray) {
        ExternalProcessBuilder externalProcessBuilder = this.createSilentCommand(string, stringArray);
        assert (externalProcessBuilder != null);
        File file = null;
        try {
            final RedirectOutputProcessor redirectOutputProcessor = new RedirectOutputProcessor();
            ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().inputOutput(InputOutput.NULL).outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

                public InputProcessor newInputProcessor(InputProcessor inputProcessor) {
                    return redirectOutputProcessor;
                }
            });
            ExecutionService executionService = ExecutionService.newService((Callable)externalProcessBuilder, (ExecutionDescriptor)executionDescriptor, (String)("output redirect for: " + this.getOutputTitle(string, stringArray)));
            Future future = executionService.run();
            try {
                if ((Integer)future.get() == 0) {
                    file = redirectOutputProcessor.getOutputFile();
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {
                UiUtils.processExecutionException((ExecutionException)executionException, (String)SymfonyScript.getOptionsSubPath());
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, null, iOException);
        }
        return file;
    }

    protected String getOptionsPath() {
        return SymfonyScript.getOptionsPath();
    }

    protected ExternalProcessBuilder getProcessBuilder(boolean bl) {
        ExternalProcessBuilder externalProcessBuilder = super.getProcessBuilder(bl);
        if (externalProcessBuilder == null) {
            return null;
        }
        SymfonyScript symfonyScript = null;
        try {
            symfonyScript = SymfonyScript.forPhpModule(this.phpModule, bl);
        }
        catch (PhpProgram.InvalidPhpProgramException invalidPhpProgramException) {
            if (bl) {
                UiUtils.invalidScriptProvided((String)invalidPhpProgramException.getMessage(), (String)SymfonyScript.getOptionsSubPath());
            }
            return null;
        }
        assert (symfonyScript.isValid());
        externalProcessBuilder = externalProcessBuilder.workingDirectory(FileUtil.toFile((FileObject)this.phpModule.getSourceDirectory())).addArgument(symfonyScript.getProgram());
        for (String string : symfonyScript.getParameters()) {
            externalProcessBuilder = externalProcessBuilder.addArgument(string);
        }
        return externalProcessBuilder;
    }

    protected List<FrameworkCommand> getFrameworkCommandsInternal() {
        List<Object> list = this.getFrameworkCommandsInternalXml();
        if (list != null) {
            return list;
        }
        ExternalProcessBuilder externalProcessBuilder = this.createCommand("list", new String[0]);
        if (externalProcessBuilder == null) {
            return null;
        }
        final CommandsLineProcessor commandsLineProcessor = new CommandsLineProcessor();
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().inputOutput(InputOutput.NULL).outProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new FrameworkCommandSupport.ProxyInputProcessorFactory(new ExecutionDescriptor.InputProcessorFactory[]{PhpProgram.ANSI_STRIPPING_FACTORY, new ExecutionDescriptor.InputProcessorFactory(){

            public InputProcessor newInputProcessor(InputProcessor inputProcessor) {
                return InputProcessors.bridge((LineProcessor)commandsLineProcessor);
            }
        }}));
        list = Collections.emptyList();
        ExecutionService executionService = ExecutionService.newService((Callable)externalProcessBuilder, (ExecutionDescriptor)executionDescriptor, (String)"help");
        Future future = executionService.run();
        try {
            if ((Integer)future.get() == 0) {
                list = commandsLineProcessor.getCommands();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            LOGGER.log(Level.INFO, null, executionException);
        }
        return list;
    }

    private List<FrameworkCommand> getFrameworkCommandsInternalXml() {
        BufferedReader bufferedReader;
        File file = this.redirectScriptOutput("list", "--xml");
        if (file == null) {
            return null;
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, null, unsupportedEncodingException);
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            assert (false);
            return null;
        }
        ArrayList<SymfonyCommandVO> arrayList = new ArrayList<SymfonyCommandVO>();
        SymfonyCommandsXmlParser.parse(bufferedReader, arrayList);
        if (arrayList.isEmpty()) {
            LOGGER.info("Symfony commands from XML should be parsed");
            return null;
        }
        ArrayList<FrameworkCommand> arrayList2 = new ArrayList<FrameworkCommand>(arrayList.size());
        for (SymfonyCommandVO symfonyCommandVO : arrayList) {
            arrayList2.add(new SymfonyCommand(this.phpModule, symfonyCommandVO.getCommand(), symfonyCommandVO.getDescription(), symfonyCommandVO.getCommand()));
        }
        return arrayList2;
    }

    protected File getPluginsDirectory() {
        return new File(FileUtil.toFile((FileObject)this.phpModule.getSourceDirectory()), "plugins");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CommandsLineProcessor
    implements LineProcessor {
        private final List<FrameworkCommand> commands = new ArrayList<FrameworkCommand>();
        private String prefix;

        CommandsLineProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processLine(String string) {
            Matcher matcher;
            if (!StringUtils.hasText((String)string)) {
                this.prefix = null;
                return;
            }
            String string2 = string.trim();
            Matcher matcher2 = PREFIX_PATTERN.matcher(string2);
            if (matcher2.matches()) {
                this.prefix = matcher2.group(1);
            }
            if ((matcher = COMMAND_PATTERN.matcher(string2)).matches()) {
                String string3 = matcher.group(1);
                if (this.prefix != null) {
                    string3 = this.prefix + ":" + string3;
                }
                String string4 = matcher.group(2);
                List<FrameworkCommand> list = this.commands;
                synchronized (list) {
                    this.commands.add(new SymfonyCommand(SymfonyCommandSupport.this.phpModule, string3, string4, string3));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<FrameworkCommand> getCommands() {
            ArrayList<FrameworkCommand> arrayList = null;
            List<FrameworkCommand> list = this.commands;
            synchronized (list) {
                arrayList = new ArrayList<FrameworkCommand>(this.commands);
            }
            return arrayList;
        }

        public void close() {
        }

        public void reset() {
        }
    }

    private static class RedirectOutputProcessor
    implements InputProcessor {
        private final File outputFile = File.createTempFile("nb-symfony-xml-", ".xml");
        private final FileOutputStream fos = new FileOutputStream(this.outputFile);
        private final BufferedOutputStream bos = new BufferedOutputStream(this.fos);

        public RedirectOutputProcessor() throws IOException {
            this.outputFile.deleteOnExit();
        }

        public void processInput(char[] cArray) throws IOException {
            for (char c : cArray) {
                this.bos.write((byte)c);
            }
        }

        public void reset() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                this.bos.close();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, null, iOException);
            }
            finally {
                try {
                    this.fos.close();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.WARNING, null, iOException);
                }
            }
        }

        public File getOutputFile() {
            return this.outputFile;
        }
    }
}

