/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.php.api.util.Pair;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.symfony.SymfonyScript;
import org.netbeans.modules.php.symfony.ui.options.SymfonyOptions;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewProjectConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = -1785087564128594L;
    private static final String APP_FRONTEND = "frontend";
    private static final String APP_BACKEND = "backend";
    private static final Pattern APP_NAME_PATTERN = Pattern.compile("\\S+");
    private static final Pattern SECRET_PATTERN = Pattern.compile("\\bUniqueSecret\\b");
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JCheckBox backendCheckBox;
    private JLabel backendParamsLabel;
    private JTextField backendParamsTextField;
    private JCheckBox frontendCheckBox;
    private JLabel frontendParamsLabel;
    private JTextField frontendParamsTextField;
    private JLabel generateAppsLabel;
    private JLabel generateProjectLabel;
    private JLabel infoLabel;
    private JLabel optionsLabel;
    private JCheckBox otherCheckBox;
    private JTextField otherNameTextField;
    private JLabel otherParamsLabel;
    private JTextField otherParamsTextField;
    private JLabel projectParamsLabel;
    private JTextField projectParamsTextField;

    public NewProjectConfigurationPanel() {
        this.initComponents();
        this.optionsLabel.setMaximumSize(this.optionsLabel.getPreferredSize());
        this.projectParamsTextField.setText(this.getOptions().getDefaultParamsForProject());
        String string = this.getOptions().getDefaultParamsForApps();
        this.frontendParamsTextField.setText(string);
        this.backendParamsTextField.setText(string);
        this.otherParamsTextField.setText(string);
        this.initApp(this.frontendCheckBox, this.frontendParamsLabel, this.frontendParamsTextField, null);
        this.initApp(this.backendCheckBox, this.backendParamsLabel, this.backendParamsTextField, null);
        this.initApp(this.otherCheckBox, this.otherParamsLabel, this.otherParamsTextField, this.otherNameTextField);
        DefaultItemListener defaultItemListener = new DefaultItemListener();
        this.frontendCheckBox.addItemListener(defaultItemListener);
        this.backendCheckBox.addItemListener(defaultItemListener);
        this.otherCheckBox.addItemListener(defaultItemListener);
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.frontendParamsTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.backendParamsTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.otherNameTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.otherParamsTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.generateProjectLabel.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                NewProjectConfigurationPanel.this.enableOptionsLabel();
            }
        });
        this.enableOptionsLabel();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public String[] getProjectParams() {
        return Utilities.parseParameters((String)this.projectParamsTextField.getText().trim());
    }

    public List<Pair<String, String[]>> getApps() {
        LinkedList<Pair<String, String[]>> linkedList = new LinkedList<Pair<String, String[]>>();
        if (this.frontendCheckBox.isSelected()) {
            linkedList.add(Pair.of((Object)APP_FRONTEND, (Object)Utilities.parseParameters((String)this.frontendParamsTextField.getText().trim())));
        }
        if (this.backendCheckBox.isSelected()) {
            linkedList.add((Pair<String, String[]>)Pair.of((Object)APP_BACKEND, (Object)Utilities.parseParameters((String)this.backendParamsTextField.getText().trim())));
        }
        if (this.otherCheckBox.isSelected()) {
            linkedList.add((Pair<String, String[]>)Pair.of((Object)this.getOtherAppName(), (Object)Utilities.parseParameters((String)this.otherParamsTextField.getText().trim())));
        }
        return linkedList;
    }

    public String getErrorMessage() {
        if (this.otherCheckBox.isSelected()) {
            String string = this.getOtherAppName();
            if (!StringUtils.hasText((String)string)) {
                return NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"MSG_NoAppName");
            }
            if (!APP_NAME_PATTERN.matcher(string).matches()) {
                return NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"MSG_InvalidAppName", (Object)string);
            }
        }
        return null;
    }

    public String getWarningMessage() {
        String string;
        String string2 = null;
        if (this.frontendCheckBox.isSelected() && (string2 = this.validateAppParams(APP_FRONTEND, this.frontendParamsTextField)) != null) {
            return string2;
        }
        if (this.backendCheckBox.isSelected() && (string2 = this.validateAppParams(APP_BACKEND, this.backendParamsTextField)) != null) {
            return string2;
        }
        if (this.otherCheckBox.isSelected() && (string2 = this.validateAppParams(string = this.getOtherAppName(), this.otherParamsTextField)) != null) {
            return string2;
        }
        return null;
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    void visibleApp(boolean bl, JLabel jLabel, JTextField jTextField, JTextField jTextField2) {
        jLabel.setVisible(bl);
        jTextField.setVisible(bl);
        if (jTextField2 != null) {
            jTextField2.setVisible(bl);
        }
    }

    void enableOptionsLabel() {
        this.optionsLabel.setVisible(this.generateProjectLabel.isEnabled());
    }

    private String getOtherAppName() {
        return this.otherNameTextField.getText().trim();
    }

    private String validateAppParams(String string, JTextField jTextField) {
        if (SECRET_PATTERN.matcher(jTextField.getText()).find()) {
            return NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"MSG_DefaultParamUsed", (Object)"UniqueSecret", (Object)string);
        }
        return null;
    }

    private void initApp(JCheckBox jCheckBox, final JLabel jLabel, final JTextField jTextField, final JTextField jTextField2) {
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                NewProjectConfigurationPanel.this.visibleApp(itemEvent.getStateChange() == 1, jLabel, jTextField, jTextField2);
            }
        });
        this.visibleApp(jCheckBox.isSelected(), jLabel, jTextField, jTextField2);
    }

    private SymfonyOptions getOptions() {
        return SymfonyOptions.getInstance();
    }

    private void initComponents() {
        this.generateProjectLabel = new JLabel();
        this.optionsLabel = new JLabel();
        this.projectParamsLabel = new JLabel();
        this.projectParamsTextField = new JTextField();
        this.generateAppsLabel = new JLabel();
        this.frontendCheckBox = new JCheckBox();
        this.frontendParamsLabel = new JLabel();
        this.frontendParamsTextField = new JTextField();
        this.backendCheckBox = new JCheckBox();
        this.backendParamsLabel = new JLabel();
        this.backendParamsTextField = new JTextField();
        this.otherCheckBox = new JCheckBox();
        this.otherNameTextField = new JTextField();
        this.otherParamsLabel = new JLabel();
        this.otherParamsTextField = new JTextField();
        this.infoLabel = new JLabel();
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            public Component getDefaultComponent(Container container) {
                return NewProjectConfigurationPanel.this.otherParamsTextField;
            }

            public Component getFirstComponent(Container container) {
                return NewProjectConfigurationPanel.this.otherParamsTextField;
            }

            public Component getLastComponent(Container container) {
                return NewProjectConfigurationPanel.this.otherParamsTextField;
            }

            public Component getComponentAfter(Container container, Component component) {
                if (component == NewProjectConfigurationPanel.this.backendCheckBox) {
                    return NewProjectConfigurationPanel.this.backendParamsTextField;
                }
                if (component == NewProjectConfigurationPanel.this.otherCheckBox) {
                    return NewProjectConfigurationPanel.this.otherNameTextField;
                }
                if (component == NewProjectConfigurationPanel.this.projectParamsTextField) {
                    return NewProjectConfigurationPanel.this.frontendCheckBox;
                }
                if (component == NewProjectConfigurationPanel.this.backendParamsTextField) {
                    return NewProjectConfigurationPanel.this.otherCheckBox;
                }
                if (component == NewProjectConfigurationPanel.this.frontendCheckBox) {
                    return NewProjectConfigurationPanel.this.frontendParamsTextField;
                }
                if (component == NewProjectConfigurationPanel.this.frontendParamsTextField) {
                    return NewProjectConfigurationPanel.this.backendCheckBox;
                }
                if (component == NewProjectConfigurationPanel.this.otherNameTextField) {
                    return NewProjectConfigurationPanel.this.otherParamsTextField;
                }
                return NewProjectConfigurationPanel.this.otherParamsTextField;
            }

            public Component getComponentBefore(Container container, Component component) {
                if (component == NewProjectConfigurationPanel.this.backendParamsTextField) {
                    return NewProjectConfigurationPanel.this.backendCheckBox;
                }
                if (component == NewProjectConfigurationPanel.this.otherNameTextField) {
                    return NewProjectConfigurationPanel.this.otherCheckBox;
                }
                if (component == NewProjectConfigurationPanel.this.frontendCheckBox) {
                    return NewProjectConfigurationPanel.this.projectParamsTextField;
                }
                if (component == NewProjectConfigurationPanel.this.otherCheckBox) {
                    return NewProjectConfigurationPanel.this.backendParamsTextField;
                }
                if (component == NewProjectConfigurationPanel.this.frontendParamsTextField) {
                    return NewProjectConfigurationPanel.this.frontendCheckBox;
                }
                if (component == NewProjectConfigurationPanel.this.backendCheckBox) {
                    return NewProjectConfigurationPanel.this.frontendParamsTextField;
                }
                if (component == NewProjectConfigurationPanel.this.otherParamsTextField) {
                    return NewProjectConfigurationPanel.this.otherNameTextField;
                }
                return NewProjectConfigurationPanel.this.otherParamsTextField;
            }
        });
        this.generateProjectLabel.setLabelFor(this.frontendCheckBox);
        Mnemonics.setLocalizedText((JLabel)this.generateProjectLabel, (String)NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.generateProjectLabel.text"));
        this.optionsLabel.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.optionsLabel, (String)NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.optionsLabel.text"));
        this.optionsLabel.setToolTipText(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.optionsLabel.toolTipText"));
        this.optionsLabel.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                NewProjectConfigurationPanel.this.optionsLabelMouseEntered(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                NewProjectConfigurationPanel.this.optionsLabelMousePressed(mouseEvent);
            }
        });
        this.projectParamsLabel.setLabelFor(this.projectParamsTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectParamsLabel, (String)NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.projectParamsLabel.text"));
        this.generateAppsLabel.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.generateAppsLabel, (String)NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.generateAppsLabel.text"));
        this.frontendCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.frontendCheckBox, (String)NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.frontendCheckBox.text"));
        this.frontendParamsLabel.setLabelFor(this.frontendParamsTextField);
        Mnemonics.setLocalizedText((JLabel)this.frontendParamsLabel, (String)NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.frontendParamsLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.backendCheckBox, (String)NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.backendCheckBox.text"));
        this.backendParamsLabel.setLabelFor(this.backendParamsTextField);
        Mnemonics.setLocalizedText((JLabel)this.backendParamsLabel, (String)NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.backendParamsLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.otherCheckBox, (String)NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.otherCheckBox.text"));
        this.otherParamsLabel.setLabelFor(this.otherParamsTextField);
        Mnemonics.setLocalizedText((JLabel)this.otherParamsLabel, (String)NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.otherParamsLabel.text"));
        this.infoLabel.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.infoLabel.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(21, 21, 21).add((Component)this.backendParamsLabel).addPreferredGap(0).add((Component)this.backendParamsTextField, -1, 341, Short.MAX_VALUE)).add((Component)this.backendCheckBox)).add(0, 0, 0)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(21, 21, 21).add((Component)this.otherParamsLabel)).add((Component)this.otherCheckBox)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.otherParamsTextField, -1, 341, Short.MAX_VALUE).add((Component)this.otherNameTextField, -1, 341, Short.MAX_VALUE)).add(0, 0, 0)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.generateProjectLabel).addPreferredGap(0, 290, Short.MAX_VALUE).add((Component)this.optionsLabel, -2, -1, -2)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add(29, 29, 29).add((Component)this.frontendParamsLabel).addPreferredGap(0).add((Component)this.frontendParamsTextField, -1, 341, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.frontendCheckBox).addContainerGap(367, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.infoLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.projectParamsLabel).addPreferredGap(0).add((Component)this.projectParamsTextField, -1, 358, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.generateAppsLabel).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.generateProjectLabel).add((Component)this.optionsLabel, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectParamsTextField, -2, -1, -2).add((Component)this.projectParamsLabel)).addPreferredGap(1).add((Component)this.generateAppsLabel).addPreferredGap(0).add((Component)this.frontendCheckBox).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.frontendParamsLabel).add((Component)this.frontendParamsTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.backendCheckBox).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.backendParamsLabel).add((Component)this.backendParamsTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.otherCheckBox).add((Component)this.otherNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.otherParamsLabel).add((Component)this.otherParamsTextField, -2, -1, -2)).addPreferredGap(1).add((Component)this.infoLabel, -2, -1, -2)));
        this.generateProjectLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.generateProjectLabel.AccessibleContext.accessibleName"));
        this.generateProjectLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.generateProjectLabel.AccessibleContext.accessibleDescription"));
        this.optionsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.optionsLabel.AccessibleContext.accessibleName"));
        this.optionsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.optionsLabel.AccessibleContext.accessibleDescription"));
        this.projectParamsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.projectParamsLabel.AccessibleContext.accessibleName"));
        this.projectParamsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.projectParamsLabel.AccessibleContext.accessibleDescription"));
        this.projectParamsTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.projectParamsTextField.AccessibleContext.accessibleName"));
        this.projectParamsTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.projectParamsTextField.AccessibleContext.accessibleDescription"));
        this.generateAppsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.generateAppsLabel.AccessibleContext.accessibleName"));
        this.generateAppsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.generateAppsLabel.AccessibleContext.accessibleDescription"));
        this.frontendCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.frontendCheckBox.AccessibleContext.accessibleName"));
        this.frontendCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.frontendCheckBox.AccessibleContext.accessibleDescription"));
        this.frontendParamsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.frontendParamsLabel.AccessibleContext.accessibleName"));
        this.frontendParamsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.frontendParamsLabel.AccessibleContext.accessibleDescription"));
        this.frontendParamsTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.frontendParamsTextField.AccessibleContext.accessibleName"));
        this.frontendParamsTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.frontendParamsTextField.AccessibleContext.accessibleDescription"));
        this.backendCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.backendCheckBox.AccessibleContext.accessibleName"));
        this.backendCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.backendCheckBox.AccessibleContext.accessibleDescription"));
        this.backendParamsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.backendParamsLabel.AccessibleContext.accessibleName"));
        this.backendParamsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.backendParamsLabel.AccessibleContext.accessibleDescription"));
        this.backendParamsTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.backendParamsTextField.AccessibleContext.accessibleName"));
        this.backendParamsTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.backendParamsTextField.AccessibleContext.accessibleDescription"));
        this.otherCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.otherCheckBox.AccessibleContext.accessibleName"));
        this.otherCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.otherCheckBox.AccessibleContext.accessibleDescription"));
        this.otherNameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.otherNameTextField.AccessibleContext.accessibleName"));
        this.otherNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.otherNameTextField.AccessibleContext.accessibleDescription"));
        this.otherParamsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.otherParamsLabel.AccessibleContext.accessibleName"));
        this.otherParamsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.otherParamsLabel.AccessibleContext.accessibleDescription"));
        this.otherParamsTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.otherParamsTextField.AccessibleContext.accessibleName"));
        this.otherParamsTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.otherParamsTextField.AccessibleContext.accessibleDescription"));
        this.infoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.infoLabel.AccessibleContext.accessibleName"));
        this.infoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.infoLabel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.AccessibleContext.accessibleDescription"));
    }

    private void optionsLabelMouseEntered(MouseEvent mouseEvent) {
        mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void optionsLabelMousePressed(MouseEvent mouseEvent) {
        OptionsDisplayer.getDefault().open(SymfonyScript.getOptionsPath());
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.processUpdate();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.processUpdate();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.processUpdate();
        }

        private void processUpdate() {
            NewProjectConfigurationPanel.this.fireChange();
        }
    }

    private final class DefaultItemListener
    implements ItemListener {
        private DefaultItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            NewProjectConfigurationPanel.this.fireChange();
        }
    }
}

