/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.api.DiagnosticFormatter;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.BasicDiagnosticFormatter;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.List;
import java.util.Locale;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCDiagnostic
implements Diagnostic<JavaFileObject> {
    private final DiagnosticType type;
    private final DiagnosticSource source;
    private final DiagnosticPosition position;
    private final int line;
    private final int column;
    private final String key;
    protected Object[] args;
    private boolean mandatory;
    private DiagnosticFormatter<JCDiagnostic> defaultFormatter;
    @Deprecated
    private static DiagnosticFormatter<JCDiagnostic> fragmentFormatter;

    @Deprecated
    public static JCDiagnostic fragment(String key, Object ... args) {
        return new JCDiagnostic(JCDiagnostic.getFragmentFormatter(), DiagnosticType.FRAGMENT, false, null, null, "compiler." + DiagnosticType.FRAGMENT.key + "." + key, args);
    }

    @Deprecated
    public static DiagnosticFormatter<JCDiagnostic> getFragmentFormatter() {
        if (fragmentFormatter == null) {
            fragmentFormatter = new BasicDiagnosticFormatter(JavacMessages.getDefaultMessages());
        }
        return fragmentFormatter;
    }

    protected JCDiagnostic(DiagnosticFormatter<JCDiagnostic> formatter, DiagnosticType dt, boolean mandatory, DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
        int n;
        this.defaultFormatter = formatter;
        this.type = dt;
        this.mandatory = mandatory;
        this.source = source;
        this.position = pos;
        this.key = key;
        this.args = args;
        int n2 = n = pos == null ? -1 : pos.getPreferredPosition();
        if (n == -1 || source == null) {
            this.column = -1;
            this.line = -1;
        } else {
            this.line = source.getLineNumber(n);
            this.column = source.getColumnNumber(n, true);
        }
    }

    public DiagnosticType getType() {
        return this.type;
    }

    public List<JCDiagnostic> getSubdiagnostics() {
        return List.nil();
    }

    public boolean isMultiline() {
        return false;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public JavaFileObject getSource() {
        if (this.source == null) {
            return null;
        }
        return this.source.getFile();
    }

    public String getSourceName() {
        JavaFileObject s = this.getSource();
        return s == null ? null : JavacFileManager.getJavacFileName(s);
    }

    public DiagnosticSource getDiagnosticSource() {
        return this.source;
    }

    protected int getIntStartPosition() {
        return this.position == null ? -1 : this.position.getStartPosition();
    }

    protected int getIntPosition() {
        return this.position == null ? -1 : this.position.getPreferredPosition();
    }

    protected int getIntEndPosition() {
        return this.position == null ? -1 : this.position.getEndPosition(this.source.getEndPosTable());
    }

    @Override
    public long getStartPosition() {
        return this.getIntStartPosition();
    }

    @Override
    public long getPosition() {
        return this.getIntPosition();
    }

    @Override
    public long getEndPosition() {
        return this.getIntEndPosition();
    }

    public JCTree getTree() {
        return this.position == null ? null : this.position.getTree();
    }

    @Override
    public long getLineNumber() {
        return this.line;
    }

    @Override
    public long getColumnNumber() {
        return this.column;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String getPrefix() {
        return this.getPrefix(this.type);
    }

    public String getPrefix(DiagnosticType dt) {
        return this.defaultFormatter.formatKind(this, Locale.getDefault());
    }

    public String toString() {
        return this.defaultFormatter.format(this, Locale.getDefault());
    }

    @Override
    public Diagnostic.Kind getKind() {
        switch (this.type) {
            case NOTE: {
                return Diagnostic.Kind.NOTE;
            }
            case WARNING: {
                return this.mandatory ? Diagnostic.Kind.MANDATORY_WARNING : Diagnostic.Kind.WARNING;
            }
            case ERROR: {
                return Diagnostic.Kind.ERROR;
            }
        }
        return Diagnostic.Kind.OTHER;
    }

    @Override
    public String getCode() {
        return this.key;
    }

    @Override
    public String getMessage(Locale locale) {
        return this.defaultFormatter.formatMessage(this, locale);
    }

    public boolean hasFixedPositions() {
        return this.position.getTree() == null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MultilineDiagnostic
    extends JCDiagnostic {
        private final List<JCDiagnostic> subdiagnostics;

        public MultilineDiagnostic(JCDiagnostic other, List<JCDiagnostic> subdiagnostics) {
            super(other.defaultFormatter, other.getType(), other.isMandatory(), other.getDiagnosticSource(), other.position, other.getCode(), other.getArgs());
            this.subdiagnostics = subdiagnostics;
        }

        @Override
        public List<JCDiagnostic> getSubdiagnostics() {
            return this.subdiagnostics;
        }

        @Override
        public boolean isMultiline() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleDiagnosticPosition
    implements DiagnosticPosition {
        private final int pos;

        public SimpleDiagnosticPosition(int pos) {
            this.pos = pos;
        }

        @Override
        public JCTree getTree() {
            return null;
        }

        @Override
        public int getStartPosition() {
            return this.pos;
        }

        @Override
        public int getPreferredPosition() {
            return this.pos;
        }

        @Override
        public int getEndPosition(Map<JCTree, Integer> endPosTable) {
            return this.pos;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DiagnosticPosition {
        public JCTree getTree();

        public int getStartPosition();

        public int getPreferredPosition();

        public int getEndPosition(Map<JCTree, Integer> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DiagnosticType {
        FRAGMENT("misc"),
        NOTE("note"),
        WARNING("warn"),
        ERROR("err");

        final String key;

        private DiagnosticType(String key) {
            this.key = key;
        }
    }

    public static class Factory {
        protected static final Context.Key<Factory> diagnosticFactoryKey = new Context.Key();
        DiagnosticFormatter<JCDiagnostic> formatter;
        final String prefix;

        public static Factory instance(Context context) {
            Factory instance = context.get(diagnosticFactoryKey);
            if (instance == null) {
                instance = new Factory(context);
            }
            return instance;
        }

        protected Factory(Context context) {
            this(JavacMessages.instance(context), "compiler");
            context.put(diagnosticFactoryKey, this);
        }

        public Factory(JavacMessages messages, String prefix) {
            this.prefix = prefix;
            this.formatter = new BasicDiagnosticFormatter(messages);
        }

        public JCDiagnostic error(DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return new JCDiagnostic(this.formatter, DiagnosticType.ERROR, true, source, pos, this.qualify(DiagnosticType.ERROR, key), args);
        }

        public JCDiagnostic mandatoryWarning(DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return new JCDiagnostic(this.formatter, DiagnosticType.WARNING, true, source, pos, this.qualify(DiagnosticType.WARNING, key), args);
        }

        public JCDiagnostic warning(DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return new JCDiagnostic(this.formatter, DiagnosticType.WARNING, false, source, pos, this.qualify(DiagnosticType.WARNING, key), args);
        }

        public JCDiagnostic mandatoryNote(DiagnosticSource source, String key, Object ... args) {
            return new JCDiagnostic(this.formatter, DiagnosticType.NOTE, true, source, null, this.qualify(DiagnosticType.NOTE, key), args);
        }

        public JCDiagnostic note(String key, Object ... args) {
            return this.note(null, null, key, args);
        }

        public JCDiagnostic note(DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return new JCDiagnostic(this.formatter, DiagnosticType.NOTE, false, source, pos, this.qualify(DiagnosticType.NOTE, key), args);
        }

        public JCDiagnostic fragment(String key, Object ... args) {
            return new JCDiagnostic(this.formatter, DiagnosticType.FRAGMENT, false, null, null, this.qualify(DiagnosticType.FRAGMENT, key), args);
        }

        protected String qualify(DiagnosticType t, String key) {
            return this.prefix + "." + t.key + "." + key;
        }
    }
}

