/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.extras.api.support.dragging;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.netbeans.modules.dlight.extras.api.support.dragging.Draggable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DraggingSupport
extends MouseAdapter
implements MouseMotionListener {
    private final JComponent component;
    private final List<Draggable> draggables;
    private Draggable currentDraggable;

    public DraggingSupport(JComponent jComponent, List<Draggable> list) {
        this.component = jComponent;
        this.draggables = Collections.unmodifiableList(new ArrayList<Draggable>(list));
        jComponent.addMouseListener(this);
        jComponent.addMouseMotionListener(this);
        ToolTipManager.sharedInstance().registerComponent(jComponent);
    }

    private Draggable findDraggable(Point point) {
        for (Draggable draggable : this.draggables) {
            if (!draggable.containsPoint(point)) continue;
            return draggable;
        }
        return null;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Draggable draggable = this.findDraggable(mouseEvent.getPoint());
        this.component.setCursor(draggable == null ? Cursor.getDefaultCursor() : draggable.getCursor());
        this.component.setToolTipText(draggable == null ? null : draggable.getTooltip());
        mouseEvent.consume();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.currentDraggable != null) {
            this.currentDraggable.dragTo(mouseEvent.getPoint(), true);
            mouseEvent.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.currentDraggable == null) {
            this.currentDraggable = this.findDraggable(mouseEvent.getPoint());
            if (this.currentDraggable != null) {
                this.currentDraggable.startDragging(mouseEvent.getPoint());
            }
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.currentDraggable != null) {
            this.currentDraggable.dragTo(mouseEvent.getPoint(), false);
            this.currentDraggable.finishDragging();
            this.currentDraggable = null;
            mouseEvent.consume();
        }
    }
}

