/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.ui.components;

import java.awt.BorderLayout;
import java.awt.Container;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import org.netbeans.modules.dlight.core.ui.components.DLightSessionsViewPanel;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.management.api.DLightSessionListener;
import org.netbeans.modules.dlight.management.api.ExecutionContextEvent;
import org.netbeans.modules.dlight.management.api.ExecutionContextListener;
import org.netbeans.modules.dlight.management.api.SessionStateListener;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class DLightSessionsTopComponent
extends TopComponent
implements DLightSessionListener,
ExecutionContextListener,
SessionStateListener {
    private static DLightSessionsTopComponent instance;
    private transient DLightSessionsViewPanel view = null;
    static final String ICON_PATH = "org/netbeans/modules/dlight/core/ui/resources/dlight_sessions_small.png";
    private static final String PREFERRED_ID = "DLightSessionsTopComponent";

    private DLightSessionsTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(DLightSessionsTopComponent.class, (String)"CTL_DLightSessionsTopComponent"));
        this.setToolTipText(NbBundle.getMessage(DLightSessionsTopComponent.class, (String)"HINT_DLightSessionsTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized DLightSessionsTopComponent getDefault() {
        if (instance == null) {
            instance = new DLightSessionsTopComponent();
        }
        return instance;
    }

    public static synchronized DLightSessionsTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            Logger.getLogger(DLightSessionsTopComponent.class.getName()).warning("Cannot find DLightSessionsTopComponent component. It will not be located properly in the window system.");
            return DLightSessionsTopComponent.getDefault();
        }
        if (topComponent instanceof DLightSessionsTopComponent) {
            return (DLightSessionsTopComponent)topComponent;
        }
        Logger.getLogger(DLightSessionsTopComponent.class.getName()).warning("There seem to be multiple components with the 'DLightSessionsTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return DLightSessionsTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 1;
    }

    public void componentOpened() {
        if (this.view == null) {
            this.view = new DLightSessionsViewPanel();
        }
        DLightManager.getDefault().addDLightSessionListener((DLightSessionListener)this);
        this.view.startup();
        this.removeAll();
        if (DLightManager.getDefault().getSessionsList().isEmpty()) {
            this.setLayout(new BoxLayout((Container)((Object)this), 1));
            JLabel jLabel = new JLabel(DLightSessionsTopComponent.loc("DLightSessionsViewPanel.emptyContent.text"));
            jLabel.setAlignmentX(0.5f);
            this.add(jLabel);
        } else {
            this.setLayout(new BorderLayout());
            this.add(this.view, "Center");
        }
        this.revalidate();
    }

    public void componentClosed() {
        DLightManager.getDefault().removeDLightSessionListener((DLightSessionListener)this);
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void contextChanged(ExecutionContextEvent executionContextEvent) {
        this.view.updateContent(executionContextEvent.getObj());
    }

    public void activeSessionChanged(DLightSession dLightSession, DLightSession dLightSession2) {
        this.view.updateContent(null);
    }

    public void sessionAdded(DLightSession dLightSession) {
        dLightSession.addSessionStateListener((SessionStateListener)this);
        dLightSession.addExecutionContextListener((ExecutionContextListener)this);
        this.view.updateContent(null);
    }

    public void sessionRemoved(DLightSession dLightSession) {
        dLightSession.removeSessionStateListener((SessionStateListener)this);
        dLightSession.removeExecutionContextListener((ExecutionContextListener)this);
        this.view.updateContent(null);
    }

    public void sessionStateChanged(DLightSession dLightSession, DLightSession.SessionState sessionState, DLightSession.SessionState sessionState2) {
        this.view.updateContent(dLightSession);
    }

    private static String loc(String string) {
        return NbBundle.getMessage(DLightSessionsViewPanel.class, (String)string);
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return DLightSessionsTopComponent.getDefault();
        }
    }
}

