/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.ui.components;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.dlight.core.ui.components.ContentValidator;
import org.netbeans.modules.dlight.core.ui.components.DLightTargetSelectionDialog;
import org.netbeans.modules.dlight.core.ui.components.JComboBox2;
import org.netbeans.modules.dlight.core.ui.components.SelectExecutableTargetDialog;
import org.openide.util.NbBundle;

public class SelectJavaApplicationDialog
extends DLightTargetSelectionDialog {
    private DefaultComboBoxModel cmbJvmPathModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel cmbJvmOptionsModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel cmbJarFileModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel cmbMainClassModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel cmbArgumentsModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel cmbClassPathModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel cmbWorkingDirModel = new DefaultComboBoxModel();
    private JButton btnBrowseJDK = new JButton(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectTarget.Browse.Title"));
    private JButton btnBrowseJARFile = new JButton(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectTarget.Browse.Title"));
    private JButton btnBrowseWorkingDir = new JButton(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectTarget.Browse.Title"));
    private ContentValidator fileValidator = new ContentValidator(){

        public String validate(String string) {
            return new File(string).exists() ? null : NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectTarget.SpecifyPathToJVM");
        }
    };
    private ContentValidator workingDirValidator = new ContentValidator(){

        public String validate(String string) {
            File file = new File(string);
            if (!file.exists() || !file.isDirectory()) {
                return NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectTarget.SpecifyExistentWorkingDir");
            }
            return file.canWrite() ? null : NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectTarget.WorkingDirIsNotWritable");
        }
    };

    public SelectJavaApplicationDialog() {
        super(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectJavaApplicationDialog.Title"));
        this.setDefaults();
        this.init();
    }

    public String getProgramArguments() {
        String string;
        String string2;
        String string3;
        String string4;
        StringBuffer stringBuffer = new StringBuffer();
        String string5 = this.getJvmOptions();
        if (string5 != null) {
            stringBuffer.append(" ").append(string5);
        }
        if ((string4 = this.getJarFile()) != null) {
            stringBuffer.append(" -jar " + string4);
        }
        if ((string3 = this.getMainClass()) != null) {
            stringBuffer.append(" ").append(string3);
        }
        if ((string2 = this.getArguments()) != null) {
            stringBuffer.append(" ").append(string2);
        }
        if ((string = this.getClassPath()) != null) {
            stringBuffer.append(" -cp ").append(string);
        }
        return stringBuffer.toString();
    }

    public String getWorkingDirectory() {
        return (String)this.cmbWorkingDirModel.getSelectedItem();
    }

    private String getArguments() {
        return (String)this.cmbArgumentsModel.getSelectedItem();
    }

    private String getClassPath() {
        return (String)this.cmbClassPathModel.getSelectedItem();
    }

    private String getJvmOptions() {
        return (String)this.cmbJvmOptionsModel.getSelectedItem();
    }

    private String getJvmPath() {
        return (String)this.cmbJvmPathModel.getSelectedItem();
    }

    private String getJarFile() {
        return (String)this.cmbJarFileModel.getSelectedItem();
    }

    private String getMainClass() {
        return (String)this.cmbMainClassModel.getSelectedItem();
    }

    private void setDefaults() {
        String[] stringArray = new String[]{System.getProperty("java.home"), "/usr/java", System.getProperty("JAVA_HOME"), System.getProperty("JDK_HOME")};
        for (int i = stringArray.length - 1; i >= 0; --i) {
            File file = new File(stringArray[i], "bin/java");
            if (!file.exists()) continue;
            SelectJavaApplicationDialog.updateModel(this.cmbJvmPathModel, file.getPath());
            File file2 = new File(stringArray[i], "demo/jfc/Java2D/Java2Demo.jar");
            if (!file2.exists()) continue;
            SelectJavaApplicationDialog.updateModel(this.cmbJarFileModel, file2.getPath());
        }
        SelectJavaApplicationDialog.updateModel(this.cmbJarFileModel, "");
        SelectJavaApplicationDialog.updateModel(this.cmbJvmOptionsModel, "-Xmx128m  -XX:+ExtendedDTraceProbes");
        SelectJavaApplicationDialog.updateModel(this.cmbWorkingDirModel, "/tmp");
    }

    void initComponents() {
        this.setLayout(new GridLayout(8, 1));
        this.btnBrowseJDK.addActionListener(this);
        this.btnBrowseJARFile.addActionListener(this);
        this.btnBrowseWorkingDir.addActionListener(this);
        this.btnBrowseJDK.setToolTipText(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectJavaApplicationDialog.BrowseJDK.Tooltip"));
        this.btnBrowseJARFile.setToolTipText(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectJavaApplicationDialog.BrowseJar.Tooltip"));
        this.btnBrowseWorkingDir.setToolTipText(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectTarget.BrowseWorkingDir.Tooltip"));
        this.addPanel(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectJavaApplicationDialog.JVMPath"), new JComboBox2(this.cmbJvmPathModel, 10, true, this.fileValidator), this.btnBrowseJDK);
        this.addPanel(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectJavaApplicationDialog.JVMOptions"), new JComboBox2(this.cmbJvmOptionsModel, 10, true, null), null);
        this.addPanel(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectJavaApplicationDialog.JARFile"), new JComboBox2(this.cmbJarFileModel, 10, true, this.fileValidator), this.btnBrowseJARFile);
        this.addPanel(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectJavaApplicationDialog.MainClass"), new JComboBox2(this.cmbMainClassModel, 10, true, null), null);
        this.addPanel(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectTarget.Arguments"), new JComboBox2(this.cmbArgumentsModel, 10, true, null), null);
        this.addPanel(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectJavaApplicationDialog.ClassPath"), new JComboBox2(this.cmbClassPathModel, 10, true, null), null);
        this.addPanel(NbBundle.getMessage(SelectJavaApplicationDialog.class, (String)"SelectTarget.WorkingDir"), new JComboBox2(this.cmbWorkingDirModel, 10, true, this.workingDirValidator), this.btnBrowseWorkingDir);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (!(object instanceof JButton)) {
            return;
        }
        if (object == this.btnBrowseJDK) {
            String string = this.selectFile((String)this.cmbJvmPathModel.getSelectedItem());
            SelectJavaApplicationDialog.updateModel(this.cmbJvmPathModel, string);
        } else if (object == this.btnBrowseJARFile) {
            String string = this.selectFile((String)this.cmbJarFileModel.getSelectedItem(), new FileFilter(){

                public boolean accept(File file) {
                    if (file != null) {
                        String string;
                        if (file.isDirectory()) {
                            return true;
                        }
                        String string2 = file.getName();
                        int n = string2.lastIndexOf(46);
                        if (n > 0 && n < string2.length() - 1 && (string = string2.substring(n + 1).toLowerCase(Locale.ENGLISH)).equals("jar")) {
                            return true;
                        }
                    }
                    return false;
                }

                public String getDescription() {
                    return "JAR file (*.jar)";
                }
            });
            SelectJavaApplicationDialog.updateModel(this.cmbJarFileModel, string);
        } else if (object == this.btnBrowseWorkingDir) {
            String string = this.selectDirectory((String)this.cmbWorkingDirModel.getSelectedItem(), this.workingDirValidator);
            SelectJavaApplicationDialog.updateModel(this.cmbWorkingDirModel, string);
        }
    }

    public void approveSelection() {
        String string = this.getJarFile();
        String string2 = this.getMainClass();
        if ((string == null || string.equals("")) && (string2 == null || string2.equals(""))) {
            JOptionPane.showMessageDialog(this, NbBundle.getMessage(SelectExecutableTargetDialog.class, (String)"SelectJavaApplicationDialog.SpecifyJarOrMainClass"));
        } else {
            super.approveSelection();
        }
    }

    public String getProgramName() {
        return this.getJvmPath();
    }
}

