/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.phpmodule;

import java.io.File;
import java.util.regex.Pattern;
import org.netbeans.modules.php.api.phpmodule.PhpOptions;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.api.util.StringUtils;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class PhpInterpreter
extends PhpProgram {
    public static final Pattern[] LINE_PATTERNS = new Pattern[]{Pattern.compile(".+\\s+in\\s+(.+)\\s+on\\s+line\\s+(\\d+)"), Pattern.compile(".+\\(\\)\\s+(.+):(\\d+)")};

    PhpInterpreter(String string) {
        super(string);
    }

    public static PhpInterpreter getDefault() throws PhpProgram.InvalidPhpProgramException {
        String string = ((PhpOptions)Lookup.getDefault().lookup(PhpOptions.class)).getPhpInterpreter();
        String string2 = PhpInterpreter.validate(string);
        if (string2 != null) {
            throw new PhpProgram.InvalidPhpProgramException(string2);
        }
        return new PhpInterpreter(string);
    }

    public static PhpInterpreter getCustom(String string) throws PhpProgram.InvalidPhpProgramException {
        String string2 = PhpInterpreter.validate(string);
        if (string2 != null) {
            throw new PhpProgram.InvalidPhpProgramException(string2);
        }
        return new PhpInterpreter(string);
    }

    public String validate() {
        if (!StringUtils.hasText(this.getProgram())) {
            return NbBundle.getMessage(PhpInterpreter.class, (String)"MSG_NoPhpInterpreter");
        }
        File file = new File(this.getProgram());
        if (!file.isAbsolute()) {
            return NbBundle.getMessage(PhpInterpreter.class, (String)"MSG_PhpInterpreterNotAbsolutePath");
        }
        if (!file.isFile()) {
            return NbBundle.getMessage(PhpInterpreter.class, (String)"MSG_PhpInterpreterNotFile");
        }
        if (!file.canRead()) {
            return NbBundle.getMessage(PhpInterpreter.class, (String)"MSG_PhpInterpreterCannotRead");
        }
        return null;
    }

    public static String validate(String string) {
        return new PhpInterpreter(string).validate();
    }
}

