/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.util;

import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.php.api.ui.SearchPanel;
import org.netbeans.modules.php.api.util.StringUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class UiUtils {
    public static final String OPTIONS_PATH = "org-netbeans-modules-php-project-ui-options-PHPOptionsCategory";

    private UiUtils() {
    }

    public static void invalidScriptProvided(String string) {
        UiUtils.invalidScriptProvided(string, null);
    }

    public static void invalidScriptProvided(String string, String string2) {
        Parameters.notNull((CharSequence)"message", (Object)string);
        UiUtils.informAndOpenOptions((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0), string2);
    }

    public static void processExecutionException(ExecutionException executionException) {
        UiUtils.processExecutionException(executionException, null);
    }

    public static void processExecutionException(ExecutionException executionException, final String string) {
        Parameters.notNull((CharSequence)"exc", (Object)executionException);
        final Throwable throwable = executionException.getCause();
        assert (throwable != null);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UiUtils.informAndOpenOptions((NotifyDescriptor)new NotifyDescriptor.Exception(throwable, (Object)NbBundle.getMessage(UiUtils.class, (String)"MSG_ExceptionDuringRunScript", (Object)throwable.getLocalizedMessage())), string);
            }
        });
    }

    public static void showGeneralOptions() {
        UiUtils.showOptions(null);
    }

    public static void showOptions(String string) {
        String string2 = OPTIONS_PATH;
        if (StringUtils.hasText(string)) {
            string2 = string2 + "/" + string;
        }
        OptionsDisplayer.getDefault().open(string2);
    }

    private static void informAndOpenOptions(NotifyDescriptor notifyDescriptor, String string) {
        assert (notifyDescriptor != null);
        DialogDisplayer.getDefault().notify(notifyDescriptor);
        UiUtils.showOptions(string);
    }

    public static final class SearchWindow {
        private SearchWindow() {
        }

        public static String search(SearchWindowSupport searchWindowSupport) {
            Parameters.notNull((CharSequence)"support", (Object)searchWindowSupport);
            SearchPanel searchPanel = SearchPanel.create(searchWindowSupport);
            if (searchPanel.open()) {
                return searchPanel.getSelectedItem();
            }
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface SearchWindowSupport {
            public List<String> detect();

            public String getWindowTitle();

            public String getListTitle();

            public String getPleaseWaitPart();

            public String getNoItemsFound();
        }
    }
}

