/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.breakpoints;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpoint;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyExceptionBreakpoint;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyLineBreakpoint;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public final class BreakpointModel
implements NodeModel {
    public static final String BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpoint";
    public static final String DISABLED_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledNonLineBreakpoint";
    public static final String LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint";
    public static final String DISABLED_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledBreakpoint";
    private List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object instanceof RubyLineBreakpoint) {
            RubyLineBreakpoint rubyLineBreakpoint = (RubyLineBreakpoint)((Object)object);
            return rubyLineBreakpoint.getFileObject().getNameExt() + ':' + rubyLineBreakpoint.getLineNumber();
        }
        if (object instanceof RubyExceptionBreakpoint) {
            RubyExceptionBreakpoint rubyExceptionBreakpoint = (RubyExceptionBreakpoint)((Object)object);
            return rubyExceptionBreakpoint.getException();
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object instanceof RubyLineBreakpoint) {
            if (!((RubyBreakpoint)((Object)object)).isEnabled()) {
                return DISABLED_LINE_BREAKPOINT;
            }
            return LINE_BREAKPOINT;
        }
        if (object instanceof RubyExceptionBreakpoint) {
            if (!((RubyBreakpoint)((Object)object)).isEnabled()) {
                return DISABLED_BREAKPOINT;
            }
            return BREAKPOINT;
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object instanceof RubyLineBreakpoint) {
            RubyLineBreakpoint rubyLineBreakpoint = (RubyLineBreakpoint)((Object)object);
            return rubyLineBreakpoint.getLine().getDisplayName();
        }
        if (object instanceof RubyExceptionBreakpoint) {
            RubyExceptionBreakpoint rubyExceptionBreakpoint = (RubyExceptionBreakpoint)((Object)object);
            return rubyExceptionBreakpoint.getException();
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public void fireChanges() {
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }
}

