/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2;

import java.awt.Component;
import java.awt.Frame;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.editor.lib2.EditorImplementation;

public final class ComponentUtils {
    private static final Logger LOG = Logger.getLogger(Logger.class.getName());

    public static boolean isGuardedException(BadLocationException badLocationException) {
        return badLocationException.getClass().getName().equals("org.netbeans.editor.GuardedException");
    }

    public static void returnFocus() {
        JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
        if (jTextComponent != null) {
            ComponentUtils.requestFocus(jTextComponent);
        }
    }

    public static void requestFocus(JTextComponent jTextComponent) {
        if (jTextComponent != null && !EditorImplementation.getDefault().activateComponent(jTextComponent)) {
            Frame frame = ComponentUtils.getParentFrame(jTextComponent);
            if (frame != null) {
                frame.requestFocus();
            }
            jTextComponent.requestFocus();
        }
    }

    public static void setStatusText(JTextComponent jTextComponent, String string) {
        try {
            Object object = ComponentUtils.getEditorUI(jTextComponent);
            Method method = object.getClass().getMethod("getStatusBar", new Class[0]);
            Object object2 = method.invoke(object, new Object[0]);
            Method method2 = object2.getClass().getMethod("setText", String.class, String.class);
            method2.invoke(object2, "main", string);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, exception.getMessage(), exception);
        }
    }

    public static void setStatusText(JTextComponent jTextComponent, String string, int n) {
        try {
            Object object = ComponentUtils.getEditorUI(jTextComponent);
            Method method = object.getClass().getMethod("getStatusBar", new Class[0]);
            Object object2 = method.invoke(object, new Object[0]);
            Method method2 = object2.getClass().getMethod("setText", String.class, Integer.TYPE);
            method2.invoke(object2, string, n);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, exception.getMessage(), exception);
        }
    }

    public static void setStatusBoldText(JTextComponent jTextComponent, String string) {
        try {
            Object object = ComponentUtils.getEditorUI(jTextComponent);
            Method method = object.getClass().getMethod("getStatusBar", new Class[0]);
            Object object2 = method.invoke(object, new Object[0]);
            Method method2 = object2.getClass().getMethod("setBoldText", String.class, String.class);
            method2.invoke(object2, "main", string);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, exception.getMessage(), exception);
        }
    }

    public static String getStatusText(JTextComponent jTextComponent) {
        try {
            Object object = ComponentUtils.getEditorUI(jTextComponent);
            Method method = object.getClass().getMethod("getStatusBar", new Class[0]);
            Object object2 = method.invoke(object, new Object[0]);
            Method method2 = object2.getClass().getMethod("getText", String.class);
            return (String)method2.invoke(object2, "main");
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, exception.getMessage(), exception);
            return "";
        }
    }

    public static void clearStatusText(JTextComponent jTextComponent) {
        ComponentUtils.setStatusText(jTextComponent, "");
    }

    private static Object getEditorUI(JTextComponent jTextComponent) throws Exception {
        TextUI textUI = jTextComponent.getUI();
        Method method = textUI.getClass().getMethod("getEditorUI", new Class[0]);
        return method.invoke((Object)textUI, new Object[0]);
    }

    private static Frame getParentFrame(Component component) {
        do {
            if (!((component = component.getParent()) instanceof Frame)) continue;
            return (Frame)component;
        } while (component != null);
        return null;
    }

    private ComponentUtils() {
    }
}

