/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.embedder;

import java.lang.ref.WeakReference;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TimedWeakReference<T>
extends WeakReference<T>
implements Runnable {
    public static int TIMEOUT = 15000;
    private static final RequestProcessor RP = new RequestProcessor("TimedWeakReference");
    private RequestProcessor.Task task;
    private T o;
    private long touched;

    public TimedWeakReference(T t) {
        super(t, Utilities.activeReferenceQueue());
        this.o = t;
        this.task = RP.create((Runnable)this);
        this.task.schedule(TIMEOUT);
    }

    @Override
    public synchronized void run() {
        if (this.o != null) {
            long l = System.currentTimeMillis() - this.touched;
            if (l > (long)(TIMEOUT / 2)) {
                this.o = null;
                this.touched = 0L;
            } else {
                this.task.schedule(TIMEOUT - (int)l);
            }
        }
    }

    @Override
    public synchronized T get() {
        if (this.o == null) {
            this.o = super.get();
        }
        if (this.o != null) {
            if (this.touched == 0L) {
                this.task.schedule(TIMEOUT);
            }
            this.touched = System.currentTimeMillis();
            return this.o;
        }
        return null;
    }
}

