/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GestureSubmitter {
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.profiler");

    GestureSubmitter() {
    }

    static void logConfig(ProfilingSettings profilingSettings) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        GestureSubmitter.fillParamsForProfiling(profilingSettings, arrayList);
        GestureSubmitter.logUsage("CONFIG", arrayList);
    }

    static void logProfileApp(Project project, SessionSettings sessionSettings) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        GestureSubmitter.fillProjectParam(project, arrayList);
        GestureSubmitter.fillParamsForSession(sessionSettings, arrayList);
        GestureSubmitter.logUsage("PROFILE_APP", arrayList);
    }

    static void logProfileClass(Project project, SessionSettings sessionSettings) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        GestureSubmitter.fillProjectParam(project, arrayList);
        GestureSubmitter.fillParamsForSession(sessionSettings, arrayList);
        GestureSubmitter.logUsage("PROFILE_CLASS", arrayList);
    }

    static void logAttach(Project project, AttachSettings attachSettings) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        GestureSubmitter.fillProjectParam(project, arrayList);
        GestureSubmitter.fillParamsForAttach(attachSettings, arrayList);
        GestureSubmitter.logUsage("ATTACH", arrayList);
    }

    private static void fillProjectParam(Project project, List<Object> list) {
        String string = "";
        if (project != null) {
            string = project.getClass().getName();
        }
        list.add(0, string);
    }

    private static void fillParamsForAttach(AttachSettings attachSettings, List<Object> list) {
        list.add("OS_" + attachSettings.getHostOS());
        list.add(attachSettings.isDirect() ? "ATTACH_DIRECT" : "ATTACH_DYNAMIC");
        list.add(attachSettings.isRemote() ? "ATTACH_REMOTE" : "ATTACH_LOCAL");
    }

    private static void fillParamsForProfiling(ProfilingSettings profilingSettings, List<Object> list) {
        switch (profilingSettings.getProfilingType()) {
            case 8: {
                list.add("TYPE_CPU_ENTIRE");
                break;
            }
            case 16: {
                list.add("TYPE_CPU_PART");
                break;
            }
            case 32: {
                list.add("TYPE_CPU_STOPWATCH");
                break;
            }
            case 2: {
                list.add("TYPE_MEM_ALLOC");
                break;
            }
            case 4: {
                list.add("TYPE_MEM_LIVENESS");
                break;
            }
            case 1: {
                list.add("TYPE_MONITOR");
            }
        }
        switch (profilingSettings.getInstrScheme()) {
            case 2: {
                list.add("INSTR_EAGER");
                break;
            }
            case 1: {
                list.add("INSTR_LAZY");
                break;
            }
            case 3: {
                list.add("INSTR_TOTAL");
            }
        }
        list.add(profilingSettings.getProfileUnderlyingFramework() ? "FRAMEWORK_YES" : "FRAMEWORK_NO");
        list.add(profilingSettings.getExcludeWaitTime() ? "WAIT_EXCLUDE" : "WAIT_INCLUDE");
        list.add(profilingSettings.getInstrumentMethodInvoke() ? "REFL_INVOKE_YES" : "REFL_INVOKE_NO");
        list.add(profilingSettings.getInstrumentSpawnedThreads() ? "SPAWNED_THREADS_YES" : "SPAWNED_THREADS_NO");
        list.add(profilingSettings.getThreadCPUTimerOn() ? "THREAD_CPU_YES" : "THREAD_CPU_NO");
        list.add(profilingSettings.useProfilingPoints() ? "PPOINTS_YES" : "PPOINTS_NO");
    }

    private static void fillParamsForSession(SessionSettings sessionSettings, List<Object> list) {
        list.add("JAVA_" + sessionSettings.getJavaVersionString());
    }

    private static void logUsage(String string, List<Object> list) {
        LogRecord logRecord = new LogRecord(Level.INFO, "USG_PROFILER_" + string);
        logRecord.setResourceBundle(NbBundle.getBundle(NetBeansProfiler.class));
        logRecord.setResourceBundleName(NetBeansProfiler.class.getPackage().getName() + ".Bundle");
        logRecord.setLoggerName(USG_LOGGER.getName());
        logRecord.setParameters(list.toArray(new Object[list.size()]));
        USG_LOGGER.log(logRecord);
    }
}

