/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import javax.swing.AbstractButton;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.netbeans.lib.profiler.heap.HeapProgress;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.heapwalk.AbstractController;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;
import org.netbeans.modules.profiler.heapwalk.model.InstanceNode;
import org.netbeans.modules.profiler.heapwalk.ui.ReferencesBrowserControllerUI;
import org.netbeans.modules.profiler.ui.NBSwingWorker;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.openide.DialogDescriptor;
import org.openide.util.NbBundle;

public class ReferencesBrowserController
extends AbstractController {
    private static final String NO_INSTANCE_SELECTED_STRING = NbBundle.getMessage(ReferencesBrowserController.class, (String)"ReferencesBrowserController_NoInstanceSelectedString");
    private static final String NONE_STRING = NbBundle.getMessage(ReferencesBrowserController.class, (String)"ReferencesBrowserController_NoneString");
    private static final String PROGRESS_DIALOG_CAPTION = NbBundle.getMessage(ReferencesBrowserController.class, (String)"ReferencesBrowserController_ProgressDialogCaption");
    private static final String PROGRESS_MSG = NbBundle.getMessage(ReferencesBrowserController.class, (String)"ReferencesBrowserController_ProgressMsg");
    private static final String SELF_GCROOT_MSG = NbBundle.getMessage(ReferencesBrowserController.class, (String)"ReferencesBrowserController_SelfGcRootMsg");
    private static final String NO_GCROOT_MSG = NbBundle.getMessage(ReferencesBrowserController.class, (String)"ReferencesBrowserController_NoGcRootMsg");
    public static final AbstractHeapWalkerNode EMPTY_INSTANCE_NODE = new AbstractHeapWalkerNode(null){

        protected String computeName() {
            return NO_INSTANCE_SELECTED_STRING;
        }

        protected String computeType() {
            return NONE_STRING;
        }

        protected String computeValue() {
            return NONE_STRING;
        }

        protected String computeSize() {
            return "";
        }

        protected String computeRetainedSize() {
            return "";
        }

        protected Icon computeIcon() {
            return null;
        }

        public boolean isLeaf() {
            return true;
        }
    };
    private static final int DEFAULT_WIDTH = 350;
    private static final int DEFAULT_HEIGHT = 100;
    private Handler referencesControllerHandler;
    private Instance instance;

    public ReferencesBrowserController(Handler handler) {
        this.referencesControllerHandler = handler;
    }

    public Handler getReferencesControllerHandler() {
        return this.referencesControllerHandler;
    }

    public HeapWalkerNode getFilteredSortedReferences(String string, int n, boolean bl) {
        if (this.instance == null) {
            return EMPTY_INSTANCE_NODE;
        }
        return this.getSortedReferences(this.getFilteredReferences(this.getReferences(this.instance), string), n, bl);
    }

    public void setInstance(Instance instance) {
        this.instance = instance;
        this.update();
    }

    public void createNavigationHistoryPoint() {
        this.referencesControllerHandler.getHeapFragmentWalker().createNavigationHistoryPoint();
    }

    public void navigateToClass(JavaClass javaClass) {
        this.referencesControllerHandler.showClass(javaClass);
    }

    public void navigateToInstance(Instance instance) {
        this.referencesControllerHandler.showInstance(instance);
    }

    public void navigateToNearestGCRoot(final InstanceNode instanceNode) {
        new NBSwingWorker(true){
            private Dialog progress;
            private HeapWalkerNode gcRootNode;
            private BoundedRangeModel progressModel;
            private boolean done;
            {
                super(bl);
                this.progress = null;
                this.gcRootNode = null;
                this.progressModel = null;
                this.done = false;
            }

            public void doInBackground() {
                this.progressModel = HeapProgress.getProgress();
                this.gcRootNode = BrowserUtils.computeChildrenToNearestGCRoot(instanceNode);
            }

            public void nonResponding() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (!done) {
                            progress = ReferencesBrowserController.this.createProgressPanel(PROGRESS_MSG, progressModel);
                            progress.setVisible(true);
                        }
                    }
                });
            }

            public void done() {
                this.done = false;
                if (this.progress != null) {
                    this.progress.setVisible(false);
                    this.progress.dispose();
                }
                if (this.gcRootNode != null) {
                    if (instanceNode == this.gcRootNode) {
                        NetBeansProfiler.getDefaultNB().displayInfo(SELF_GCROOT_MSG);
                    } else {
                        ReferencesBrowserControllerUI referencesBrowserControllerUI = (ReferencesBrowserControllerUI)((Object)ReferencesBrowserController.this.getPanel());
                        referencesBrowserControllerUI.selectNode(this.gcRootNode);
                    }
                } else {
                    NetBeansProfiler.getDefaultNB().displayInfo(NO_GCROOT_MSG);
                }
            }
        }.execute();
    }

    public void showInstance(Instance instance) {
        if (this.instance != instance) {
            this.setInstance(instance);
        }
    }

    public void update() {
        ((ReferencesBrowserControllerUI)((Object)this.getPanel())).update();
    }

    protected AbstractButton createControllerPresenter() {
        return ((ReferencesBrowserControllerUI)((Object)this.getPanel())).getPresenter();
    }

    protected JPanel createControllerUI() {
        return new ReferencesBrowserControllerUI(this);
    }

    Dialog createProgressPanel(String string, BoundedRangeModel boundedRangeModel) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(10, 10));
        jPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        jPanel.add((Component)new JLabel(string), "North");
        Dimension dimension = jPanel.getPreferredSize();
        dimension.setSize(Math.max(dimension.getWidth(), 350.0), Math.max(dimension.getHeight(), 100.0));
        jPanel.setPreferredSize(dimension);
        JProgressBar jProgressBar = new JProgressBar();
        if (boundedRangeModel == null) {
            jProgressBar.setIndeterminate(true);
        } else {
            jProgressBar.setStringPainted(true);
            jProgressBar.setModel(boundedRangeModel);
        }
        jPanel.add((Component)jProgressBar, "South");
        Dialog dialog = ProfilerDialogs.createDialog(new DialogDescriptor((Object)jPanel, PROGRESS_DIALOG_CAPTION, true, new Object[0], DialogDescriptor.CANCEL_OPTION, 1, null, null));
        return dialog;
    }

    private HeapWalkerNode getReferences(Instance instance) {
        return HeapWalkerNodeFactory.createRootInstanceNode(instance, "this", new Runnable(){

            public void run() {
                ((ReferencesBrowserControllerUI)((Object)ReferencesBrowserController.this.getPanel())).refreshView();
            }
        }, 2, this.referencesControllerHandler.getHeapFragmentWalker().getHeapFragment());
    }

    private HeapWalkerNode getFilteredReferences(HeapWalkerNode heapWalkerNode, String string) {
        return heapWalkerNode;
    }

    private HeapWalkerNode getSortedReferences(HeapWalkerNode heapWalkerNode, int n, boolean bl) {
        return heapWalkerNode;
    }

    public static interface Handler {
        public HeapFragmentWalker getHeapFragmentWalker();

        public void showClass(JavaClass var1);

        public void showInstance(Instance var1);
    }
}

