/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stats.drilldown;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.results.cpu.cct.CCTResultsFilter;
import org.netbeans.modules.profiler.categories.Categorization;
import org.netbeans.modules.profiler.ui.stats.drilldown.DrillDown;

public class DrillDownFactory
implements CCTResultsFilter.EvaluatorProvider {
    private final Set<WeakEvaluator> drillDownEvaluators = Collections.synchronizedSet(new HashSet());

    public DrillDown createDrillDown(Project project, ProfilerClient profilerClient) {
        if (project == null) {
            return null;
        }
        if (Categorization.isAvailable(project)) {
            DrillDown drillDown = new DrillDown(new Categorization(project), profilerClient);
            this.drillDownEvaluators.add(new WeakEvaluator(drillDown));
            return drillDown;
        }
        return null;
    }

    public Set getEvaluators() {
        return this.drillDownEvaluators;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WeakEvaluator
    extends WeakReference<CCTResultsFilter.Evaluator>
    implements CCTResultsFilter.Evaluator {
        public WeakEvaluator(CCTResultsFilter.Evaluator evaluator, ReferenceQueue<? super CCTResultsFilter.Evaluator> referenceQueue) {
            super(evaluator, referenceQueue);
        }

        public WeakEvaluator(CCTResultsFilter.Evaluator evaluator) {
            super(evaluator);
        }

        public boolean evaluate(Mark mark) {
            CCTResultsFilter.Evaluator evaluator = (CCTResultsFilter.Evaluator)this.get();
            return evaluator != null ? evaluator.evaluate(mark) : true;
        }
    }
}

