/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.utils;

import java.lang.ref.WeakReference;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ProjectsRootNode
extends AbstractNode {
    private static final String OPEN_PROJECTS_NODE_NAME = NbBundle.getMessage(ProjectsRootNode.class, (String)"ProjectsRootNode_OpenProjectsNodeName");
    private static final String ICON_BASE = "org/netbeans/modules/profiler/utils/projectsRootNode.gif";
    private static final Action[] NO_ACTIONS = new Action[0];
    private static Action[] ACTIONS;
    private static final RequestProcessor rp;
    private final Node.Handle handle;

    public ProjectsRootNode() {
        super((Children)new ProjectChildren());
        this.setIconBaseWithExtension(ICON_BASE);
        this.handle = new Handle();
    }

    public Action[] getActions(boolean bl) {
        if (bl) {
            return NO_ACTIONS;
        }
        if (ACTIONS == null) {
            ACTIONS = new Action[0];
        }
        return ACTIONS;
    }

    public String getDisplayName() {
        return OPEN_PROJECTS_NODE_NAME;
    }

    public Node.Handle getHandle() {
        return this.handle;
    }

    public String getName() {
        return "OpenProjects";
    }

    public boolean canRename() {
        return false;
    }

    Node findNode(Object object) {
        ProjectChildren projectChildren = (ProjectChildren)this.getChildren();
        Node[] nodeArray = projectChildren.getNodes(true);
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node;
            LogicalViewProvider logicalViewProvider;
            Project project = (Project)nodeArray[i].getLookup().lookup(Project.class);
            if (project == null || (logicalViewProvider = (LogicalViewProvider)project.getLookup().lookup(LogicalViewProvider.class)) == null || (node = logicalViewProvider.findPath(nodeArray[i], object)) == null) continue;
            return node;
        }
        return null;
    }

    static {
        rp = new RequestProcessor();
    }

    private static final class ProjectChildren
    extends Children.Keys
    implements ChangeListener {
        public static final Comparator PROJECT_BY_DISPLAYNAME = new ProjectByDisplayNameComparator();
        private final Map sources2projects = new WeakHashMap();

        public Collection getKeys() {
            List<Project> list = Arrays.asList(OpenProjects.getDefault().getOpenProjects());
            Collections.sort(list, PROJECT_BY_DISPLAYNAME);
            return list;
        }

        public void addNotify() {
            this.setKeys(this.getKeys());
        }

        public void removeNotify() {
            for (Sources sources : this.sources2projects.keySet()) {
                sources.removeChangeListener((ChangeListener)this);
            }
            this.sources2projects.clear();
            this.setKeys(Collections.EMPTY_LIST);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            WeakReference weakReference = (WeakReference)this.sources2projects.get(changeEvent.getSource());
            if (weakReference == null) {
                return;
            }
            final Project project = (Project)weakReference.get();
            if (project == null) {
                return;
            }
            rp.post(new Runnable(){

                public void run() {
                    ProjectChildren.this.refreshKey(project);
                }
            });
        }

        protected Node[] createNodes(Object object) {
            Node[] nodeArray;
            Project project = (Project)object;
            LogicalViewProvider logicalViewProvider = (LogicalViewProvider)project.getLookup().lookup(LogicalViewProvider.class);
            if (logicalViewProvider == null) {
                ErrorManager.getDefault().log(16, "Warning - project " + ProjectUtils.getInformation((Project)project).getName() + " failed to supply LogicalViewProvider in it's lookup");
                Sources sources = ProjectUtils.getSources((Project)project);
                sources.removeChangeListener((ChangeListener)this);
                sources.addChangeListener((ChangeListener)this);
                nodeArray = new Node[]{Node.EMPTY};
            } else {
                nodeArray = new Node[]{logicalViewProvider.createLogicalView()};
                if (nodeArray[0].getLookup().lookup(Project.class) != project) {
                    ErrorManager.getDefault().log(16, "Warning - project " + ProjectUtils.getInformation((Project)project).getName() + " failed to supply itself in the lookup of the root node of its own logical view");
                }
            }
            return nodeArray;
        }

        public static final class ProjectByDisplayNameComparator
        implements Comparator {
            private static final Comparator COLLATOR = Collator.getInstance();

            public final int compare(Object object, Object object2) {
                if (!(object instanceof Project)) {
                    return 1;
                }
                if (!(object2 instanceof Project)) {
                    return -1;
                }
                Project project = (Project)object;
                Project project2 = (Project)object2;
                return COLLATOR.compare(ProjectUtils.getInformation((Project)project).getDisplayName(), ProjectUtils.getInformation((Project)project2).getDisplayName());
            }
        }
    }

    private static final class Handle
    implements Node.Handle {
        private static final long serialVersionUID = 78374332058L;

        public Node getNode() {
            return new ProjectsRootNode();
        }
    }
}

