/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelutil;

import java.awt.Color;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.cnd.modelutil.FontColorProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class CsmFontColorManager {
    private final Map<String, FontColorProviderImpl> providers = new HashMap<String, FontColorProviderImpl>();
    private final boolean isUnitTestsMode = CndUtils.isUnitTestMode();

    public void addListener(String string, FontColorChangeListener fontColorChangeListener) {
        this.getCreateProvider(string).addListener(fontColorChangeListener);
    }

    Color getColor(FontColorProvider.Entity entity) {
        AttributeSet attributeSet = this.getCreateProvider("text/x-c++").getColor(entity);
        return this.isUnitTestsMode ? Color.red : (Color)attributeSet.getAttribute(StyleConstants.ColorConstants.Foreground);
    }

    public AttributeSet getColorAttributes(String string, FontColorProvider.Entity entity) {
        AttributeSet attributeSet = this.getCreateProvider(string).getColor(entity);
        return this.isUnitTestsMode ? null : attributeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FontColorProviderImpl getCreateProvider(String string) {
        Map<String, FontColorProviderImpl> map = this.providers;
        synchronized (map) {
            FontColorProviderImpl fontColorProviderImpl = this.providers.get(string);
            if (fontColorProviderImpl == null) {
                fontColorProviderImpl = new FontColorProviderImpl(string);
                this.providers.put(string, fontColorProviderImpl);
            }
            return fontColorProviderImpl;
        }
    }

    public static CsmFontColorManager instance() {
        return Instantiator.instance;
    }

    private CsmFontColorManager() {
    }

    private static class FontColorProviderImpl
    implements FontColorProvider,
    LookupListener {
        private final String mimeType;
        private final List<WeakReference<FontColorChangeListener>> listeners = new ArrayList<WeakReference<FontColorChangeListener>>();
        FontColorSettings fcs;

        public FontColorProviderImpl(String string) {
            this.mimeType = string;
            Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)string));
            Lookup.Result result = lookup.lookup(new Lookup.Template(FontColorSettings.class));
            this.fcs = (FontColorSettings)result.allInstances().iterator().next();
            result.addLookupListener((LookupListener)this);
        }

        public void addListener(FontColorChangeListener fontColorChangeListener) {
            this.listeners.add(new WeakReference<FontColorChangeListener>(fontColorChangeListener));
            fontColorChangeListener.stateChanged(this);
        }

        public AttributeSet getColor(FontColorProvider.Entity entity) {
            return this.fcs.getTokenFontColors(entity.getResourceName());
        }

        public void resultChanged(LookupEvent lookupEvent) {
            Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)this.mimeType));
            this.fcs = (FontColorSettings)lookup.lookup(FontColorSettings.class);
            ListIterator<WeakReference<FontColorChangeListener>> listIterator = this.listeners.listIterator();
            while (listIterator.hasNext()) {
                WeakReference<FontColorChangeListener> weakReference = listIterator.next();
                FontColorChangeListener fontColorChangeListener = (FontColorChangeListener)weakReference.get();
                if (fontColorChangeListener != null) {
                    fontColorChangeListener.stateChanged(this);
                    continue;
                }
                listIterator.remove();
            }
        }
    }

    public static interface FontColorChangeListener
    extends EventListener {
        public void stateChanged(FontColorProvider var1);
    }

    private static class Instantiator {
        public static final CsmFontColorManager instance = new CsmFontColorManager();

        private Instantiator() {
        }
    }
}

