/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelutil;

import java.io.PrintStream;

public class Tracer {
    private int step = 4;
    private PrintStream pstream;
    private StringBuilder indentBuffer = new StringBuilder();

    public Tracer() {
        this(System.err);
    }

    public Tracer(PrintStream printStream) {
        this.pstream = printStream;
    }

    public Tracer(PrintStream printStream, int n) {
        this.pstream = printStream;
        this.step = n;
    }

    public void indent() {
        this.setupIndentBuffer(this.indentBuffer.length() + this.step);
    }

    public void unindent() {
        this.setupIndentBuffer(this.indentBuffer.length() - this.step);
    }

    private void setupIndentBuffer(int n) {
        if (n <= 0) {
            this.indentBuffer.setLength(0);
        } else {
            this.indentBuffer.setLength(n);
            for (int i = 0; i < n; ++i) {
                this.indentBuffer.setCharAt(i, ' ');
            }
        }
    }

    public void trace(Object object) {
        System.err.println(this.indentBuffer.toString() + object);
    }
}

