/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.j2ee.sun.share.PrincipalNameMapping;
import org.openide.util.NbBundle;

public class SecurityMasterListModel
extends AbstractTableModel {
    public static final String DUPLICATE_PRINCIPAL = NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.Bundle").getString("ERR_PrincipalExists");
    public static final String DUPLICATE_GROUP = NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.Bundle").getString("ERR_GroupExists");
    public static final String[] PRINCIPAL_COLUMN_NAMES = new String[]{NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.Bundle").getString("LBL_PrincipalColumnName"), NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.Bundle").getString("LBL_PrincipalClassColumnName")};
    public static final String[] GROUP_COLUMN_NAMES = new String[]{NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.Bundle").getString("LBL_GroupColumnName")};
    private Vector masterList;
    private final String[] columnNames;
    private final int columnCount;
    private String duplicateErrorPattern;
    private static SecurityMasterListModel principalMaster = new SecurityMasterListModel(DUPLICATE_PRINCIPAL, PRINCIPAL_COLUMN_NAMES, 2);
    private static SecurityMasterListModel groupMaster = new SecurityMasterListModel(DUPLICATE_GROUP);

    private SecurityMasterListModel(String string) {
        this(string, GROUP_COLUMN_NAMES, 1);
    }

    private SecurityMasterListModel(String string, String[] stringArray, int n) {
        assert (stringArray.length == n);
        this.duplicateErrorPattern = string;
        this.columnNames = stringArray;
        this.columnCount = n;
        this.masterList = new Vector();
    }

    private SecurityMasterListModel(String string, String[] stringArray, Object[] objectArray, int n) {
        assert (stringArray.length == n);
        this.duplicateErrorPattern = string;
        this.columnNames = stringArray;
        this.columnCount = n;
        this.masterList = new Vector<Object>(Arrays.asList(objectArray));
    }

    public void addElement(Object object) {
        int n = this.masterList.size();
        this.masterList.add(object);
        this.fireTableRowsInserted(n, n);
    }

    public boolean removeElement(Object object) {
        int n = this.masterList.indexOf(object);
        boolean bl = this.masterList.removeElement(object);
        if (n >= 0) {
            this.fireTableRowsDeleted(n, n);
        }
        return bl;
    }

    public void removeElementAt(int n) {
        if (n >= 0 || n < this.masterList.size()) {
            this.masterList.removeElementAt(n);
            this.fireTableRowsDeleted(n, n);
        }
    }

    public void removeElements(int[] nArray) {
        if (nArray.length > 0) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (nArray[i] < 0 && nArray[i] >= this.masterList.size()) continue;
                this.masterList.removeElementAt(nArray[i]);
            }
            this.fireTableRowsUpdated(nArray[0], nArray[nArray.length - 1]);
        }
    }

    public boolean replaceElement(Object object, Object object2) {
        boolean bl = false;
        int n = this.masterList.indexOf(object);
        if (n != -1) {
            this.masterList.setElementAt(object2, n);
            this.fireTableRowsUpdated(n, n);
        }
        return bl;
    }

    public Object getValueAt(int n, int n2) {
        String string = null;
        if (n >= 0 && n < this.masterList.size() && n2 >= 0 && n2 < this.columnCount) {
            Object e = this.masterList.get(n);
            if (e instanceof String) {
                assert (this.columnCount == 1) : "Invalid object for getValueAt() in SecurityMasterListModel.";
                string = (String)e;
            } else if (e instanceof PrincipalNameMapping) {
                PrincipalNameMapping principalNameMapping = (PrincipalNameMapping)this.masterList.get(n);
                string = n2 == 0 ? principalNameMapping.getPrincipalName() : principalNameMapping.getClassName();
            } else assert (false) : "Invalid object for getValueAt() in SecurityMasterListModel.";
        }
        return string;
    }

    public int getRowCount() {
        return this.masterList.size();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public String getColumnName(int n) {
        if (n >= 0 && n < this.columnCount) {
            return this.columnNames[n];
        }
        return null;
    }

    public boolean contains(Object object) {
        return this.masterList.contains(object);
    }

    public String getDuplicateErrorMessage(String string) {
        Object[] objectArray = new Object[]{string};
        return MessageFormat.format(this.duplicateErrorPattern, objectArray);
    }

    public Object getRow(int n) {
        Object var2_2 = null;
        if (n >= 0 && n < this.masterList.size()) {
            var2_2 = this.masterList.get(n);
        }
        return var2_2;
    }

    public static SecurityMasterListModel getPrincipalMasterModel() {
        return principalMaster;
    }

    public static SecurityMasterListModel getGroupMasterModel() {
        return groupMaster;
    }
}

