/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.netbeans.modules.j2ee.sun.share.PrincipalNameMapping;
import org.netbeans.modules.j2ee.sun.share.SecurityMasterListModel;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.PrincipalTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.FixedHeightJTable;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.InputDialog;

public class SecurityAddPrincipalPanel
extends JPanel
implements ListSelectionListener {
    private static final ResourceBundle customizerBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.Bundle");
    private final PrincipalTableModel principalModel;
    private Dimension initialPreferredSize;
    private String principalName;
    private String className;
    private JTable existingPrincipalsTable;
    private SecurityMasterListModel existingPrincipalsModel;
    private TableModel versionedModel;
    private final boolean as90FeaturesVisible;
    private ButtonGroup buttonGroup;
    private JLabel jLblClassName;
    private JLabel jLblPrincipalEntryDesc;
    private JLabel jLblPrincipalName;
    private JLabel jLblPrincipalTableDesc;
    private JTextField jTxtClassName;
    private JTextField jTxtPrincipalName;

    private SecurityAddPrincipalPanel(PrincipalTableModel principalTableModel, ASDDVersion aSDDVersion) {
        this.principalModel = principalTableModel;
        this.className = null;
        this.principalName = null;
        this.as90FeaturesVisible = ASDDVersion.SUN_APPSERVER_9_0.compareTo((Object)aSDDVersion) <= 0;
        this.initComponents();
        this.initUserComponents();
        this.initFields();
    }

    protected String getPrincipalName() {
        return this.principalName;
    }

    protected String getClassName() {
        return this.className;
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.jLblPrincipalEntryDesc = new JLabel();
        this.jLblPrincipalName = new JLabel();
        this.jTxtPrincipalName = new JTextField();
        this.jLblClassName = new JLabel();
        this.jTxtClassName = new JTextField();
        this.jLblPrincipalTableDesc = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jLblPrincipalEntryDesc.setText(customizerBundle.getString("LBL_PrincipalEntryDesc90"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 11, 0, 5);
        this.add((Component)this.jLblPrincipalEntryDesc, gridBagConstraints);
        this.jLblPrincipalName.setLabelFor(this.jTxtPrincipalName);
        this.jLblPrincipalName.setText(customizerBundle.getString("LBL_PrincipalName_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 11, 0, 0);
        this.add((Component)this.jLblPrincipalName, gridBagConstraints);
        this.jTxtPrincipalName.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                SecurityAddPrincipalPanel.this.jTxtPrincipalNameKeyReleased(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 11);
        this.add((Component)this.jTxtPrincipalName, gridBagConstraints);
        this.jTxtPrincipalName.getAccessibleContext().setAccessibleName(customizerBundle.getString("ACSN_PrincipalName"));
        this.jTxtPrincipalName.getAccessibleContext().setAccessibleDescription(customizerBundle.getString("ACSD_PrincipalName"));
        this.jLblClassName.setLabelFor(this.jTxtClassName);
        this.jLblClassName.setText(customizerBundle.getString("LBL_ClassName_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 11, 0, 0);
        this.add((Component)this.jLblClassName, gridBagConstraints);
        this.jTxtClassName.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                SecurityAddPrincipalPanel.this.jTxtClassNameKeyReleased(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 11);
        this.add((Component)this.jTxtClassName, gridBagConstraints);
        this.jTxtClassName.getAccessibleContext().setAccessibleName(customizerBundle.getString("ACSN_ClassName"));
        this.jTxtClassName.getAccessibleContext().setAccessibleDescription(customizerBundle.getString("ACSD_ClassName"));
        this.jLblPrincipalTableDesc.setText(customizerBundle.getString("LBL_PrincipalTableDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 11, 0, 5);
        this.add((Component)this.jLblPrincipalTableDesc, gridBagConstraints);
    }

    private void jTxtClassNameKeyReleased(KeyEvent keyEvent) {
        this.className = this.jTxtClassName.getText();
        this.firePropertyChange("UserDataChanged", null, null);
    }

    private void jTxtPrincipalNameKeyReleased(KeyEvent keyEvent) {
        this.principalName = this.jTxtPrincipalName.getText();
        this.firePropertyChange("UserDataChanged", null, null);
    }

    private void initUserComponents() {
        if (!this.as90FeaturesVisible) {
            this.jLblPrincipalEntryDesc.setText(customizerBundle.getString("LBL_PrincipalEntryDesc81"));
            this.jLblClassName.setVisible(false);
            this.jTxtClassName.setVisible(false);
        }
        this.initialPreferredSize = this.getPreferredSize();
        this.existingPrincipalsTable = new FixedHeightJTable();
        this.existingPrincipalsTable.setSelectionMode(0);
        this.existingPrincipalsTable.getSelectionModel().addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.existingPrincipalsTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 11, 11, 11);
        this.add((Component)jScrollPane, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(customizerBundle.getString("ACSN_AddPrincipalName"));
        this.getAccessibleContext().setAccessibleDescription(customizerBundle.getString("ACSD_AddPrincipalName"));
    }

    private void initFields() {
        this.existingPrincipalsModel = SecurityMasterListModel.getPrincipalMasterModel();
        this.versionedModel = new VersionedPrincipalTableModel(this.existingPrincipalsModel, this.as90FeaturesVisible);
        this.existingPrincipalsTable.setModel(this.versionedModel);
        this.updateTextFields();
        this.setPreferredSize(new Dimension(this.initialPreferredSize.width, this.initialPreferredSize.height + 148));
    }

    private void updateTextFields() {
        this.jTxtPrincipalName.setText(this.principalName);
        this.jTxtClassName.setText(this.className);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object;
        int n;
        ListSelectionModel listSelectionModel = this.existingPrincipalsTable.getSelectionModel();
        if (!listSelectionModel.getValueIsAdjusting() && (n = this.existingPrincipalsTable.getSelectedRow()) != -1 && (object = this.existingPrincipalsModel.getRow(n)) instanceof PrincipalNameMapping) {
            PrincipalNameMapping principalNameMapping = (PrincipalNameMapping)object;
            this.principalName = principalNameMapping.getPrincipalName();
            this.className = principalNameMapping.getClassName();
            this.updateTextFields();
            this.firePropertyChange("UserDataChanged", null, null);
        }
    }

    Collection getErrors() {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.getPrincipalName();
        if (!Utils.notEmpty(string2)) {
            arrayList.add(customizerBundle.getString("ERR_BlankPrincipalName"));
        }
        if (string2 != null && this.principalModel.contains(new PrincipalNameMapping(string2))) {
            arrayList.add(MessageFormat.format(customizerBundle.getString("ERR_PrincipalExists"), string2));
        }
        if (this.as90FeaturesVisible && Utils.notEmpty(string = this.getClassName()) && !Utils.isJavaClass(string)) {
            arrayList.add(customizerBundle.getString("ERR_InvalidJavaClassName"));
        }
        return arrayList;
    }

    private void commit() {
        String string = this.getPrincipalName();
        String string2 = this.getClassName();
        this.principalModel.addElement(new PrincipalNameMapping(string, string2));
        PrincipalNameMapping principalNameMapping = new PrincipalNameMapping(string, string2);
        if (!this.existingPrincipalsModel.contains(principalNameMapping)) {
            this.existingPrincipalsModel.addElement(principalNameMapping);
        }
    }

    static void addPrincipalName(JPanel jPanel, PrincipalTableModel principalTableModel, ASDDVersion aSDDVersion) {
        SecurityAddPrincipalPanel securityAddPrincipalPanel = new SecurityAddPrincipalPanel(principalTableModel, aSDDVersion);
        securityAddPrincipalPanel.displayDialog(jPanel, customizerBundle.getString("TITLE_AddPrincipal"), "AS_CFG_SecurityRoleNewPrincipal");
    }

    private void displayDialog(JPanel jPanel, String string, String string2) {
        BetterInputDialog betterInputDialog = new BetterInputDialog(jPanel, string, string2, this);
        do {
            int n = betterInputDialog.display();
            if (n == 0) break;
            if (n != 1) continue;
            Collection collection = this.getErrors();
            if (betterInputDialog.hasErrors()) {
                betterInputDialog.showErrors();
                continue;
            }
            this.commit();
        } while (betterInputDialog.hasErrors());
    }

    private static class VersionedPrincipalTableModel
    implements TableModel {
        private final SecurityMasterListModel realModel;
        private final boolean showClassColumn;

        public VersionedPrincipalTableModel(SecurityMasterListModel securityMasterListModel, boolean bl) {
            this.realModel = securityMasterListModel;
            this.showClassColumn = bl;
        }

        public void removeTableModelListener(TableModelListener tableModelListener) {
            this.realModel.removeTableModelListener(tableModelListener);
        }

        public void addTableModelListener(TableModelListener tableModelListener) {
            this.realModel.addTableModelListener(tableModelListener);
        }

        public void setValueAt(Object object, int n, int n2) {
            this.realModel.setValueAt(object, n, n2);
        }

        public String getColumnName(int n) {
            return this.realModel.getColumnName(n);
        }

        public Class getColumnClass(int n) {
            return this.realModel.getColumnClass(n);
        }

        public boolean isCellEditable(int n, int n2) {
            return this.realModel.isCellEditable(n, n2);
        }

        public Object getValueAt(int n, int n2) {
            return this.realModel.getValueAt(n, n2);
        }

        public int getRowCount() {
            return this.realModel.getRowCount();
        }

        public int getColumnCount() {
            return this.showClassColumn ? this.realModel.getColumnCount() : 1;
        }
    }

    private static class BetterInputDialog
    extends InputDialog {
        private final SecurityAddPrincipalPanel dialogPanel;
        private final String panelHelpId;

        public BetterInputDialog(JPanel jPanel, String string, String string2, SecurityAddPrincipalPanel securityAddPrincipalPanel) {
            super(jPanel, string);
            this.dialogPanel = securityAddPrincipalPanel;
            this.panelHelpId = string2;
            this.dialogPanel.setPreferredSize(new Dimension(jPanel.getWidth() * 3 / 4, this.dialogPanel.getPreferredSize().height));
            this.getAccessibleContext().setAccessibleName(this.dialogPanel.getAccessibleContext().getAccessibleName());
            this.getAccessibleContext().setAccessibleDescription(this.dialogPanel.getAccessibleContext().getAccessibleDescription());
            this.getContentPane().add((Component)securityAddPrincipalPanel, "Center");
            this.addListeners();
            this.pack();
            this.setLocationInside(jPanel);
            this.handleErrorDisplay();
        }

        private void addListeners() {
            this.dialogPanel.addPropertyChangeListener("UserDataChanged", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    BetterInputDialog.this.handleErrorDisplay();
                }
            });
        }

        private void handleErrorDisplay() {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.dialogPanel.getErrors());
            this.setErrors(arrayList);
        }

        protected String getHelpId() {
            return this.panelHelpId;
        }
    }
}

