/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupportFactory;
import org.netbeans.modules.web.project.classpath.JspSourcePathImplementation;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.WeakListeners;

public final class ClassPathProviderImpl
implements ClassPathProvider,
PropertyChangeListener {
    private final AntProjectHelper helper;
    private final File projectDirectory;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testSourceRoots;
    private final Map<ClassPathCache, ClassPath> cache = new HashMap<ClassPathCache, ClassPath>();
    private final Map<String, FileObject> dirCache = new HashMap<String, FileObject>();
    private org.netbeans.modules.java.api.common.classpath.ClassPathProviderImpl javaClassPathProvider;

    public ClassPathProviderImpl(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, SourceRoots sourceRoots, SourceRoots sourceRoots2) {
        this.helper = antProjectHelper;
        this.projectDirectory = FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory());
        assert (this.projectDirectory != null);
        this.evaluator = propertyEvaluator;
        this.sourceRoots = sourceRoots;
        this.testSourceRoots = sourceRoots2;
        propertyEvaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
        this.javaClassPathProvider = new org.netbeans.modules.java.api.common.classpath.ClassPathProviderImpl(antProjectHelper, propertyEvaluator, sourceRoots, sourceRoots2, "build.classes.dir", "dist.war", "build.test.classes.dir", new String[]{"javac.classpath", "j2ee.platform.classpath"}, new String[]{"javac.test.classpath", "j2ee.platform.classpath"}, new String[]{"debug.classpath", "j2ee.platform.classpath"}, new String[]{"run.test.classpath", "j2ee.platform.classpath"});
    }

    private FileObject getDir(final String string) {
        return (FileObject)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<FileObject>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FileObject run() {
                ClassPathProviderImpl classPathProviderImpl = ClassPathProviderImpl.this;
                synchronized (classPathProviderImpl) {
                    String string2;
                    FileObject fileObject = (FileObject)ClassPathProviderImpl.this.dirCache.get(string);
                    if (!(fileObject != null && fileObject.isValid() || (string2 = ClassPathProviderImpl.this.evaluator.getProperty(string)) == null)) {
                        fileObject = ClassPathProviderImpl.this.helper.resolveFileObject(string2);
                        ClassPathProviderImpl.this.dirCache.put(string, fileObject);
                    }
                    return fileObject;
                }
            }
        });
    }

    private FileObject[] getPrimarySrcPath() {
        return this.sourceRoots.getRoots();
    }

    private FileObject getBuildClassesDir() {
        return this.getDir("build.classes.dir");
    }

    private FileObject getDocumentBaseDir() {
        return this.getDir("web.docbase.dir");
    }

    private FileType getType(FileObject fileObject) {
        FileObject[] fileObjectArray = this.getPrimarySrcPath();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject fileObject2 = fileObjectArray[i];
            if (!fileObject2.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return FileType.SOURCE;
        }
        FileObject fileObject3 = this.getDocumentBaseDir();
        if (fileObject3 != null && (fileObject3.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject))) {
            return FileType.WEB_SOURCE;
        }
        fileObject3 = this.getBuildClassesDir();
        if (fileObject3 != null && (fileObject3.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject))) {
            return FileType.CLASS;
        }
        return FileType.UNKNOWN;
    }

    private synchronized ClassPath getCompileTimeClasspath(FileType fileType) {
        if (fileType == FileType.WEB_SOURCE) {
            if (this.sourceRoots.getRoots().length > 0) {
                return this.javaClassPathProvider.findClassPath(this.sourceRoots.getRoots()[0], "classpath/compile");
            }
            ClassPath classPath = this.cache.get((Object)ClassPathCache.WEB_COMPILATION);
            if (classPath == null) {
                classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])new String[]{"javac.classpath", "j2ee.platform.classpath"}));
                this.cache.put(ClassPathCache.WEB_COMPILATION, classPath);
            }
            return classPath;
        }
        return null;
    }

    private synchronized ClassPath getPackagedClasspath(FileType fileType) {
        if (fileType == FileType.SOURCE || fileType == FileType.CLASS || fileType == FileType.WEB_SOURCE) {
            ClassPath classPath = this.cache.get((Object)ClassPathCache.PACKAGED);
            if (classPath == null) {
                classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])new String[]{"javac.classpath"}));
                this.cache.put(ClassPathCache.PACKAGED, classPath);
            }
            return classPath;
        }
        return null;
    }

    private synchronized ClassPath getRunTimeClasspath(FileType fileType) {
        if (fileType == FileType.WEB_SOURCE) {
            if (this.sourceRoots.getRoots().length > 0) {
                return this.javaClassPathProvider.findClassPath(this.sourceRoots.getRoots()[0], "classpath/execute");
            }
            ClassPath classPath = this.cache.get((Object)ClassPathCache.WEB_RUNTIME);
            if (classPath == null) {
                classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])new String[]{"debug.classpath", "j2ee.platform.classpath"}));
                this.cache.put(ClassPathCache.WEB_RUNTIME, classPath);
            }
            return classPath;
        }
        return null;
    }

    private synchronized ClassPath getSourcepath(FileType fileType) {
        if (fileType == FileType.WEB_SOURCE) {
            ClassPath classPath = this.cache.get((Object)ClassPathCache.WEB_SOURCE);
            if (classPath == null) {
                classPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{ClassPathFactory.createClassPath((ClassPathImplementation)new JspSourcePathImplementation(this.helper, this.evaluator)), ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathSupportFactory.createSourcePathImplementation((SourceRoots)this.sourceRoots, (AntProjectHelper)this.helper, (PropertyEvaluator)this.evaluator))});
                this.cache.put(ClassPathCache.WEB_SOURCE, classPath);
            }
            return classPath;
        }
        return null;
    }

    public ClassPath findClassPath(FileObject fileObject, String string) {
        ClassPath classPath = this.javaClassPathProvider.findClassPath(fileObject, string);
        if (classPath != null) {
            return classPath;
        }
        FileType fileType = this.getType(fileObject);
        if (string.equals("classpath/compile")) {
            classPath = this.getCompileTimeClasspath(fileType);
        } else if (string.equals("classpath/execute")) {
            classPath = this.getRunTimeClasspath(fileType);
        } else if (string.equals("classpath/source")) {
            classPath = this.getSourcepath(fileType);
        } else if (string.equals("classpath/packaged")) {
            classPath = this.getPackagedClasspath(fileType);
        } else if (string.equals("js/library")) {
            classPath = this.getSourcepath(FileType.WEB_SOURCE);
        }
        return classPath;
    }

    public ClassPath[] getProjectClassPaths(String string) {
        if ("classpath/source".equals(string)) {
            ClassPath[] classPathArray = this.javaClassPathProvider.getProjectClassPaths(string);
            ClassPath[] classPathArray2 = new ClassPath[classPathArray.length + 1];
            System.arraycopy(classPathArray, 0, classPathArray2, 0, classPathArray.length);
            classPathArray2[classPathArray2.length - 1] = this.getSourcepath(FileType.WEB_SOURCE);
            return classPathArray2;
        }
        return this.javaClassPathProvider.getProjectClassPaths(string);
    }

    public ClassPath getProjectSourcesClassPath(String string) {
        return this.javaClassPathProvider.getProjectSourcesClassPath(string);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.dirCache.remove(propertyChangeEvent.getPropertyName());
    }

    public String[] getPropertyName(SourceGroup sourceGroup, String string) {
        return this.javaClassPathProvider.getPropertyName(sourceGroup, string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ClassPathCache {
        WEB_SOURCE,
        PACKAGED,
        WEB_COMPILATION,
        WEB_RUNTIME;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FileType {
        SOURCE,
        CLASS,
        WEB_SOURCE,
        UNKNOWN;

    }
}

