/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.microedition.m2g.SVGImage;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.netbeans.modules.mobility.svgcore.composer.ComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.InputControlManager;
import org.netbeans.modules.mobility.svgcore.composer.PerseusController;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.view.svg.SVGImagePanel;
import org.netbeans.modules.mobility.svgcore.view.svg.SVGStatusBar;
import org.openide.awt.MouseUtils;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.w3c.dom.svg.SVGLocatableElement;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;

public final class ScreenManager {
    private static final Color VIEWBOXBORDER_COLOR = Color.DARK_GRAY;
    private static final float MINIMUM_ZOOM = 0.01f;
    private static final float MAXIMUM_ZOOM = 100.0f;
    private final SceneManager m_sceneMgr;
    private final SVGStatusBar m_statusBar;
    private JScrollPane m_topComponent;
    private JComponent m_animatorView;
    private SVGImagePanel m_imageContainer;
    private Cursor m_cursor;
    private boolean m_showAllArea;
    private boolean m_landscapeMode;
    private boolean m_showTooltip;
    private boolean m_highlightObject;
    private short m_changeTicker = 0;

    ScreenManager(SceneManager sceneManager) {
        this.m_sceneMgr = sceneManager;
        this.m_statusBar = new SVGStatusBar();
        this.m_showAllArea = false;
        this.m_landscapeMode = false;
        this.m_showTooltip = true;
        this.m_highlightObject = true;
    }

    void initialize() {
        PerseusController perseusController = this.m_sceneMgr.getPerseusController();
        this.m_animatorView = perseusController.getAnimatorGUI();
        this.m_imageContainer = new SVGImagePanel(this.m_animatorView){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void paintPanel(Graphics graphics, int n, int n2) {
                PerseusController perseusController = ScreenManager.this.m_sceneMgr.getPerseusController();
                if (perseusController != null) {
                    Object object;
                    SVGLocatableElement sVGLocatableElement;
                    if (ScreenManager.this.m_showAllArea && (sVGLocatableElement = perseusController.getViewBoxMarker()) != null) {
                        object = sVGLocatableElement.getScreenBBox();
                        graphics.setColor(VIEWBOXBORDER_COLOR);
                        graphics.drawRect((int)((float)n + object.getX()), (int)((float)n2 + object.getY()), (int)object.getWidth(), (int)object.getHeight() - 1);
                    }
                    boolean bl = ScreenManager.this.m_sceneMgr.isReadOnly();
                    Object object2 = object = ScreenManager.this.m_sceneMgr.getActiveActions();
                    synchronized (object2) {
                        for (int i = ((Vector)object).size() - 1; i >= 0; --i) {
                            ((ComposerAction)((Vector)object).get(i)).paint(graphics, n, n2, bl);
                        }
                    }
                }
            }
        };
        this.m_topComponent = new JScrollPane(this.m_imageContainer);
        this.incrementChangeTicker();
    }

    public void reset() {
        this.m_topComponent = null;
        this.m_animatorView = null;
        this.m_imageContainer = null;
        this.m_cursor = null;
    }

    public SVGStatusBar getStatusBar() {
        return this.m_statusBar;
    }

    void registerMouseController(InputControlManager.MouseController mouseController) {
        this.m_animatorView.addMouseListener(mouseController);
        this.m_animatorView.addMouseMotionListener(mouseController);
        this.m_imageContainer.addMouseListener(mouseController);
    }

    public void registerKeyController(KeyListener keyListener) {
        this.m_animatorView.addKeyListener(keyListener);
    }

    public void registerPopupMenu(final Action[] actionArray, final Lookup lookup) {
        this.m_imageContainer.addMouseListener((MouseListener)new MouseUtils.PopupMouseAdapter(){

            protected void showPopup(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu = Utilities.actionsToPopup((Action[])actionArray, (Lookup)lookup);
                jPopupMenu.show(ScreenManager.this.m_imageContainer, mouseEvent.getX(), mouseEvent.getY());
            }
        });
        this.m_animatorView.addMouseListener((MouseListener)new MouseUtils.PopupMouseAdapter(){

            protected void showPopup(MouseEvent mouseEvent) {
                ScreenManager.this.m_sceneMgr.popupAt(mouseEvent.getX(), mouseEvent.getY());
                JPopupMenu jPopupMenu = Utilities.actionsToPopup((Action[])actionArray, (Lookup)lookup);
                jPopupMenu.show(ScreenManager.this.m_animatorView, mouseEvent.getX(), mouseEvent.getY());
            }
        });
    }

    public JComponent getComponent() {
        return this.m_topComponent;
    }

    public JComponent getAnimatorView() {
        return this.m_animatorView;
    }

    public Rectangle getImageBounds() {
        return this.m_animatorView.getBounds();
    }

    public void repaint(int n, int n2, int n3, int n4) {
        this.m_animatorView.repaint(n, n2, n3, n4);
    }

    public void repaint(Rectangle rectangle) {
        this.m_animatorView.repaint(rectangle);
    }

    public void repaint(Rectangle rectangle, int n) {
        this.m_animatorView.repaint(rectangle.x - n, rectangle.y - n, rectangle.width + 2 * n, rectangle.height + 2 * n);
    }

    public void setCursor(Cursor cursor) {
        if (this.m_cursor != cursor) {
            this.m_animatorView.setCursor(cursor);
            this.m_cursor = cursor;
        }
    }

    public void setShowAllArea(boolean bl) {
        if (bl != this.m_showAllArea) {
            this.m_showAllArea = bl;
            this.refresh();
            this.incrementChangeTicker();
        }
    }

    public boolean getShowAllArea() {
        return this.m_showAllArea;
    }

    public void setLandscapeMode(boolean bl) {
        if (bl != this.m_landscapeMode) {
            this.m_landscapeMode = bl;
            this.incrementChangeTicker();
        }
    }

    public boolean isLandscapeMode() {
        return this.m_landscapeMode;
    }

    public boolean setShowTooltip(boolean bl) {
        boolean bl2 = this.m_showTooltip;
        this.m_showTooltip = bl;
        return bl2;
    }

    public boolean getShowTooltip() {
        return this.m_showTooltip;
    }

    public boolean setHighlightObject(boolean bl) {
        if (bl != this.m_highlightObject) {
            this.m_highlightObject = bl;
            this.repaint();
            return !bl;
        }
        return bl;
    }

    public boolean getHighlightObject() {
        return this.m_highlightObject;
    }

    public float getZoomRatio() {
        return this.m_sceneMgr.m_zoomRatio;
    }

    public void setZoomRatio(float f) {
        if (f < 0.01f) {
            f = 0.01f;
        } else if (f > 100.0f) {
            f = 100.0f;
        }
        if (f != this.m_sceneMgr.m_zoomRatio) {
            this.m_sceneMgr.m_zoomRatio = f;
            this.refresh();
            this.incrementChangeTicker();
        }
    }

    public void repaint() {
        this.m_imageContainer.setTryPaint();
        this.m_animatorView.invalidate();
        this.m_topComponent.validate();
        this.m_animatorView.repaint();
        this.m_topComponent.repaint();
    }

    public void refresh() {
        Dimension dimension;
        if (this.m_sceneMgr.getPerseusController() == null) {
            return;
        }
        SVGSVGElement sVGSVGElement = this.m_sceneMgr.getPerseusController().getSVGRootElement();
        SVGRect sVGRect = sVGSVGElement.getRectTrait("viewBox");
        SVGPoint sVGPoint = sVGSVGElement.getCurrentTranslate();
        SVGRect sVGRect2 = null;
        boolean bl = sVGRect == null ? true : this.m_showAllArea;
        sVGPoint.setX(0.0f);
        sVGPoint.setY(0.0f);
        sVGSVGElement.setCurrentScale(1.0f);
        SVGRect sVGRect3 = sVGRect2 = bl ? sVGSVGElement.getBBox() : sVGRect;
        if (sVGRect2 != null) {
            dimension = new Dimension((int)(sVGRect2.getWidth() * this.m_sceneMgr.m_zoomRatio), (int)(sVGRect2.getHeight() * this.m_sceneMgr.m_zoomRatio));
            SVGImage sVGImage = this.m_sceneMgr.getSVGImage();
            sVGImage.setViewportWidth(dimension.width);
            sVGImage.setViewportHeight(dimension.height);
            if (bl) {
                if (sVGRect != null) {
                    double d = sVGRect.getWidth() / sVGRect2.getWidth();
                    double d2 = sVGRect.getHeight() / sVGRect2.getHeight();
                    float f = (float)Math.max(d, d2);
                    sVGSVGElement.setCurrentScale(f);
                }
                SVGRect sVGRect4 = sVGSVGElement.getScreenBBox();
                sVGPoint.setX(-sVGRect4.getX());
                sVGPoint.setY(-sVGRect4.getY());
            }
        } else {
            dimension = new Dimension(100, 100);
        }
        this.m_animatorView.setSize(dimension);
        this.repaint();
    }

    public short getChangeTicker() {
        return this.m_changeTicker;
    }

    public void incrementChangeTicker() {
        this.m_changeTicker = (short)(this.m_changeTicker + 1);
        if (this.m_changeTicker < 0) {
            this.m_changeTicker = 0;
        }
    }
}

